/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless;

import java.util.Collection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.AbstractConfigurationWizardPage;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless.ISolverPageProxy;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless.ISolverPageProxyactory;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless.SolverWizard;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless.Solvers;

class SolverSelectionPage
extends WizardPage {
    int fSelectedSolverId;
    private Combo solvers;

    protected SolverSelectionPage() {
        super("selectSolver");
        this.setTitle("Steady State Analysis");
        this.setDescription("Select solver for calculating the steady state probability distribution");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Label solverLabel = new Label(composite, 0);
        solverLabel.setText("Choose solver");
        GridData solverData = new GridData();
        solverData.horizontalSpan = 3;
        solverData.grabExcessHorizontalSpace = true;
        solverData.grabExcessVerticalSpace = false;
        solverLabel.setLayoutData((Object)solverData);
        this.solvers = new Combo(composite, 8);
        GridData comboData = new GridData();
        comboData.horizontalSpan = 3;
        comboData.grabExcessHorizontalSpace = true;
        comboData.grabExcessVerticalSpace = false;
        this.solvers.setLayoutData((Object)comboData);
        this.populateSolverCombo(this.solvers);
        this.setPageComplete(false);
        this.initSettings();
    }

    private void initSettings() {
        this.fSelectedSolverId = Integer.MIN_VALUE;
        int newSolver = (Integer)((SolverWizard)this.getWizard()).getOptionMap().get((Object)"ctmc.steadystate.solver");
        this.setSolver(newSolver);
    }

    private void setSolver(int id) {
        String name = Solvers.getInstance().getSolverName(id);
        this.solvers.setText(name);
        this.newSolverSelected(id);
    }

    private void newSolverSelected(int newSolverId) {
        this.setPageComplete(false);
        int preconditionerId = Integer.parseInt("" + ((SolverWizard)this.getWizard()).getOptionMap().get((Object)"ctmc.solver.preconditioner"));
        ISolverPageProxy solverPage = ISolverPageProxyactory.createPageFor(newSolverId, preconditionerId);
        if (solverPage == null) {
            this.setMessage(null);
            String error = "No solver available";
            this.setErrorMessage(error);
            return;
        }
        if (newSolverId != this.fSelectedSolverId) {
            AbstractConfigurationWizardPage newPage;
            ((SolverWizard)this.getWizard()).fSolverPage = newPage = solverPage.getPage();
            if (newPage != null) {
                newPage.setWizard(this.getWizard());
            }
        }
        this.fSelectedSolverId = newSolverId;
        this.setMessage(null);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void populateSolverCombo(final Combo solvers) {
        Collection<String> solverStrings = Solvers.getInstance().getAvailableSolvers();
        for (String solver : solverStrings) {
            solvers.add(solver);
        }
        solvers.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SolverSelectionPage.this.newSolverSelected(Solvers.getInstance().getSolverId(solvers.getText()));
            }
        });
    }
}

