/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Solvers {
    private HashMap<String, Integer> availableSolvers = new HashMap(5);
    private static final Solvers instance = new Solvers();

    private Solvers() {
        this.availableSolvers.put("BiConjugate Gradient (BiCG)", 0);
        this.availableSolvers.put("BiConjugate Gradient Stabilised (BiCGstab)", 1);
        this.availableSolvers.put("Conjugate Gradient (CG)", 2);
        this.availableSolvers.put("Conjugate Gradient Squared (CGS)", 3);
        this.availableSolvers.put("Iterative Refinement (IR)", 5);
        this.availableSolvers.put("Direct solver", 7);
        this.availableSolvers.put("Generalized Minimum Residual (GMRES)", 4);
        this.availableSolvers.put("Chebyshev", 8);
        this.availableSolvers.put("Hydra AIR", 12);
    }

    public static Solvers getInstance() {
        return instance;
    }

    public Collection<String> getAvailableSolvers() {
        ArrayList<String> list = new ArrayList<String>(this.availableSolvers.keySet());
        Collections.sort(list);
        return list;
    }

    public Integer getSolverId(String key) {
        return this.availableSolvers.get(key);
    }

    public String getSolverName(Integer id) {
        for (Map.Entry<String, Integer> entry : this.availableSolvers.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

