/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ExperimentationWizard;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISensibleNode;

public class ASTSelectionPage
extends WizardPage {
    public static final String NAME = "ASTSelectionPage";
    private ISensibleNode[] sensibleNodes;
    private CheckboxTableViewer viewer;

    protected ASTSelectionPage(ISensibleNode[] sensibleNodes) {
        super(NAME);
        this.sensibleNodes = sensibleNodes;
        this.setTitle("Experimentation");
        this.setDescription("Select the elements to include in experiments");
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FillLayout());
        this.setControl((Control)main);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)main, (int)0);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ASTSelectionTableProvider());
        this.viewer.setInput((Object)this.sensibleNodes);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ASTSelectionPage.this.validate();
            }
        });
        this.validate();
    }

    private void validate() {
        this.setPageComplete(this.viewer.getCheckedElements().length != 0);
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        if (complete) {
            ((ExperimentationWizard)this.getWizard()).updateSelectionPages(this.getCheckedNodes());
        }
    }

    public Object[] getCheckedNodes() {
        return this.viewer.getCheckedElements();
    }

    private class ASTSelectionTableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ASTSelectionTableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof ISensibleNode) {
                    return ((ISensibleNode)element).getName();
                }
                throw new IllegalArgumentException();
            }
            return null;
        }
    }
}

