/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotview.views.PlotView;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractPerformanceMetricFactory;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.EvaluationException;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ExperimentationWizard;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IDynamicParent;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IExperiment;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IPerformanceMetric;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;

public abstract class AbstractExperiment
implements IExperiment,
IDynamicParent {
    protected Composite performanceMetricContent;
    protected String description;
    protected Combo performanceMetrics;
    protected Text nameText;
    private AbstractPerformanceMetricFactory performanceFactory;
    private IDynamicParent dynamicParent;
    protected IPerformanceMetric currentMetric;
    private Font boldFont;

    public AbstractExperiment(String description) {
        Assert.isNotNull((Object)description);
        this.setName(description);
    }

    static void display(final IChart chart) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                Shell shell = window.getShell();
                try {
                    PlotView plotView = (PlotView)page.showView("uk.ac.ed.inf.common.ui.plotview.views.PlotView");
                    plotView.reveal(chart);
                }
                catch (PartInitException e) {
                    ErrorDialog.openError((Shell)shell, (String)"Error", (String)"Error displaying graph", (IStatus)e.getStatus());
                }
            }
        });
    }

    @Override
    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractExperiment.this.boldFont != null && !AbstractExperiment.this.boldFont.isDisposed()) {
                    AbstractExperiment.this.boldFont.dispose();
                }
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label debug = new Label(main, 64);
        debug.setText("Experiment Settings");
        FontData data = debug.getFont().getFontData()[0];
        data.setStyle(1);
        this.boldFont = new Font(debug.getFont().getDevice(), new FontData[]{data});
        debug.setFont(this.boldFont);
        debug.setLayoutData((Object)new GridData());
        Composite nameComp = new Composite(main, 0);
        nameComp.setLayoutData((Object)new GridData(768));
        GridLayout nameCompLayout = new GridLayout();
        nameCompLayout.numColumns = 1;
        nameComp.setLayout((Layout)nameCompLayout);
        Label nameLabel = new Label(nameComp, 64);
        nameLabel.setText("Name");
        nameLabel.setLayoutData((Object)new GridData());
        this.nameText = new Text(nameComp, 18432);
        this.nameText.setText(this.description);
        this.nameText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AbstractExperiment.this.setName(AbstractExperiment.this.nameText.getText());
                AbstractExperiment.this.validate();
            }
        });
        this.nameText.setLayoutData((Object)new GridData(768));
        Composite astSettings = new Composite(main, 0);
        astSettings.setLayoutData((Object)new GridData(768));
        astSettings.setLayout((Layout)new GridLayout());
        this.createASTSettings(astSettings);
        Composite performanceMetric = new Composite(main, 0);
        performanceMetric.setLayoutData((Object)new GridData(768));
        performanceMetric.setLayout((Layout)new GridLayout());
        this.createPerformanceMetric(performanceMetric);
    }

    protected abstract Composite createASTSettings(Composite var1);

    protected Composite createPerformanceMetric(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label performanceLabel = new Label(main, 0);
        performanceLabel.setText("Performance metric");
        performanceLabel.setLayoutData((Object)new GridData());
        this.performanceMetrics = new Combo(main, 8);
        this.performanceMetrics.setLayoutData((Object)new GridData(768));
        this.performanceMetrics.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractExperiment.this.createNewPerformanceMetric();
            }
        });
        this.performanceMetricContent = new Composite(main, 0);
        GridData metricContent = new GridData(1808);
        this.performanceMetricContent.setLayoutData((Object)metricContent);
        GridLayout performanceMetricContentLayout = new GridLayout();
        performanceMetricContentLayout.marginHeight = 0;
        performanceMetricContentLayout.marginWidth = 0;
        performanceMetricContentLayout.verticalSpacing = 0;
        this.performanceMetricContent.setLayout((Layout)performanceMetricContentLayout);
        this.populatePerformanceMetrics();
        return main;
    }

    private void populatePerformanceMetrics() {
        String[] stringArray = this.performanceFactory.getDescriptions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String desc = stringArray[n2];
            this.performanceMetrics.add(desc);
            ++n2;
        }
        if (this.currentMetric != null) {
            this.performanceMetrics.setText(this.currentMetric.getDescription());
            this.showPerformanceMetricContent(this.currentMetric);
        }
    }

    private void createNewPerformanceMetric() {
        String selectedText = this.performanceMetrics.getText();
        IPerformanceMetric newMetric = this.performanceFactory.createPerformanceMetric(selectedText, ((ExperimentationWizard)this.getExperimentPage().getWizard()).getEvaluator());
        newMetric.setDynamicParent(this);
        newMetric.setExperiment(this);
        this.showPerformanceMetricContent(newMetric);
    }

    private void showPerformanceMetricContent(IPerformanceMetric metric) {
        this.currentMetric = metric;
        Assert.isNotNull((Object)this.currentMetric);
        Control[] controlArray = this.performanceMetricContent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!child.isDisposed()) {
                child.dispose();
            }
            ++n2;
        }
        this.currentMetric.createControl(this.performanceMetricContent);
        this.performanceMetricContent.layout(true);
        this.validate();
    }

    protected void validate() {
        this.updateParentState();
    }

    @Override
    public void setName(String name) {
        this.description = name;
    }

    @Override
    public String getName() {
        return this.description;
    }

    @Override
    public boolean isCanRun() {
        return this.currentMetric != null && this.currentMetric.isCanEvaluate();
    }

    @Override
    public abstract void run(IProgressMonitor var1, boolean var2) throws EvaluationException;

    @Override
    public abstract void setAvailableNodes(Object[] var1);

    @Override
    public abstract void setAvailableSettings(ISetting[] var1);

    @Override
    public void setPerformanceMetricFactory(AbstractPerformanceMetricFactory factory) {
        this.performanceFactory = factory;
        Assert.isNotNull((Object)factory);
    }

    @Override
    public IDynamicParent getDynamicParent() {
        return this.dynamicParent;
    }

    @Override
    public void setDynamicParent(IDynamicParent parent) {
        this.dynamicParent = parent;
    }

    @Override
    public void updateParentState() {
        this.dynamicParent.updateParentState();
    }
}

