/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISensibleNode;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISettingPage;

public abstract class AbstractSettingPage
extends WizardPage
implements ISettingPage {
    protected ISensibleNode node;
    protected Text fromText;
    protected Text toText;
    protected Text stepText;
    protected Text listText;
    protected Button optionStepButton;
    protected Button optionListButton;
    private Label fromLabel;
    private Label toLabel;
    private Label stepLabel;
    private Label listLabel;
    private Group listValuedGroup;
    private Group fromToStepGroup;
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            AbstractSettingPage.this.setPageComplete(AbstractSettingPage.this.validate());
        }
    };

    protected AbstractSettingPage(ISensibleNode node) {
        super(node.toString());
        this.node = node;
        this.setPageComplete(false);
    }

    @Override
    public abstract ISetting getASTSetting();

    @Override
    public ISensibleNode getNode() {
        return this.node;
    }

    protected boolean validate() {
        if (this.optionListButton.getSelection()) {
            return this.validateListSection();
        }
        if (this.optionStepButton.getSelection()) {
            return this.validateStepSection();
        }
        return false;
    }

    protected abstract boolean validateStepSection();

    protected abstract boolean validateListSection();

    public void createControl(Composite parent) {
        int labelStyle = 0;
        int textStyle = 2048;
        int marginLeft = 20;
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FillLayout());
        this.setControl((Control)main);
        Group optionsGroup = new Group(main, 32);
        GridLayout optionsGroupLayout = new GridLayout();
        optionsGroupLayout.numColumns = 1;
        optionsGroup.setLayout((Layout)optionsGroupLayout);
        this.optionStepButton = new Button((Composite)optionsGroup, 16);
        this.optionStepButton.setText("Specify an interval");
        this.optionStepButton.setLayoutData((Object)new GridData(768));
        this.fromToStepGroup = new Group((Composite)optionsGroup, 32);
        this.fromToStepGroup.setText("Interval Settings");
        this.fromToStepGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = marginLeft;
        this.fromToStepGroup.setLayout((Layout)layout);
        this.fromToStepGroup.setEnabled(false);
        this.fromLabel = new Label((Composite)this.fromToStepGroup, labelStyle);
        this.fromLabel.setText("From:");
        this.fromLabel.setLayoutData((Object)new GridData(768));
        this.fromLabel.setEnabled(false);
        this.fromText = new Text((Composite)this.fromToStepGroup, textStyle);
        this.fromText.addListener(24, this.listener);
        this.fromText.setLayoutData((Object)new GridData(768));
        this.fromText.setEnabled(false);
        this.toLabel = new Label((Composite)this.fromToStepGroup, labelStyle);
        this.toLabel.setText("To:");
        this.toLabel.setLayoutData((Object)new GridData(768));
        this.toLabel.setEnabled(false);
        this.toText = new Text((Composite)this.fromToStepGroup, textStyle);
        this.toText.addListener(24, this.listener);
        this.toText.setLayoutData((Object)new GridData(768));
        this.toText.setEnabled(false);
        this.stepLabel = new Label((Composite)this.fromToStepGroup, labelStyle);
        this.stepLabel.setText("Step:");
        this.stepLabel.setLayoutData((Object)new GridData(768));
        this.stepLabel.setEnabled(false);
        this.stepText = new Text((Composite)this.fromToStepGroup, textStyle);
        this.stepText.addListener(24, this.listener);
        this.stepText.setLayoutData((Object)new GridData(768));
        this.stepText.setEnabled(false);
        this.optionListButton = new Button((Composite)optionsGroup, 16);
        this.optionListButton.setText("Specify comma-separated list");
        this.optionListButton.setLayoutData((Object)new GridData(768));
        this.listValuedGroup = new Group((Composite)optionsGroup, 64);
        this.listValuedGroup.setText("List Settings");
        GridLayout listLayout = new GridLayout();
        listLayout.numColumns = 2;
        listLayout.marginLeft = marginLeft;
        this.listValuedGroup.setLayout((Layout)listLayout);
        this.listValuedGroup.setLayoutData((Object)new GridData(768));
        this.listValuedGroup.setEnabled(false);
        this.listLabel = new Label((Composite)this.listValuedGroup, labelStyle);
        this.listLabel.setText("Insert list:");
        this.listLabel.setLayoutData((Object)new GridData(768));
        this.listLabel.setEnabled(false);
        this.listText = new Text((Composite)this.listValuedGroup, textStyle);
        this.listText.addListener(24, this.listener);
        this.listText.setLayoutData((Object)new GridData(768));
        this.listText.setEnabled(false);
        this.initialiseValues();
        this.optionStepButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractSettingPage.this.enableWidgets();
                AbstractSettingPage.this.validate();
                if (AbstractSettingPage.this.optionStepButton.getSelection()) {
                    AbstractSettingPage.this.fromText.setFocus();
                }
            }
        });
        this.optionListButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractSettingPage.this.enableWidgets();
                AbstractSettingPage.this.validate();
                if (AbstractSettingPage.this.optionListButton.getSelection()) {
                    AbstractSettingPage.this.listText.setFocus();
                }
            }
        });
        this.setPageComplete(this.validate());
    }

    private void enableWidgets() {
        boolean stepOpt = this.optionStepButton.getSelection();
        this.fromText.setEnabled(stepOpt);
        this.fromLabel.setEnabled(stepOpt);
        this.toText.setEnabled(stepOpt);
        this.toLabel.setEnabled(stepOpt);
        this.stepText.setEnabled(stepOpt);
        this.stepLabel.setEnabled(stepOpt);
        this.fromToStepGroup.setEnabled(stepOpt);
        this.listValuedGroup.setEnabled(!stepOpt);
        this.listText.setEnabled(!stepOpt);
        this.listLabel.setEnabled(!stepOpt);
    }

    protected abstract void initialiseValues();
}

