/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractExperiment;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.EvaluationException;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ExperimentPage;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;
import uk.ac.ed.inf.pepa.parsing.ASTNode;

public class BasicXYExperiment
extends AbstractExperiment {
    protected ISetting[] settings = new ISetting[0];
    protected ISetting xAxisSetting = null;
    private Composite composite = null;
    private Combo xAxis;
    private ExperimentPage experimentPage;

    public BasicXYExperiment(String description) {
        super(description);
    }

    @Override
    protected Composite createASTSettings(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginWidth = 0;
        compositeLayout.marginHeight = 0;
        this.composite.setLayout((Layout)compositeLayout);
        this.composite.setLayoutData((Object)new GridData(1808));
        Composite main = new Composite(this.composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label xAxisLabel = new Label(main, 0);
        xAxisLabel.setText("X Axis");
        xAxisLabel.setLayoutData((Object)new GridData());
        this.xAxis = new Combo(main, 8);
        this.xAxis.setLayoutData((Object)new GridData(768));
        this.xAxis.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Object o = BasicXYExperiment.this.xAxis.getData(BasicXYExperiment.this.xAxis.getText());
                if (o == null || !(o instanceof ISetting)) {
                    return;
                }
                BasicXYExperiment.this.xAxisSetting = (ISetting)o;
                BasicXYExperiment.this.validate();
            }
        });
        this.populateXAxis();
        return this.composite;
    }

    private void populateXAxis() {
        this.xAxis.removeAll();
        ISetting[] iSettingArray = this.settings;
        int n = this.settings.length;
        int n2 = 0;
        while (n2 < n) {
            ISetting setting = iSettingArray[n2];
            this.xAxis.add(setting.getDescription());
            this.xAxis.setData(setting.getDescription(), (Object)setting);
            ++n2;
        }
        if (this.xAxisSetting != null) {
            int i = 0;
            while (i < this.xAxis.getItemCount()) {
                if (this.xAxis.getData(this.xAxis.getItem(i)) == this.xAxisSetting) {
                    this.xAxis.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isCanRun() {
        return super.isCanRun() && this.xAxisSetting != null;
    }

    @Override
    public void run(IProgressMonitor monitor, boolean showAsYouGo) throws EvaluationException {
        Assert.isTrue((boolean)this.isCanRun(), (String)"Making sure that the experiment can be run");
        int numSettings = this.xAxisSetting.getSettingCount();
        monitor.beginTask(this.getName(), numSettings);
        monitor.subTask(String.valueOf(this.getName()) + " Generating graph");
        InfoWithAxes info = new InfoWithAxes();
        info.setGraphTitle(this.getName());
        info.setHas3DEffect(false);
        info.setShowLegend(false);
        double[] xValues = new double[numSettings];
        double[] yValues = new double[numSettings];
        ISetting[] settings = new ISetting[]{this.xAxisSetting};
        int[] currentIndex = new int[1];
        boolean isCanceled = false;
        int i = 0;
        while (i < numSettings) {
            if (monitor.isCanceled()) {
                isCanceled = true;
                break;
            }
            monitor.subTask(String.valueOf(this.getName()) + " [" + (i + 1) + "/" + numSettings + "]");
            currentIndex[0] = i;
            xValues[i] = this.xAxisSetting.getSetting(i);
            yValues[i] = this.currentMetric.evaluate(settings, currentIndex);
            monitor.worked(1);
            ++i;
        }
        info.setXSeries(Series.create((double[])xValues, (String)this.xAxisSetting.getDescription()));
        info.getYSeries().add(Series.create((double[])yValues, (String)this.currentMetric.getLabel()));
        info.setYLabel(this.currentMetric.getLabel());
        if (!isCanceled) {
            IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
            BasicXYExperiment.display(chart);
        }
        monitor.done();
    }

    @Override
    public void setAvailableNodes(Object[] astNodes) {
        if (this.xAxisSetting == null) {
            return;
        }
        boolean found = false;
        Object[] objectArray = astNodes;
        int n = astNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object astNode = objectArray[n2];
            ASTNode node = (ASTNode)astNode;
            if (this.xAxisSetting.getSensibleNode() == node) {
                found = true;
                break;
            }
            ++n2;
        }
        this.currentSettingFoundAfterUpdate(found);
    }

    @Override
    public void setAvailableSettings(ISetting[] settings) {
        Assert.isNotNull((Object)settings, (String)"At least one ASTSetting needed");
        this.settings = settings;
        boolean found = false;
        ISetting[] iSettingArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            ISetting newSetting = iSettingArray[n2];
            if (newSetting == this.xAxisSetting) {
                found = true;
                break;
            }
            ++n2;
        }
        this.currentSettingFoundAfterUpdate(found);
    }

    private void currentSettingFoundAfterUpdate(boolean found) {
        if (!found) {
            this.xAxisSetting = null;
        }
        if (this.composite != null && !this.composite.isDisposed()) {
            this.populateXAxis();
        }
        this.validate();
    }

    @Override
    public void dispose() {
        this.composite.dispose();
    }

    @Override
    public ExperimentPage getExperimentPage() {
        return this.experimentPage;
    }

    @Override
    public void setExperimentPage(ExperimentPage page) {
        this.experimentPage = page;
    }
}

