/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractPerformanceMetricFactory;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.FilteredStateSpaceOverallProbability;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IEvaluator;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IPerformanceMetric;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.pepa.PEPAThroughputPerformanceMetric;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.pepa.UtilisationPerformanceMetric;

public class ConcretePerformanceMetricFactory
extends AbstractPerformanceMetricFactory {
    private static final String OVERALL_STEADY_STATE = "Steady-state Probability";
    private static final String THROUGHPUT = "Throughput";
    private static final String UTILISATION = "Utilisation";
    private static final String[] DESCRIPTIONS = new String[]{"Steady-state Probability", "Throughput", "Utilisation"};

    @Override
    public IPerformanceMetric createPerformanceMetric(String description, IEvaluator evaluator) {
        if (THROUGHPUT.equals(description)) {
            return new PEPAThroughputPerformanceMetric(description, evaluator);
        }
        if (UTILISATION.equals(description)) {
            return new UtilisationPerformanceMetric(description, evaluator);
        }
        if (OVERALL_STEADY_STATE.equals(description)) {
            return new FilteredStateSpaceOverallProbability(description, evaluator);
        }
        return null;
    }

    @Override
    public String[] getDescriptions() {
        return DESCRIPTIONS;
    }
}

