/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractExperimentFactory;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractPerformanceMetricFactory;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IDynamicParent;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IExperiment;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;

public class ExperimentPage
extends WizardPage
implements IDynamicParent {
    private AbstractExperimentFactory experimentFactory;
    private AbstractPerformanceMetricFactory performanceFactory;
    private ArrayList<IExperiment> managedExperiments = new ArrayList();
    private ISetting[] currentSettings = new ISetting[0];
    private ListViewer experiments;
    private NewExperimentAction newExperimentAction;
    private Action removeExperimentAction;
    private Composite experimentSettingsComposite;
    private Font boldFont;

    protected ExperimentPage(AbstractExperimentFactory experimentFactory, AbstractPerformanceMetricFactory performanceFactory) {
        super("Experiment Page");
        this.experimentFactory = experimentFactory;
        this.performanceFactory = performanceFactory;
        this.setTitle("Experiments");
        this.setDescription("");
        Assert.isNotNull((Object)experimentFactory);
    }

    public void updateAvailableSettings(ISetting[] newSettings) {
        this.currentSettings = newSettings;
        Assert.isNotNull((Object)newSettings);
        for (IExperiment e : this.managedExperiments) {
            e.setAvailableSettings(newSettings);
        }
        this.updateParentState();
    }

    public void updateAvailableNodes(Object[] astNodes) {
        for (IExperiment e : this.managedExperiments) {
            e.setAvailableNodes(astNodes);
        }
        this.updateParentState();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        main.setLayout((Layout)layout);
        this.setControl((Control)main);
        Composite lhs = new Composite(main, 0);
        lhs.setLayoutData((Object)new GridData(1808));
        GridLayout lhsLayout = new GridLayout();
        lhsLayout.numColumns = 1;
        lhs.setLayout((Layout)lhsLayout);
        Label listLabel = new Label(lhs, 64);
        listLabel.setText("All Experiments");
        FontData data = listLabel.getFont().getFontData()[0];
        data.setStyle(1);
        this.boldFont = new Font(listLabel.getFont().getDevice(), new FontData[]{data});
        listLabel.setFont(this.boldFont);
        listLabel.setLayoutData((Object)new GridData(768));
        this.experiments = new ListViewer(lhs, 2052);
        GridData listLayoutData = new GridData(1808);
        this.experiments.getList().setLayoutData((Object)listLayoutData);
        this.experiments.setLabelProvider((IBaseLabelProvider)new ExperimentLabelProvider());
        this.experiments.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.experiments.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    IExperiment selectedExperiment = (IExperiment)selection.getFirstElement();
                    ExperimentPage.this.showExperiment(selectedExperiment);
                    ExperimentPage.this.setPageComplete(ExperimentPage.this.validate());
                }
            }
        });
        this.experiments.setInput(this.managedExperiments);
        this.experimentSettingsComposite = new Composite(main, 0);
        this.experimentSettingsComposite.setLayoutData((Object)new GridData(1808));
        GridLayout experimentSettingsLayout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.experimentSettingsComposite.setLayout((Layout)experimentSettingsLayout);
        this.createActions();
        this.createContextMenu();
        this.setPageComplete(this.validate());
    }

    public void dispose() {
        if (this.boldFont != null && !this.boldFont.isDisposed()) {
            this.boldFont.dispose();
        }
        super.dispose();
    }

    private void updatePage() {
        this.experiments.refresh();
        this.setPageComplete(this.validate());
    }

    private void createActions() {
        this.newExperimentAction = new NewExperimentAction();
        this.removeExperimentAction = new Action(){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)ExperimentPage.this.experiments.getSelection();
                IExperiment experiment = (IExperiment)sel.getFirstElement();
                if (!ExperimentPage.this.managedExperiments.remove(experiment)) {
                    MessageDialog.openError((Shell)ExperimentPage.this.getShell(), (String)"Experiment not found", (String)(String.valueOf(experiment.getName()) + " not found"));
                }
                ExperimentPage.this.showExperiment(null);
                ExperimentPage.this.updatePage();
                ExperimentPage.this.experiments.getList().setFocus();
            }
        };
        this.removeExperimentAction.setText("Delete");
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(this.experiments.getControl());
        this.experiments.getControl().setMenu(menu);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExperimentPage.this.fillActionsInContextMenu(manager);
            }
        });
    }

    private void showExperiment(IExperiment e) {
        Control[] controlArray = this.experimentSettingsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!child.isDisposed()) {
                child.dispose();
            }
            ++n2;
        }
        if (e != null) {
            e.createControl(this.experimentSettingsComposite);
        }
        this.experimentSettingsComposite.layout(true);
    }

    private void fillActionsInContextMenu(IMenuManager manager) {
        manager.add((IAction)this.newExperimentAction);
        if (!this.experiments.getSelection().isEmpty()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.removeExperimentAction);
        }
    }

    private boolean validate() {
        if (this.managedExperiments.size() == 0) {
            return false;
        }
        for (IExperiment e : this.managedExperiments) {
            if (e.isCanRun()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateParentState() {
        this.updatePage();
    }

    public IExperiment[] getExperiments() {
        return this.managedExperiments.toArray(new IExperiment[this.managedExperiments.size()]);
    }

    private class ExperimentLabelProvider
    extends LabelProvider {
        private ExperimentLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            IExperiment experiment = (IExperiment)element;
            return experiment.getName();
        }
    }

    private class NewExperimentAction
    extends Action
    implements IMenuCreator {
        private Menu menu;

        public NewExperimentAction() {
            super("", 4);
            this.setText("New");
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            return null;
        }

        public Menu getMenu(Menu parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            String[] stringArray = ExperimentPage.this.experimentFactory.getDescriptions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String description = stringArray[n2];
                ActionContributionItem item = new ActionContributionItem((IAction)new AddAction(description));
                item.fill(this.menu, -1);
                ++n2;
            }
            return this.menu;
        }

        private class AddAction
        extends Action {
            private String description;

            AddAction(String experimentDescription) {
                this.description = experimentDescription;
                this.setText(experimentDescription);
            }

            public void run() {
                IExperiment newExperiment = ExperimentPage.this.experimentFactory.createExperiment(this.description);
                newExperiment.setDynamicParent(ExperimentPage.this);
                newExperiment.setAvailableSettings(ExperimentPage.this.currentSettings);
                newExperiment.setPerformanceMetricFactory(ExperimentPage.this.performanceFactory);
                newExperiment.setExperimentPage(ExperimentPage.this);
                ExperimentPage.this.managedExperiments.add(newExperiment);
                ExperimentPage.this.updatePage();
                ExperimentPage.this.experiments.setSelection((ISelection)new StructuredSelection((Object)newExperiment));
            }
        }
    }
}

