/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.EvaluationException;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IExperiment;

public class ExperimentationJob
extends Job {
    private IExperiment[] experiments;
    private boolean showAsYouGo;

    public ExperimentationJob(IExperiment[] experiments, boolean showAsYouGo) {
        super("Experimentation");
        Assert.isNotNull((Object)experiments);
        Assert.isTrue((experiments.length > 0 ? 1 : 0) != 0);
        this.experiments = experiments;
        this.showAsYouGo = showAsYouGo;
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean isCanceled = false;
        monitor.beginTask("Experiments", this.experiments.length * 100);
        int i = 0;
        while (i < this.experiments.length) {
            if (monitor.isCanceled()) {
                isCanceled = true;
                break;
            }
            monitor.subTask(this.experiments[i].getName());
            Assert.isNotNull((Object)this.experiments[i].isCanRun());
            try {
                this.experiments[i].run((IProgressMonitor)new SubProgressMonitor(monitor, 100), this.showAsYouGo);
            }
            catch (EvaluationException e) {
                PepaLog.logError((Throwable)e);
                return this.createErrorStatus(e);
            }
            ++i;
        }
        monitor.done();
        if (!isCanceled) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus createErrorStatus(EvaluationException e) {
        return new Status(4, "uk.ac.ed.inf.pepa.eclipse.ui", 0, e.getMessage(), (Throwable)e);
    }
}

