/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ASTSelectionPage;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractExperimentFactory;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractPerformanceMetricFactory;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ConcreteExperimentFactory;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ExperimentPage;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ExperimentationJob;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IEvaluator;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISensibleNode;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISettingPage;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.SettingPageFactory;

public class ExperimentationWizard
extends Wizard {
    private ASTSelectionPage selectionPage;
    private ExperimentPage experimentPage;
    private ISettingPage[] settingPages = new ISettingPage[0];
    private AbstractExperimentFactory experimentFactory = new ConcreteExperimentFactory();
    private AbstractPerformanceMetricFactory performanceMetricFactory;
    private IEvaluator evaluator;

    public ExperimentationWizard(IEvaluator evaluator, AbstractPerformanceMetricFactory performanceMetricFactory) {
        if (evaluator.getProcessAlgebraModel() == null) {
            throw new NullPointerException("Model cannot be null");
        }
        this.performanceMetricFactory = performanceMetricFactory;
        this.evaluator = evaluator;
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
    }

    public IProcessAlgebraModel getProcessAlgebraModel() {
        return this.evaluator.getProcessAlgebraModel();
    }

    public IEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void addPages() {
        this.selectionPage = new ASTSelectionPage(this.evaluator.getSensibleNodes());
        this.experimentPage = new ExperimentPage(this.experimentFactory, this.performanceMetricFactory);
        this.addPage((IWizardPage)this.selectionPage);
        this.addPage((IWizardPage)this.experimentPage);
    }

    public boolean performFinish() {
        ExperimentationJob myJob = new ExperimentationJob(this.experimentPage.getExperiments(), false);
        myJob.schedule();
        return true;
    }

    public void updateSelectionPages(Object[] selectedNodes) {
        ISettingPage[] newPages = new ISettingPage[selectedNodes.length];
        int i = 0;
        while (i < selectedNodes.length) {
            boolean found = false;
            ISettingPage[] iSettingPageArray = this.settingPages;
            int n = this.settingPages.length;
            int n2 = 0;
            while (n2 < n) {
                ISettingPage page = iSettingPageArray[n2];
                if (selectedNodes[i] == page.getNode()) {
                    newPages[i] = page;
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                newPages[i] = SettingPageFactory.createSettingPage((ISensibleNode)selectedNodes[i]);
                newPages[i].setWizard((IWizard)this);
            }
            ++i;
        }
        this.settingPages = newPages;
        this.experimentPage.updateAvailableNodes(selectedNodes);
        this.getContainer().updateButtons();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectionPage && this.settingPages.length != 0) {
            return this.settingPages[0];
        }
        int i = 0;
        while (i < this.settingPages.length) {
            if (page == this.settingPages[i]) {
                if (i < this.settingPages.length - 1) {
                    return this.settingPages[i + 1];
                }
                if (i == this.settingPages.length - 1) {
                    ISetting[] settings = new ISetting[this.settingPages.length];
                    int index = 0;
                    while (index < this.settingPages.length) {
                        settings[index] = this.settingPages[index].getASTSetting();
                        ++index;
                    }
                    this.experimentPage.updateAvailableSettings(settings);
                    return this.experimentPage;
                }
            }
            ++i;
        }
        return null;
    }

    public IWizardPage getStartingPage() {
        return this.selectionPage;
    }

    public boolean canFinish() {
        if (!this.selectionPage.isPageComplete()) {
            return false;
        }
        ISettingPage[] iSettingPageArray = this.settingPages;
        int n = this.settingPages.length;
        int n2 = 0;
        while (n2 < n) {
            ISettingPage page = iSettingPageArray[n2];
            if (!page.isPageComplete()) {
                return false;
            }
            ++n2;
        }
        return this.experimentPage.isPageComplete();
    }
}

