/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.ed.inf.pepa.ctmc.derivation.IFilterRunner;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.ui.Activator;
import uk.ac.ed.inf.pepa.eclipse.ui.IFilterManager;
import uk.ac.ed.inf.pepa.eclipse.ui.IFilterModel;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractPerformanceMetric;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.EvaluationException;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IEvaluator;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IExperiment;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;

public class FilteredStateSpaceOverallProbability
extends AbstractPerformanceMetric {
    private Combo combo;
    private IFilterManager filterManager;
    private IFilterModel selectedFilterSet = null;
    private IStateSpaceFilter[] filters;

    public FilteredStateSpaceOverallProbability(String description, IEvaluator evaluator) {
        super(description, evaluator);
    }

    @Override
    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 64);
        label.setText("Filter name");
        label.setLayoutData((Object)new GridData());
        this.combo = new Combo(main, 8);
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FilteredStateSpaceOverallProbability.this.handleSelection();
            }
        });
        this.populateCombo();
    }

    private void populateCombo() {
        IFilterModel[] iFilterModelArray = this.filterManager.getFilterModels();
        int n = iFilterModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFilterModel filterModel = iFilterModelArray[n2];
            this.combo.add(filterModel.getName());
            this.combo.setData(filterModel.getName(), (Object)filterModel);
            ++n2;
        }
        if (this.selectedFilterSet != null) {
            int i = 0;
            while (i < this.combo.getItemCount()) {
                if (this.combo.getItem(i).equals(this.selectedFilterSet.getName())) {
                    this.combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void handleSelection() {
        Object data = this.combo.getData(this.combo.getText());
        IFilterModel iFilterModel = this.selectedFilterSet = data != null ? (IFilterModel)data : null;
        if (this.selectedFilterSet != null) {
            this.filters = this.selectedFilterSet.getFilters();
        }
        this.parent.updateParentState();
    }

    @Override
    public double evaluate(ISetting[] settings, int[] currentIndex) throws EvaluationException {
        double result = 0.0;
        try {
            IStateSpace ss = this.evaluator.doEvaluate(settings, currentIndex);
            IFilterRunner[] runners = new IFilterRunner[this.filters.length];
            int j = 0;
            while (j < runners.length) {
                runners[j] = this.filters[j].getRunner(ss);
                ++j;
            }
            int s = 0;
            while (s < ss.size()) {
                boolean makesAll = true;
                IFilterRunner[] iFilterRunnerArray = runners;
                int n = runners.length;
                int n2 = 0;
                while (n2 < n) {
                    IFilterRunner runner = iFilterRunnerArray[n2];
                    if (!runner.select(s)) {
                        makesAll = false;
                        break;
                    }
                    ++n2;
                }
                if (makesAll) {
                    result += ss.getSolution(s);
                }
                ++s;
            }
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
            throw new EvaluationException(e);
        }
        return result;
    }

    @Override
    public boolean isCanEvaluate() {
        return this.filters != null && this.filters.length != 0;
    }

    @Override
    public void setExperiment(IExperiment experiment) {
        super.setExperiment(experiment);
        this.filterManager = Activator.getDefault().getFilterManagerProvider().getFilterManager(this.getModel());
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.getDescription()) + ": " + this.selectedFilterSet.getName();
    }
}

