/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISensibleNode;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;

class RateASTSetting
implements ISetting {
    private ISensibleNode node;
    private final ArrayList<Double> settings;
    private String description;

    public RateASTSetting(ISensibleNode node) {
        this.node = node;
        this.settings = new ArrayList();
    }

    public void updateSettings(double from, double to, double step) {
        this.settings.clear();
        double value = from;
        while (value <= to) {
            this.settings.add(value);
            value += step;
        }
        this.setDescription();
    }

    public void updateSettings(double[] list) {
        this.settings.clear();
        double[] dArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            this.settings.add(value);
            ++n2;
        }
        this.setDescription();
    }

    private void setDescription() {
        StringBuffer desc = new StringBuffer();
        desc.append("Rate " + this.node.getName());
        this.description = desc.toString();
    }

    @Override
    public ISensibleNode getSensibleNode() {
        return this.node;
    }

    @Override
    public int getSettingCount() {
        return this.settings.size();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public double getSetting(int index) {
        this.checkIndex(index);
        return this.settings.get(index);
    }

    private void checkIndex(int index) {
        Assert.isTrue((index >= 0 && index < this.settings.size() ? 1 : 0) != 0);
    }
}

