/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractSettingPage;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISensibleNode;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.RateASTSetting;

public class RateSettingPage
extends AbstractSettingPage {
    private RateASTSetting settings;
    private double from;
    private double to;
    private double step;
    private double[] list;

    protected RateSettingPage(ISensibleNode node) {
        super(node);
        this.setTitle("Experiment Settings");
        this.setDescription("Configure parameters for rate " + node.getName());
        this.settings = new RateASTSetting(node);
    }

    @Override
    public ISetting getASTSetting() {
        if (!this.isPageComplete()) {
            return null;
        }
        if (this.optionStepButton.getSelection()) {
            this.settings.updateSettings(this.from, this.to, this.step);
        } else {
            this.settings.updateSettings(this.list);
        }
        return this.settings;
    }

    @Override
    protected void initialiseValues() {
        this.fromText.setText("");
        this.toText.setText("");
        this.stepText.setText("");
        this.listText.setText("");
    }

    @Override
    protected boolean validateStepSection() {
        try {
            this.from = Double.parseDouble(this.fromText.getText());
            this.to = Double.parseDouble(this.toText.getText());
            this.step = Double.parseDouble(this.stepText.getText());
        }
        catch (Exception exception) {
            return false;
        }
        if (this.from <= 0.0 || this.to <= 0.0 || this.step <= 0.0) {
            return false;
        }
        return this.from <= this.to;
    }

    @Override
    protected boolean validateListSection() {
        String[] values = this.listText.getText().split(",");
        if (values.length == 0) {
            return false;
        }
        this.list = new double[values.length];
        int i = 0;
        while (i < values.length) {
            block6: {
                try {
                    this.list[i] = Double.parseDouble(values[i]);
                    if (!(this.list[i] <= 0.0)) break block6;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (i > 0 && this.list[i] <= this.list[i - i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

