/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractPerformanceMetric;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.EvaluationException;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IEvaluator;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;

public abstract class ThroughputPerformanceMetric
extends AbstractPerformanceMetric {
    private Combo combo;
    private String lastValue = null;

    public ThroughputPerformanceMetric(String description, IEvaluator evaluator) {
        super(description, evaluator);
    }

    protected abstract Collection<String> fillActionTypes();

    @Override
    public void createControl(Composite parent) {
        Collection<String> actionTypes = this.fillActionTypes();
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 64);
        label.setText("Action");
        label.setLayoutData((Object)new GridData());
        this.combo = new Combo(main, 8);
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ThroughputPerformanceMetric.this.handleSelection();
            }
        });
        this.populateCombo(actionTypes);
    }

    private void populateCombo(Collection<String> actionTypes) {
        for (String action : actionTypes) {
            this.combo.add(action);
        }
        if (this.lastValue != null) {
            this.combo.setText(this.lastValue);
        }
    }

    private void handleSelection() {
        this.lastValue = this.combo.getText();
        this.parent.updateParentState();
    }

    @Override
    public double evaluate(ISetting[] settings, int[] currentIndex) throws EvaluationException {
        double result = Double.NaN;
        try {
            ThroughputResult[] results;
            IStateSpace ss = this.evaluator.doEvaluate(settings, currentIndex);
            ThroughputResult[] throughputResultArray = results = ss.getThroughput();
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                ThroughputResult r = throughputResultArray[n2];
                if (r.getActionType().equals(this.lastValue)) {
                    result = r.getThroughput();
                    break;
                }
                ++n2;
            }
            Assert.isTrue((!Double.isNaN(result) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
            e.printStackTrace();
            throw new EvaluationException(e);
        }
        return result;
    }

    @Override
    public boolean isCanEvaluate() {
        return this.lastValue != null;
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.getDescription()) + ": " + this.lastValue;
    }
}

