/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.pepa.eclipse.ui.view.Tools;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.BasicXYExperiment;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.EvaluationException;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;
import uk.ac.ed.inf.pepa.parsing.ASTNode;

public class XYParameterExperiment
extends BasicXYExperiment {
    private Combo parameterCombo;
    private Composite main;
    private ISetting parameterSetting;

    public XYParameterExperiment(String description) {
        super(description);
    }

    @Override
    protected Composite createASTSettings(Composite parent) {
        Composite composite = super.createASTSettings(parent);
        this.main = new Composite(composite, 0);
        this.main.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.main.setLayout((Layout)layout);
        Label label = new Label(this.main, 0);
        label.setText("Parameter");
        label.setLayoutData((Object)new GridData());
        this.parameterCombo = new Combo(this.main, 8);
        this.parameterCombo.setLayoutData((Object)new GridData(768));
        this.parameterCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Object o = XYParameterExperiment.this.parameterCombo.getData(XYParameterExperiment.this.parameterCombo.getText());
                if (o == null || !(o instanceof ISetting)) {
                    return;
                }
                XYParameterExperiment.this.parameterSetting = (ISetting)o;
                XYParameterExperiment.this.validate();
            }
        });
        this.populateParameter();
        return composite;
    }

    private void populateParameter() {
        this.parameterCombo.removeAll();
        ISetting[] iSettingArray = this.settings;
        int n = this.settings.length;
        int n2 = 0;
        while (n2 < n) {
            ISetting setting = iSettingArray[n2];
            this.parameterCombo.add(setting.getDescription());
            this.parameterCombo.setData(setting.getDescription(), (Object)setting);
            ++n2;
        }
        if (this.parameterSetting != null) {
            int i = 0;
            while (i < this.parameterCombo.getItemCount()) {
                if (this.parameterCombo.getData(this.parameterCombo.getItem(i)) == this.parameterSetting) {
                    this.parameterCombo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isCanRun() {
        return super.isCanRun() && this.parameterSetting != null && this.parameterSetting != this.xAxisSetting;
    }

    @Override
    public void run(IProgressMonitor monitor, boolean showAsYouGo) throws EvaluationException {
        Assert.isTrue((boolean)this.isCanRun());
        int xAxisSettings = this.xAxisSetting.getSettingCount();
        int parameterSettings = this.parameterSetting.getSettingCount();
        int totalSettings = xAxisSettings * parameterSettings;
        String[] parameterLabels = this.generateLabelsForParameter();
        monitor.beginTask(this.getName(), xAxisSettings * parameterSettings);
        monitor.subTask(String.valueOf(this.getName()) + " Generating graph");
        InfoWithAxes info = new InfoWithAxes();
        info.setGraphTitle(this.getName());
        info.setHas3DEffect(false);
        info.setShowLegend(true);
        info.setShowMarkers(false);
        double[] xValues = new double[xAxisSettings];
        double[][] yValues = new double[parameterSettings][xAxisSettings];
        boolean isCanceled = false;
        ISetting[] sensibleNodes = new ISetting[]{this.xAxisSetting, this.parameterSetting};
        int[] values = new int[2];
        int j = 0;
        while (j < xAxisSettings) {
            xValues[j] = this.xAxisSetting.getSetting(j);
            values[0] = j;
            int i = 0;
            while (i < parameterSettings) {
                if (monitor.isCanceled()) {
                    isCanceled = true;
                    break;
                }
                monitor.subTask(String.valueOf(this.getName()) + " [" + (i + j + 1) + "/" + totalSettings + "]");
                values[1] = i;
                yValues[i][j] = this.currentMetric.evaluate(sensibleNodes, values);
                monitor.worked(1);
                ++i;
            }
            if (isCanceled) break;
            ++j;
        }
        if (!isCanceled) {
            info.setXSeries(Series.create((double[])xValues, (String)this.xAxisSetting.getDescription()));
            int p = 0;
            while (p < parameterSettings) {
                Series series = Series.create((double[])yValues[p], (String)parameterLabels[p]);
                info.getYSeries().add(series);
                ++p;
            }
            IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
            XYParameterExperiment.display(chart);
        }
        monitor.done();
    }

    private String[] generateLabelsForParameter() {
        String[] labels = new String[this.parameterSetting.getSettingCount()];
        int i = 0;
        while (i < labels.length) {
            labels[i] = String.valueOf(this.parameterSetting.getDescription()) + " " + Tools.format(this.parameterSetting.getSetting(i));
            ++i;
        }
        return labels;
    }

    @Override
    public void setAvailableNodes(Object[] astNodes) {
        super.setAvailableNodes(astNodes);
        if (this.parameterSetting == null) {
            return;
        }
        boolean found = false;
        Object[] objectArray = astNodes;
        int n = astNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object astNode = objectArray[n2];
            ASTNode node = (ASTNode)astNode;
            if (this.parameterSetting.getSensibleNode() == node) {
                found = true;
                break;
            }
            ++n2;
        }
        this.currentSettingFoundAfterUpdate(found);
    }

    @Override
    public void setAvailableSettings(ISetting[] settings) {
        super.setAvailableSettings(settings);
        boolean found = false;
        ISetting[] iSettingArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            ISetting newSetting = iSettingArray[n2];
            if (newSetting == this.parameterSetting) {
                found = true;
                break;
            }
            ++n2;
        }
        this.currentSettingFoundAfterUpdate(found);
    }

    private void currentSettingFoundAfterUpdate(boolean found) {
        if (!found) {
            this.parameterSetting = null;
        }
        if (this.main != null && !this.main.isDisposed()) {
            this.populateParameter();
        }
        this.validate();
    }
}

