/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.pepa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverFactory;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IEvaluator;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISensibleNode;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;
import uk.ac.ed.inf.pepa.parsing.ASTFactory;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ASTSupport;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.RateNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class PEPAEvaluator
implements IEvaluator {
    private ISensibleNode[] nodes;
    private IPepaModel model;

    public PEPAEvaluator(IPepaModel model) {
        this.model = model;
        ArrayList<1> sensibleNodes = new ArrayList<1>();
        for (RateDefinitionNode n : model.getAST().rateDefinitions()) {
            final String name = n.getName().getName();
            sensibleNodes.add(new ISensibleNode(){

                @Override
                public String getName() {
                    return name;
                }
            });
        }
        Collections.sort(sensibleNodes, new Comparator<ISensibleNode>(){

            @Override
            public int compare(ISensibleNode o1, ISensibleNode o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.nodes = sensibleNodes.toArray(new ISensibleNode[sensibleNodes.size()]);
    }

    @Override
    public ISensibleNode[] getSensibleNodes() {
        return this.nodes;
    }

    @Override
    public IStateSpace doEvaluate(ISetting[] settings, int[] currentIndex) throws Exception {
        OptionMap map = this.model.getOptionMap();
        if (!(this.model instanceof IPepaModel)) {
            throw new IllegalStateException("Excepted PEPA model");
        }
        IPepaModel pepaModel = this.model;
        ModelNode modelNode = (ModelNode)ASTSupport.copy((ASTNode)pepaModel.getAST());
        int i = 0;
        while (i < settings.length) {
            boolean found = false;
            for (RateDefinitionNode rd : modelNode.rateDefinitions()) {
                if (!rd.getName().getName().equals(settings[i].getSensibleNode().getName())) continue;
                RateDoubleNode newRate = ASTFactory.createRate();
                newRate.setValue(settings[i].getSetting(currentIndex[i]));
                rd.setRate((RateNode)newRate);
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Setting not found");
            }
            ++i;
        }
        IStateSpace ss = PepaTools.derive((OptionMap)map, (ModelNode)modelNode, null, null);
        ISolver solver = SolverFactory.createSolver((IStateSpace)ss, (OptionMap)map);
        ss.setSolution(solver.solve(null));
        return ss;
    }

    @Override
    public IProcessAlgebraModel getProcessAlgebraModel() {
        return this.model;
    }
}

