/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.pepa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.ed.inf.pepa.analysis.StaticAnalyser;
import uk.ac.ed.inf.pepa.ctmc.LocalState;
import uk.ac.ed.inf.pepa.ctmc.SequentialComponent;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.AbstractPerformanceMetric;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.EvaluationException;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ExperimentationWizard;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.IEvaluator;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ISetting;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ASTSupport;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.DefaultVisitor;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessNode;

public class UtilisationPerformanceMetric
extends AbstractPerformanceMetric {
    private Combo combo;
    private String lastValue = null;
    private int position = -1;
    private Set<String> topLevelComponentName = new TreeSet<String>();
    private ArrayList<ProcessNode> topLevelComponents = new ArrayList();

    public UtilisationPerformanceMetric(String description, IEvaluator evaluator) {
        super(description, evaluator);
    }

    private void fillActionTypes(ModelNode model) {
        IWizard wizard = this.experiment.getExperimentPage().getWizard();
        Assert.isTrue((boolean)(wizard instanceof ExperimentationWizard));
        ((IPepaModel)this.getModel()).getAST().accept((ASTVisitor)new DefaultVisitor(){

            public void visitModelNode(ModelNode model) {
                model.getSystemEquation().accept((ASTVisitor)this);
            }

            public void visitCooperationNode(CooperationNode coop) {
                coop.getLeft().accept((ASTVisitor)this);
                coop.getRight().accept((ASTVisitor)this);
            }

            public void visitHidingNode(HidingNode hiding) {
                hiding.getProcess().accept((ASTVisitor)this);
            }

            public void visitConstantProcessNode(ConstantProcessNode constant) {
                UtilisationPerformanceMetric.this.topLevelComponents.add(constant);
                UtilisationPerformanceMetric.this.topLevelComponentName.addAll((Collection)((IPepaModel)UtilisationPerformanceMetric.this.getModel()).getStaticAnalyser().getAlphabetProvider().getProcessAlphabets().get(constant.getName()));
            }

            public void visitPrefixNode(PrefixNode prefix) {
                UtilisationPerformanceMetric.this.topLevelComponents.add(prefix);
            }

            public void visitAggregationNode(AggregationNode aggregation) {
                UtilisationPerformanceMetric.this.topLevelComponents.add(null);
            }
        });
    }

    @Override
    public void createControl(Composite parent) {
        this.fillActionTypes(((IPepaModel)this.getModel()).getAST());
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 64);
        label.setText("Local state");
        label.setLayoutData((Object)new GridData());
        this.combo = new Combo(main, 8);
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UtilisationPerformanceMetric.this.handleSelection();
            }
        });
        this.populateCombo();
    }

    private void populateCombo() {
        for (String action : this.topLevelComponentName) {
            this.combo.add(action);
        }
        if (this.lastValue != null) {
            this.combo.setText(this.lastValue);
        }
    }

    private void handleSelection() {
        int[] positions;
        this.lastValue = this.combo.getText();
        int[] nArray = positions = this.getPositions(this.lastValue);
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            System.err.println("Position for " + this.lastValue + ":" + p);
            ++n2;
        }
        this.position = positions.length > 1 ? this.openWarningDialogBox(positions) : positions[0];
        this.parent.updateParentState();
    }

    private int openWarningDialogBox(final int[] positions) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                int position = -1;
                try {
                    position = Integer.parseInt(newText);
                }
                catch (Exception exception) {
                    return "Insert a correct position";
                }
                boolean found = false;
                int[] nArray = positions;
                int n = positions.length;
                int n2 = 0;
                while (n2 < n) {
                    int p = nArray[n2];
                    if (position == p) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    return "Position must be one of: " + UtilisationPerformanceMetric.this.getString(positions);
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.getExperiment().getExperimentPage().getShell(), "Repeated sequential component", "This sequential component may appear in different positions (" + this.getString(positions) + "). Select your position of interest.", String.valueOf(positions[0]), validator);
        String value = null;
        value = dialog.open() != 0 ? Integer.toString(positions[0]) : dialog.getValue();
        return Integer.parseInt(value);
    }

    private String getString(int[] positions) {
        StringBuffer buf = new StringBuffer();
        int[] nArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            buf.append(String.valueOf(p) + ",");
            ++n2;
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    private int[] getPositions(String componentName) {
        StaticAnalyser analyser = ((IPepaModel)this.getModel()).getStaticAnalyser();
        Assert.isNotNull((Object)analyser);
        ArrayList<Integer> list = new ArrayList<Integer>();
        int position = 0;
        while (position < this.topLevelComponents.size()) {
            ProcessNode node = this.topLevelComponents.get(position);
            if (node != null) {
                String topLevelName = ASTSupport.toString((ASTNode)node);
                if (((HashSet)analyser.getAlphabetProvider().getProcessAlphabets().get(topLevelName)).contains(componentName)) {
                    list.add(position);
                }
            }
            ++position;
        }
        int[] result = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            result[i] = (Integer)list.get(i);
            ++i;
        }
        return result;
    }

    @Override
    public double evaluate(ISetting[] settings, int[] currentIndex) throws EvaluationException {
        double result = Double.NaN;
        try {
            IStateSpace ss = this.evaluator.doEvaluate(settings, currentIndex);
            SequentialComponent[] utilisation = ss.getUtilisation();
            SequentialComponent c = utilisation[this.position];
            LocalState[] localStateArray = c.getLocalStates();
            int n = localStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                LocalState s = localStateArray[n2];
                if (s.getName().equals(this.lastValue)) {
                    result = s.getUtilisation();
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
            throw new EvaluationException(e);
        }
        if (Double.isNaN(result)) {
            throw new EvaluationException(new IllegalStateException("No utilisation found"));
        }
        return result;
    }

    @Override
    public boolean isCanEvaluate() {
        return this.lastValue != null;
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.getDescription()) + ": " + this.lastValue;
    }
}

