/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.sba.SBAParseException;

public class AlgorithmWizardPage
extends WizardPage {
    public static final String name = "Algorithm";
    Listener controlListener;
    HashMap<Control, OptionsMap.Parameter> controlMap;
    boolean firstUse = true;
    boolean saveCMDLPossible = true;
    boolean booleanSaveCMDL;
    HashSet<OptionsMap.Parameter> invalidParameters;
    IPepaModel model;
    Group optionsGroup;
    OptionsMap optionsMap;
    Combo solverCombo;
    Composite solverComposite;
    Button saveCMDL;
    OptionsMap.Solver[] solvers;

    protected AlgorithmWizardPage(IPepaModel model, OptionsMap optionsMap) {
        super(name);
        this.model = model;
        this.optionsMap = optionsMap;
        this.controlMap = new HashMap();
        this.invalidParameters = new HashSet();
        this.setTitle("Solver selection and Parameter input");
        OptionsMap.Solver currentSolver = (OptionsMap.Solver)this.optionsMap.getValue(OptionsMap.Parameter.Solver);
        this.setPageComplete(false);
        OptionsMap.Solver[] solverArray = this.solvers = model.getValidTimeSeriesSolvers();
        int n = this.solvers.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsMap.Solver solver = solverArray[n2];
            if (solver.equals((Object)currentSolver)) {
                this.setPageComplete(true);
                break;
            }
            ++n2;
        }
    }

    public void algorithmChanged() {
        OptionsMap.Parameter[] parameters;
        this.controlMap.clear();
        this.invalidParameters.clear();
        Control[] controlArray = this.optionsGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!child.isDisposed()) {
                child.dispose();
            }
            ++n2;
        }
        OptionsMap.Solver solver = (OptionsMap.Solver)this.optionsMap.getValue(OptionsMap.Parameter.Solver);
        this.setDescription("Parameters required for " + solver.getDescriptiveName());
        OptionsMap.Parameter[] parameterArray = parameters = solver.getRequiredParameters();
        int n3 = parameters.length;
        int n4 = 0;
        while (n4 < n3) {
            OptionsMap.Parameter parameter = parameterArray[n4];
            if (!parameter.equals((Object)OptionsMap.Parameter.Components)) {
                Label label = new Label((Composite)this.optionsGroup, 16384);
                label.setText(parameter.toString());
                Class c = parameter.getType();
                if (Number.class.isAssignableFrom(c)) {
                    Text control = new Text((Composite)this.optionsGroup, 131076);
                    control.setText(this.optionsMap.getValue(parameter).toString());
                    control.addListener(24, this.controlListener);
                    control.setLayoutData((Object)new GridData(768));
                    this.controlMap.put((Control)control, parameter);
                }
            }
            ++n4;
        }
        this.optionsGroup.layout();
        this.solverComposite.layout();
        this.validatePage();
    }

    public void createControl(Composite parent) {
        this.solverComposite = new Composite(parent, 0);
        this.solverComposite.setLayout((Layout)new FormLayout());
        this.solverCombo = new Combo(this.solverComposite, 8);
        this.saveCMDL = new Button(this.solverComposite, 32);
        this.saveCMDL.setText("Save model in CMDL and Matlab format");
        this.saveCMDL.setToolTipText("Save As Dialog for Matlab file will open when you click on finish");
        this.saveCMDL.setEnabled(this.saveCMDLPossible);
        this.solverCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AlgorithmWizardPage.this.solverSelected();
            }
        });
        this.optionsGroup = new Group(this.solverComposite, 0);
        this.optionsGroup.setText("Solver Parameters");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.optionsGroup.setLayout((Layout)layout);
        int i = 0;
        while (i < 16) {
            new Label((Composite)this.optionsGroup, 16384);
            ++i;
        }
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                Control control = (Control)event.widget;
                OptionsMap.Parameter parameter = AlgorithmWizardPage.this.controlMap.get(control);
                try {
                    if (control instanceof Text) {
                        AlgorithmWizardPage.this.optionsMap.setValue(parameter, (Object)((Text)control).getText());
                    }
                    AlgorithmWizardPage.this.invalidParameters.remove(parameter);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    AlgorithmWizardPage.this.invalidParameters.add(parameter);
                }
                AlgorithmWizardPage.this.validatePage();
            }
        };
        this.saveCMDL.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AlgorithmWizardPage.this.booleanSaveCMDL = ((Button)e.widget).getSelection();
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        this.saveCMDL.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.saveCMDL, 20);
        formData.left = new FormAttachment(0);
        this.solverCombo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.solverCombo);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.optionsGroup.setLayoutData((Object)formData);
        this.setControl((Control)this.solverComposite);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.solverCombo.removeAll();
            this.solvers = this.model.getValidTimeSeriesSolvers();
            if (this.solvers.length == 0) {
                PepaLog.logError((Throwable)new SBAParseException("No valid solvers."));
                this.getWizard().dispose();
            }
            OptionsMap.Solver[] solverArray = this.solvers;
            int n = this.solvers.length;
            int n2 = 0;
            while (n2 < n) {
                OptionsMap.Solver solver = solverArray[n2];
                this.solverCombo.add(solver.getDescriptiveName());
                ++n2;
            }
            OptionsMap.Solver currentSolver = (OptionsMap.Solver)this.optionsMap.getValue(OptionsMap.Parameter.Solver);
            int i = 0;
            while (i < this.solvers.length) {
                if (this.solvers[i].equals((Object)currentSolver)) {
                    this.solverCombo.select(i);
                    break;
                }
                ++i;
            }
            if (i == this.solvers.length) {
                this.solverCombo.select(0);
            }
            this.solverSelected();
        }
        super.setVisible(visible);
    }

    private void solverSelected() {
        int index = this.solverCombo.getSelectionIndex();
        if (index != -1) {
            this.optionsMap.setValue(OptionsMap.Parameter.Solver, (Object)this.solvers[index]);
            this.algorithmChanged();
        }
    }

    private void validatePage() {
        if (this.invalidParameters.isEmpty()) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
        } else {
            this.setPageComplete(false);
            this.setErrorMessage("Invalid value entered for " + this.invalidParameters.iterator().next().toString());
        }
    }

    public void disableCMDLSave() {
        if (this.saveCMDL != null) {
            this.saveCMDL.setEnabled(false);
        }
        this.saveCMDLPossible = false;
    }

    boolean saveCMDL() {
        return this.saveCMDL.isEnabled() && this.booleanSaveCMDL;
    }
}

