/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.ISemanticElement;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.common.ui.plotview.PlotViewPlugin;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.sba.Results;
import uk.ac.ed.inf.pepa.sba.SBASimulatorException;

public class AnalysisJob
extends Job {
    private static String term = System.getProperty("line.separator");
    IPepaModel model;
    OptionsMap optionsMap;

    AnalysisJob(String title, IPepaModel model, OptionsMap optionsMap) {
        super(title);
        this.model = model;
        this.optionsMap = optionsMap;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.model.generateTimeSeries(this.optionsMap, monitor);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Results results = this.model.getTimeSeries();
            String[] names = results.getSpeciesOrdering();
            ArrayList<String> namesArrayList = new ArrayList<String>();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                namesArrayList.add(s);
                ++n2;
            }
            double[][] values = results.getSimpleTimeSeries();
            this.newApi(names, values);
        }
        catch (SBASimulatorException e) {
            PepaLog.logError((Throwable)e);
            return new Status(4, "uk.ac.ed.inf.pepa.eclipse.ui", 0, e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void newApi(String[] labels, double[][] values) {
        double[][] results = new double[values[0].length][values.length];
        int timePoint = 0;
        while (timePoint < values.length) {
            int component = 0;
            while (component < values[0].length) {
                results[component][timePoint] = values[timePoint][component];
                ++component;
            }
            ++timePoint;
        }
        InfoWithAxes info = new InfoWithAxes();
        info.setXSeries(Series.create((double[])results[0], (String)"Time"));
        int i = 0;
        while (i < labels.length) {
            info.getYSeries().add(Series.create((double[])results[i + 1], (String)labels[i]));
            ++i;
        }
        info.setShowLegend(true);
        info.setYLabel("Population");
        info.setGraphTitle("Time series analysis");
        info.setHas3DEffect(false);
        info.setShowMarkers(false);
        IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
        chart.setSemanticElement((ISemanticElement)new ResultsAdapter());
        PlotViewPlugin.getDefault().reveal(chart);
    }

    private class ResultsAdapter
    implements ISemanticElement {
        String semanticElement;

        ResultsAdapter() {
            OptionsMap.Parameter[] parameters;
            StringBuilder sb = new StringBuilder();
            OptionsMap.Solver solver = (OptionsMap.Solver)AnalysisJob.this.optionsMap.getValue(OptionsMap.Parameter.Solver);
            sb.append("Simulator: ").append(solver.getDescriptiveName()).append(term);
            OptionsMap.Parameter[] parameterArray = parameters = solver.getRequiredParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                OptionsMap.Parameter parameter = parameterArray[n2];
                if (!parameter.equals((Object)OptionsMap.Parameter.Components)) {
                    sb.append(parameter.toString()).append(": ").append(AnalysisJob.this.optionsMap.serialise(parameter)).append(term);
                }
                ++n2;
            }
            this.semanticElement = sb.toString();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getDescription(String format) {
            StringBuilder sb = new StringBuilder();
            if ("CSV".equals(format)) {
                OptionsMap.Parameter[] parameters;
                OptionsMap.Solver solver = (OptionsMap.Solver)AnalysisJob.this.optionsMap.getValue(OptionsMap.Parameter.Solver);
                sb.append("# Simulator: ").append(solver.getDescriptiveName()).append(term);
                OptionsMap.Parameter[] parameterArray = parameters = solver.getRequiredParameters();
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    OptionsMap.Parameter parameter = parameterArray[n2];
                    if (!parameter.equals((Object)OptionsMap.Parameter.Components)) {
                        sb.append("# ").append(parameter.toString()).append(": ").append(AnalysisJob.this.optionsMap.serialise(parameter)).append(term);
                    }
                    ++n2;
                }
            }
            return sb.toString();
        }
    }
}

