/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis;

import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.analysis.StaticAnalyser;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayModel;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModelChangedListener;
import uk.ac.ed.inf.pepa.eclipse.core.PEPAModelChecker;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.AlgorithmWizardPage;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.AnalysisJob;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.SpeciesSelectionWizardPage;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.sba.Mapping;
import uk.ac.ed.inf.pepa.sba.Results;
import uk.ac.ed.inf.pepa.sba.SBAParseException;
import uk.ac.ed.inf.pepa.sba.SBAReaction;
import uk.ac.ed.inf.pepa.sba.SBASimulatorException;
import uk.ac.ed.inf.pepa.sba.SBAtoISBJava;

public class CMDLWizard
extends Wizard {
    CMDLsubPEPAModel model = new CMDLsubPEPAModel();
    OptionsMap optionsMap;

    public CMDLWizard(IResource resource, SBAtoISBJava model) {
        this.model.model = model;
        this.model.resource = resource;
        this.optionsMap = new OptionsMap();
    }

    public void addPages() {
        SpeciesSelectionWizardPage sswp = new SpeciesSelectionWizardPage(this.model, this.optionsMap);
        this.addPage((IWizardPage)sswp);
        AlgorithmWizardPage awp = new AlgorithmWizardPage(this.model, this.optionsMap);
        awp.disableCMDLSave();
        this.addPage((IWizardPage)awp);
    }

    public boolean performFinish() {
        String title = this.model.getUnderlyingResource().getName();
        title = title.substring(0, title.length() - 5);
        OptionsMap.Solver solver = (OptionsMap.Solver)this.optionsMap.getValue(OptionsMap.Parameter.Solver);
        title = String.valueOf(title) + " - " + solver.getDescriptiveName();
        OptionsMap.Parameter[] parameterArray = solver.getRequiredParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsMap.Parameter parameter = parameterArray[n2];
            if (parameter.equals((Object)OptionsMap.Parameter.Independent_Replications)) {
                title = String.valueOf(title) + ". " + Integer.toString((Integer)this.optionsMap.getValue(OptionsMap.Parameter.Independent_Replications)) + " replications";
            }
            ++n2;
        }
        double start = (Double)this.optionsMap.getValue(OptionsMap.Parameter.Start_Time);
        double stop = (Double)this.optionsMap.getValue(OptionsMap.Parameter.Stop_Time);
        title = String.valueOf(title) + " with duration " + Double.toString(stop - start);
        AnalysisJob myJob = new AnalysisJob(title, this.model, this.optionsMap);
        myJob.schedule();
        return true;
    }

    private class CMDLsubPEPAModel
    implements IPepaModel {
        Results fResults = null;
        SBAtoISBJava model;
        IResource resource;

        private CMDLsubPEPAModel() {
        }

        public void addModelChangedListener(IProcessAlgebraModelChangedListener listener) {
        }

        public void derive(OptionMap map, org.eclipse.core.runtime.IProgressMonitor monitor) throws DerivationException {
        }

        public void dispose() {
        }

        public boolean generateReactions() throws SBAParseException {
            return false;
        }

        public void generateTimeSeries(OptionsMap options, org.eclipse.core.runtime.IProgressMonitor monitor) throws SBASimulatorException {
            SBASimulatorException sbaSE = null;
            try {
                this.model.initialiseSimulator(options);
                this.fResults = null;
                this.fResults = this.model.runModel((IProgressMonitor)(monitor == null ? null : new CMDLProgressMonitorAdapter(monitor, "Time Series Analysis")));
            }
            catch (SBASimulatorException e) {
                sbaSE = e;
            }
            catch (Exception e) {
                sbaSE = new SBASimulatorException(e.getMessage(), (Throwable)e);
            }
            if (sbaSE != null) {
                throw sbaSE;
            }
        }

        public ModelNode getAST() {
            return null;
        }

        public KroneckerDisplayModel getDisplayModel() {
            return null;
        }

        public String getCMDL() {
            return null;
        }

        public String getMatlab() {
            return null;
        }

        public Mapping getMapping() {
            return this.model.getMapping();
        }

        public Set<SBAReaction> getReactions() {
            return null;
        }

        public IStateSpace getStateSpace() {
            return null;
        }

        public Results getTimeSeries() {
            return this.fResults;
        }

        public IResource getUnderlyingResource() {
            return this.resource;
        }

        public OptionsMap.Solver[] getValidTimeSeriesSolvers() {
            return this.model.getPermissibleSolvers();
        }

        public boolean isDerivable() {
            return false;
        }

        public boolean isParsable() {
            return false;
        }

        public IPepaModel.PEPAForm[] isSBAParseable() {
            return new IPepaModel.PEPAForm[]{IPepaModel.PEPAForm.REAGENT_CENTRIC};
        }

        public boolean isSolvable() {
            return false;
        }

        public boolean isSolved() {
            return false;
        }

        public void parse() throws CoreException {
        }

        public void removeModelChangedListener(IProcessAlgebraModelChangedListener listener) {
        }

        public boolean sbaParse() throws SBAParseException {
            return false;
        }

        public void setApparentRateUse(boolean apparentRate) {
        }

        public void setForm(IPepaModel.PEPAForm newForm) {
        }

        public void solveCTMCSteadyState(OptionMap options, org.eclipse.core.runtime.IProgressMonitor monitor) throws SolverException {
        }

        public void updateReactions(Set<SBAReaction> updatedReactions) {
        }

        public StaticAnalyser getStaticAnalyser() {
            return null;
        }

        public void derive(org.eclipse.core.runtime.IProgressMonitor monitor) throws DerivationException {
        }

        public OptionMap getOptionMap() {
            throw new IllegalStateException();
        }

        public void setOptionMap(OptionMap map) {
            throw new IllegalStateException();
        }

        public void solveCTMCSteadyState(org.eclipse.core.runtime.IProgressMonitor monitor) throws SolverException {
            throw new IllegalStateException();
        }

        public Object getOption(String key) {
            throw new IllegalStateException();
        }

        public IResource getResource() {
            throw new IllegalStateException();
        }

        public void setSolution(double[] solution) {
            throw new IllegalStateException();
        }

        public PEPAModelChecker getModelChecker(double boundAccuracy) {
            return null;
        }

        class CMDLProgressMonitorAdapter
        implements IProgressMonitor {
            org.eclipse.core.runtime.IProgressMonitor eclispeMonitor;
            String name;

            CMDLProgressMonitorAdapter(org.eclipse.core.runtime.IProgressMonitor monitor, String name) {
                this.eclispeMonitor = monitor;
                this.name = name;
            }

            public void beginTask(int amount) {
                int eclipseAmount = amount == -1 ? -1 : amount;
                this.eclispeMonitor.beginTask(this.name, eclipseAmount);
            }

            public void done() {
                this.eclispeMonitor.done();
            }

            public boolean isCanceled() {
                return this.eclispeMonitor.isCanceled();
            }

            public void setCanceled(boolean state) {
            }

            public void worked(int worked) {
                this.eclispeMonitor.worked(worked);
            }
        }
    }
}

