/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoOptionForwarder;

public class FormSelectionWizardPage
extends WizardPage {
    public static String name = "FormSelection";
    IPepaModel.PEPAForm chosenForm = null;
    IPepaModel model;

    protected FormSelectionWizardPage(IPepaModel model) {
        super(name);
        this.model = model;
        this.setTitle("Model Options");
        this.setDescription("Permissible options when the PEPA model matches more than one legal style.");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        Composite formComposite = new Composite(composite, 0);
        formComposite.setLayout((Layout)new RowLayout(512));
        String persistentForm = null;
        try {
            persistentForm = PepatoOptionForwarder.getOptionFromPersistentResource((IResource)this.model.getUnderlyingResource(), (String)(String.valueOf(this.getName()) + ".form"));
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
        }
        if (persistentForm == null || persistentForm == "") {
            persistentForm = IPepaModel.PEPAForm.PEPA.name();
        }
        IPepaModel.PEPAForm[] pEPAFormArray = this.model.isSBAParseable();
        int n = pEPAFormArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IPepaModel.PEPAForm form = pEPAFormArray[n2];
            Button button = new Button(formComposite, 16);
            button.setText(form.toString());
            button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        FormSelectionWizardPage.this.model.setForm(form);
                        FormSelectionWizardPage.this.chosenForm = form;
                    }
                }
            });
            if (form.name().equals(persistentForm)) {
                button.setSelection(true);
                this.model.setForm(form);
                this.chosenForm = form;
            }
            ++n2;
        }
        this.setControl((Control)composite);
    }

    public IPepaModel.PEPAForm getForm() {
        return this.chosenForm;
    }

    void saveOptions() {
        try {
            PepatoOptionForwarder.saveOptionInPersistentResource((IResource)this.model.getUnderlyingResource(), (String)(String.valueOf(this.getName()) + ".form"), (Object)this.chosenForm.name());
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
        }
    }
}

