/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.SpeciesSelectionWizardPage;

public class OutputOptionsWizardPage
extends WizardPage
implements SpeciesSelectionWizardPage.SpeciesSelectionListener {
    public static final String name = "OutputOptions";
    boolean add;
    boolean first;
    boolean booleanSaveCMDL;
    boolean booleanSaveResult;
    boolean column3Visible;
    boolean saveCMDLPossible;
    Map<String, Set<String>> amalgamatedComponents;
    private Font bold;
    Table componentTable;
    Graph currentGraph;
    ArrayList<Graph> graphs = new ArrayList();
    TableViewer graphTable;
    Tree graphTree;
    ArrayList<String> ordering;
    Text resultsFileText;
    Text title;
    Text xAxis;
    Text yAxis;
    Button saveCMDL;
    Button saveResult;
    String stringSaveResult;

    protected OutputOptionsWizardPage() {
        super(name);
        FontData boldFontData = this.getFont().getFontData()[0];
        boldFontData.setStyle(1);
        this.bold = new Font(this.getFont().getDevice(), new FontData[]{boldFontData});
        this.first = true;
        this.booleanSaveResult = false;
        this.booleanSaveCMDL = false;
        this.saveCMDLPossible = true;
        this.setTitle("Output and Graph Options");
        this.setDescription("This pages allows the recording of certain information to disk and the ability to create multiple graphs from one dataset.");
    }

    void checkPage() {
        boolean allUsed = true;
        this.setPageComplete(!allUsed);
        HashSet<String> selectedSoFar = new HashSet<String>();
        for (Graph graph : this.graphs) {
            for (TreeItem treeItem : graph.components.keySet()) {
                selectedSoFar.add(treeItem.getText());
            }
        }
        TableItem[] tableItemArray = this.componentTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object tableItem = tableItemArray[n2];
            if (!selectedSoFar.contains(tableItem.getText())) {
                tableItem.setFont(this.bold);
                allUsed = false;
            } else {
                tableItem.setFont(this.getFont());
            }
            ++n2;
        }
        this.setPageComplete(allUsed);
        this.setErrorMessage(allUsed ? null : "Highlighted components in list are not associated with any defined graph.");
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new FormLayout());
        Group outputOptionsGroup = this.createDiskGroup(mainComposite);
        Group graphOptionsGroup = this.createGraphGroup(mainComposite);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        outputOptionsGroup.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)outputOptionsGroup);
        formData.bottom = new FormAttachment(100);
        graphOptionsGroup.setLayoutData((Object)formData);
        this.setControl((Control)mainComposite);
    }

    private Group createDiskGroup(Composite parent) {
        Group outputOptionsGroup = new Group(parent, 0);
        outputOptionsGroup.setLayout((Layout)new FormLayout());
        outputOptionsGroup.setText("Disk Options");
        this.saveCMDL = new Button((Composite)outputOptionsGroup, 32);
        this.saveCMDL.setText("Save model in CMDL format");
        this.saveCMDL.setToolTipText("Chemical Model Definition Language. A format compatible with Dizzy.");
        this.saveCMDL.setEnabled(this.saveCMDLPossible);
        this.saveResult = new Button((Composite)outputOptionsGroup, 32);
        this.saveResult.setText("Save results to disk");
        this.saveResult.setToolTipText("Results are saved as CSV using the 2 character string 'comma + space' as the delimiter.");
        this.saveResult.setEnabled(false);
        Label redirectLabel = new Label((Composite)outputOptionsGroup, 0);
        redirectLabel.setText("Please use the 'Export to CSV' button from within the Graph View.");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        this.saveCMDL.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.saveCMDL);
        formData.left = new FormAttachment(0);
        this.saveResult.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.saveResult, 10);
        formData.left = new FormAttachment((Control)outputOptionsGroup, 0, 0x1000000);
        redirectLabel.setLayoutData((Object)formData);
        return outputOptionsGroup;
    }

    private Group createGraphGroup(Composite parent) {
        Group graphOptionsGroup = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        graphOptionsGroup.setLayout((Layout)gridLayout);
        graphOptionsGroup.setText("Graph options");
        this.graphTree = new Tree((Composite)graphOptionsGroup, 0);
        int height = this.graphTree.getItemHeight();
        TreeItem treeItem = new TreeItem(this.graphTree, 0);
        final Button modifySelection = new Button((Composite)graphOptionsGroup, 0);
        modifySelection.setText("<<");
        modifySelection.setEnabled(false);
        this.add = false;
        this.componentTable = new Table((Composite)graphOptionsGroup, 2);
        Composite composite = new Composite((Composite)graphOptionsGroup, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.pack = false;
        composite.setLayout((Layout)rowLayout);
        Button addGraph = new Button(composite, 0x1000000);
        addGraph.setText(" + ");
        addGraph.setToolTipText("Create another graph to draw from these results");
        final Button removeGraph = new Button(composite, 0x1000000);
        removeGraph.setText(" - ");
        removeGraph.setToolTipText("Remove previously created graph");
        removeGraph.setEnabled(false);
        Group graphTableOptions = new Group((Composite)graphOptionsGroup, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        graphTableOptions.setLayout((Layout)gridLayout);
        treeItem.setText("Graph 1");
        Graph graph = new Graph(treeItem);
        this.graphs.add(graph);
        this.updateList();
        this.currentGraph = graph;
        this.graphTable = new TableViewer((Composite)graphTableOptions);
        Table table = this.graphTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText("Component");
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText("Label as will appear on graph");
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText("Summation of");
        this.graphTable.setLabelProvider((IBaseLabelProvider)new ComponentTableLabelProvider());
        this.graphTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.graphTable.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.graphTable.getTable()), new TextCellEditor((Composite)this.graphTable.getTable()), new TextCellEditor((Composite)this.graphTable.getTable())});
        this.graphTable.setColumnProperties(new String[]{"Name", "Label", "Summation"});
        this.graphTable.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals("Label");
            }

            public Object getValue(Object element, String property) {
                return ((Map.Entry)element).getValue();
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                Map.Entry me = (Map.Entry)element;
                OutputOptionsWizardPage.this.currentGraph.updateLabel((TreeItem)me.getKey(), (String)value);
                OutputOptionsWizardPage.this.updateTableView();
            }
        });
        this.graphTable.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof Item) {
                    e1 = ((Item)e1).getData();
                    e2 = ((Item)e2).getData();
                }
                return ((TreeItem)((Map.Entry)e1).getKey()).getText().compareTo(((TreeItem)((Map.Entry)e2).getKey()).getText());
            }
        });
        Label titleLabel = new Label((Composite)graphTableOptions, 0);
        titleLabel.setText("Title:");
        this.title = new Text((Composite)graphTableOptions, 0);
        Label xAxisLabel = new Label((Composite)graphTableOptions, 0);
        xAxisLabel.setText("x-axis:");
        this.xAxis = new Text((Composite)graphTableOptions, 0);
        Label yAxisLabel = new Label((Composite)graphTableOptions, 0);
        yAxisLabel.setText("y-axis:");
        this.yAxis = new Text((Composite)graphTableOptions, 0);
        this.graphTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeItem = (TreeItem)e.item;
                removeGraph.setEnabled(false);
                for (Graph graph : OutputOptionsWizardPage.this.graphs) {
                    if (graph.graphTreeItem.equals(treeItem)) {
                        OutputOptionsWizardPage.this.currentGraph = graph;
                        OutputOptionsWizardPage.this.updateTableView();
                        removeGraph.setEnabled(true);
                        modifySelection.setEnabled(false);
                        return;
                    }
                    if (!graph.components.containsKey(treeItem)) continue;
                    OutputOptionsWizardPage.this.currentGraph = graph;
                    OutputOptionsWizardPage.this.updateTableView();
                    modifySelection.setEnabled(true);
                    return;
                }
            }
        });
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.widget == OutputOptionsWizardPage.this.graphTree) {
                    modifySelection.setText(">>");
                    OutputOptionsWizardPage.this.add = false;
                    modifySelection.setEnabled(!removeGraph.isEnabled());
                } else if (e.widget == OutputOptionsWizardPage.this.componentTable) {
                    modifySelection.setText("<<");
                    OutputOptionsWizardPage.this.add = true;
                    modifySelection.setEnabled(OutputOptionsWizardPage.this.graphs.size() > 0);
                }
            }

            public void focusLost(FocusEvent e) {
            }
        };
        this.graphTree.addFocusListener(focusListener);
        this.componentTable.addFocusListener(focusListener);
        addGraph.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeItem = new TreeItem(OutputOptionsWizardPage.this.graphTree, 0);
                treeItem.setText("Graph " + (OutputOptionsWizardPage.this.graphs.size() + 1));
                Graph graph = new Graph(treeItem);
                OutputOptionsWizardPage.this.graphs.add(graph);
                OutputOptionsWizardPage.this.graphTree.setFocus();
            }
        });
        removeGraph.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeItem = OutputOptionsWizardPage.this.graphTree.getSelection()[0];
                for (Graph graph : OutputOptionsWizardPage.this.graphs) {
                    if (!graph.graphTreeItem.equals(treeItem)) continue;
                    treeItem.dispose();
                    OutputOptionsWizardPage.this.graphs.remove(graph);
                    break;
                }
                OutputOptionsWizardPage.this.currentGraph = null;
                OutputOptionsWizardPage.this.updateTableView();
                OutputOptionsWizardPage.this.checkPage();
                OutputOptionsWizardPage.this.graphTree.setFocus();
            }
        });
        modifySelection.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeItem = OutputOptionsWizardPage.this.graphTree.getSelection()[0];
                if (OutputOptionsWizardPage.this.add) {
                    for (Graph graph : OutputOptionsWizardPage.this.graphs) {
                        if (!graph.graphTreeItem.equals(treeItem) && !graph.components.containsKey(treeItem)) continue;
                        graph.addSelection(OutputOptionsWizardPage.this.componentTable.getSelection());
                        graph.graphTreeItem.setExpanded(true);
                        break;
                    }
                    OutputOptionsWizardPage.this.componentTable.setFocus();
                } else {
                    for (Graph graph : OutputOptionsWizardPage.this.graphs) {
                        if (!graph.components.containsKey(treeItem)) continue;
                        graph.removeComponent(treeItem);
                        treeItem.dispose();
                        break;
                    }
                    OutputOptionsWizardPage.this.graphTree.setFocus();
                }
                OutputOptionsWizardPage.this.updateTableView();
                OutputOptionsWizardPage.this.checkPage();
            }
        });
        this.title.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OutputOptionsWizardPage.this.currentGraph != null) {
                    OutputOptionsWizardPage.this.currentGraph.title = OutputOptionsWizardPage.this.title.getText();
                    OutputOptionsWizardPage.this.currentGraph.graphTreeItem.setText(OutputOptionsWizardPage.this.currentGraph.title);
                    Group group = (Group)OutputOptionsWizardPage.this.graphTable.getTable().getParent();
                    group.setText(OutputOptionsWizardPage.this.currentGraph.title);
                }
            }
        });
        this.xAxis.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OutputOptionsWizardPage.this.currentGraph != null) {
                    OutputOptionsWizardPage.this.currentGraph.xAxis = OutputOptionsWizardPage.this.xAxis.getText();
                }
            }
        });
        this.yAxis.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OutputOptionsWizardPage.this.currentGraph != null) {
                    OutputOptionsWizardPage.this.currentGraph.yAxis = OutputOptionsWizardPage.this.yAxis.getText();
                }
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = height * 5;
        this.graphTree.setLayoutData((Object)gridData);
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        modifySelection.setLayoutData((Object)gridData);
        gridData = new GridData(0x1000000, 4, false, false);
        gridData.heightHint = height * 5;
        this.componentTable.setLayoutData((Object)gridData);
        gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalSpan = 3;
        composite.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        graphTableOptions.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.heightHint = height * 6;
        this.graphTable.getTable().setLayoutData((Object)gridData);
        gridData = new GridData(1, 1, false, false);
        titleLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, false);
        this.title.setLayoutData((Object)gridData);
        gridData = new GridData(1, 1, false, false);
        xAxisLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, false);
        this.xAxis.setLayoutData((Object)gridData);
        gridData = new GridData(1, 1, false, false);
        yAxisLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, false);
        this.yAxis.setLayoutData((Object)gridData);
        return graphOptionsGroup;
    }

    public void disableCMDLSave() {
        if (this.saveCMDL != null) {
            this.saveCMDL.setEnabled(false);
        }
        this.saveCMDLPossible = false;
    }

    public List<Graph> getGraphs() {
        if (this.first) {
            this.updateList();
        }
        for (Graph graph : this.graphs) {
            graph.amalgamations = this.amalgamatedComponents;
            graph.ordering = this.ordering;
        }
        return this.graphs;
    }

    boolean saveCMDL() {
        return this.saveCMDL.isEnabled() && this.booleanSaveCMDL;
    }

    String saveResults() {
        if (this.booleanSaveResult) {
            return this.stringSaveResult;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        this.first = false;
        if (visible) {
            this.updateList();
        }
        super.setVisible(visible);
    }

    void updateList() {
        this.componentTable.removeAll();
        if (this.ordering != null) {
            for (String component : this.ordering) {
                TableItem tableItem = new TableItem(this.componentTable, 0);
                tableItem.setText(component);
            }
            HashSet<TreeItem> toRemove = new HashSet<TreeItem>();
            for (Graph graph : this.graphs) {
                for (TreeItem treeItem : graph.components.keySet()) {
                    if (this.ordering.contains(treeItem.getText())) continue;
                    toRemove.add(treeItem);
                }
                for (TreeItem treeItem : toRemove) {
                    graph.removeComponent(treeItem);
                    treeItem.dispose();
                }
            }
            if (this.first) {
                this.graphs.get(0).addSelection(this.componentTable.getItems());
            }
        }
        this.componentTable.getParent().layout();
        this.checkPage();
    }

    @Override
    public void updateSelection(SpeciesSelectionWizardPage.SpeciesSelectionEvent event) {
        this.amalgamatedComponents = event.amalgamations;
        this.column3Visible = false;
        for (Set<String> hs : this.amalgamatedComponents.values()) {
            if (hs.size() <= 1) continue;
            this.column3Visible = true;
        }
        this.ordering = event.ordering;
        if (this.componentTable != null) {
            this.updateList();
        }
    }

    private final void updateTableView() {
        if (this.currentGraph != null) {
            this.graphTable.setInput(this.currentGraph.components.entrySet());
            TableColumn[] tableColumnArray = this.graphTable.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tableColumn = tableColumnArray[n2];
                if (!tableColumn.getText().equals("Summation of") || this.column3Visible) {
                    tableColumn.pack();
                } else {
                    tableColumn.setWidth(0);
                }
                ++n2;
            }
            Group group = (Group)this.graphTable.getTable().getParent();
            group.setText(this.currentGraph.title);
            this.title.setText(this.currentGraph.title);
            this.xAxis.setText(this.currentGraph.xAxis);
            this.yAxis.setText(this.currentGraph.yAxis);
            group.layout();
        } else {
            this.graphTable.setInput(null);
            Group group = (Group)this.graphTable.getTable().getParent();
            group.setText("");
            this.title.setText("");
            this.xAxis.setText("");
            this.yAxis.setText("");
            group.layout();
        }
    }

    private class ComponentTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ComponentTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Map.Entry me = (Map.Entry)element;
            if (columnIndex == 0) {
                return ((TreeItem)me.getKey()).getText();
            }
            if (columnIndex == 1) {
                return (String)me.getValue();
            }
            if (OutputOptionsWizardPage.this.column3Visible) {
                StringBuilder sb = new StringBuilder();
                for (String s : OutputOptionsWizardPage.this.amalgamatedComponents.get(((TreeItem)me.getKey()).getText())) {
                    sb.append(s).append(" + ");
                }
                sb.delete(sb.length() - 3, sb.length());
                return sb.toString();
            }
            return "";
        }
    }

    class Graph {
        Map<String, Set<String>> amalgamations;
        private HashMap<TreeItem, String> components;
        private TreeItem graphTreeItem;
        Map<String, String> nameMap;
        ArrayList<String> ordering;
        String title;
        String xAxis;
        String yAxis;

        Graph(TreeItem treeItem) {
            this.graphTreeItem = treeItem;
            this.components = new HashMap();
            this.nameMap = new HashMap<String, String>();
            this.xAxis = "Time";
            this.yAxis = "Population sizes";
            this.title = treeItem.getText();
        }

        private void addComponent(TreeItem treeItem) {
            if (!this.components.containsKey(treeItem)) {
                String name = treeItem.getText();
                this.components.put(treeItem, name);
                this.nameMap.put(name, name);
            }
        }

        private void addSelection(TableItem[] tableItems) {
            TableItem[] tableItemArray = tableItems;
            int n = tableItems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                String name = tableItem.getText();
                if (!this.nameMap.containsKey(name)) {
                    TreeItem[] treeItems = this.graphTreeItem.getItems();
                    int i = OutputOptionsWizardPage.this.ordering.indexOf(name);
                    int index = 0;
                    while (index < treeItems.length) {
                        if (i < OutputOptionsWizardPage.this.ordering.indexOf(treeItems[index].getText())) break;
                        ++index;
                    }
                    TreeItem child = new TreeItem(this.graphTreeItem, 0, index);
                    child.setText(name);
                    this.addComponent(child);
                }
                ++n2;
            }
        }

        private void removeComponent(TreeItem treeItem) {
            if (this.components.containsKey(treeItem)) {
                this.nameMap.remove(treeItem.getText());
                this.components.remove(treeItem);
            }
        }

        private void updateLabel(TreeItem treeItem, String newLabel) {
            if (this.components.containsKey(treeItem)) {
                this.components.put(treeItem, newLabel);
                this.nameMap.put(treeItem.getText(), newLabel);
            }
        }
    }
}

