/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoOptionForwarder;
import uk.ac.ed.inf.pepa.eclipse.ui.ImageManager;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.StoichiometricWizardPage;
import uk.ac.ed.inf.pepa.sba.Mapping;
import uk.ac.ed.inf.pepa.sba.SBAParseException;

public class SpeciesSelectionWizardPage
extends WizardPage {
    public static final String name = "SpeciesSelection";
    CheckboxTreeViewer checkboxTreeViewer;
    Component[] components = null;
    Composite composite;
    private List<SpeciesSelectionListener> listeners;
    IPepaModel model;
    OptionsMap optionsMap;
    Button selectAllButton;
    Button amalgamateCheckbox;
    boolean unlabelledPresent;
    boolean listenersUpdated = false;
    Label unlabelledlabel;

    protected SpeciesSelectionWizardPage(IPepaModel model, OptionsMap optionsMap) {
        super(name);
        this.model = model;
        this.optionsMap = optionsMap;
        this.listeners = new ArrayList<SpeciesSelectionListener>();
        this.setTitle("Component Selection");
        this.setDescription("Please select the components you wish to record during this analysis");
    }

    public void addListener(SpeciesSelectionListener listener) {
        this.listeners.add(listener);
    }

    private void checkPage() {
        this.setPageComplete(false);
        ArrayList<String> selectedComponents = new ArrayList<String>();
        Object[] objectArray = this.checkboxTreeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Component component = (Component)o;
            if (component.cooperation == null && component.children == null) {
                selectedComponents.add(component.name != null ? component.name : component.displayName);
            }
            ++n2;
        }
        if (selectedComponents.size() > 0) {
            this.setPageComplete(true);
            ArrayList<String> selectedComponents2 = this.updateAmalgamations(selectedComponents);
            selectedComponents2.addAll(selectedComponents);
            this.optionsMap.setValue(OptionsMap.Parameter.Components, (Object)selectedComponents2.toArray(new String[0]));
        }
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FormLayout());
        this.checkboxTreeViewer = new CheckboxTreeViewer(this.composite);
        this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider(this.getFont()));
        this.checkboxTreeViewer.setContentProvider((IContentProvider)new ComponentTreeContentProvider());
        this.selectAllButton = new Button(this.composite, 8);
        this.selectAllButton.setText("Select all");
        final Button selectLabelled = new Button(this.composite, 8);
        selectLabelled.setText("Select labelled components only");
        selectLabelled.setToolTipText("Selects only the components in bold (labelled components) contained within the tree.");
        selectLabelled.setVisible(false);
        this.unlabelledlabel = new Label(this.composite, 64);
        this.unlabelledlabel.setText("* Statistics of unlabelled components will be merged with their labelled component.");
        this.amalgamateCheckbox = new Button(this.composite, 32);
        this.amalgamateCheckbox.setToolTipText("Allows toggling of unlabelled states. If unlabelled states are not shown they are subsumed by their labelled state.");
        try {
            this.amalgamateCheckbox.setSelection(Boolean.valueOf(PepatoOptionForwarder.getOptionFromPersistentResource((IResource)this.model.getUnderlyingResource(), (String)(String.valueOf(this.getName()) + ".amalgamate"))).booleanValue());
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
        }
        this.unlabelledlabel.setVisible(this.amalgamateCheckbox.getSelection());
        this.checkboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                int n;
                Component[] componentArray;
                Component component = (Component)event.getElement();
                if (component.cooperation != null) {
                    SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)component, false);
                } else if (component.children != null) {
                    boolean state = event.getChecked();
                    SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)component, state);
                    componentArray = component.children;
                    n = component.children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component child = componentArray[n2];
                        if (!SpeciesSelectionWizardPage.this.amalgamateCheckbox.getSelection() || !child.unlabelled) {
                            SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)child, state);
                        }
                        ++n2;
                    }
                    SpeciesSelectionWizardPage.this.checkboxTreeViewer.setGrayed((Object)component, false);
                } else if (component.parent != null) {
                    Component parent = component.parent;
                    int count = 0;
                    Component[] componentArray2 = parent.children;
                    int n3 = parent.children.length;
                    n = 0;
                    while (n < n3) {
                        Component child = componentArray2[n];
                        if (SpeciesSelectionWizardPage.this.checkboxTreeViewer.getChecked((Object)child)) {
                            ++count;
                        }
                        ++n;
                    }
                    SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)parent, count > 0);
                    SpeciesSelectionWizardPage.this.checkboxTreeViewer.setGrayed((Object)parent, count != parent.children.length && count != 0);
                }
                boolean all = true;
                componentArray = SpeciesSelectionWizardPage.this.components;
                n = SpeciesSelectionWizardPage.this.components.length;
                int n4 = 0;
                while (n4 < n) {
                    Component c = componentArray[n4];
                    if (c.cooperation == null && (!SpeciesSelectionWizardPage.this.checkboxTreeViewer.getChecked((Object)c) || SpeciesSelectionWizardPage.this.checkboxTreeViewer.getGrayed((Object)c))) {
                        all = false;
                    }
                    ++n4;
                }
                SpeciesSelectionWizardPage.this.selectAllButton.setText(all ? "Deselect all" : "Select all");
                SpeciesSelectionWizardPage.this.composite.layout();
                SpeciesSelectionWizardPage.this.checkPage();
            }
        });
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean select = !SpeciesSelectionWizardPage.this.selectAllButton.getText().startsWith("De");
                Component[] componentArray = SpeciesSelectionWizardPage.this.components;
                int n = SpeciesSelectionWizardPage.this.components.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c.cooperation == null) {
                        SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)c, select);
                        Component[] componentArray2 = c.children;
                        int n3 = c.children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Component child = componentArray2[n4];
                            if (!SpeciesSelectionWizardPage.this.amalgamateCheckbox.getSelection() || !child.unlabelled) {
                                SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)child, select);
                            }
                            ++n4;
                        }
                        SpeciesSelectionWizardPage.this.checkboxTreeViewer.setGrayed((Object)c, false);
                    }
                    ++n2;
                }
                SpeciesSelectionWizardPage.this.selectAllButton.setText(select ? "Deselect all" : "Select all");
                SpeciesSelectionWizardPage.this.composite.layout();
                SpeciesSelectionWizardPage.this.checkPage();
            }
        });
        this.amalgamateCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean showingUnlabelled = ((Button)e.widget).getSelection();
                SpeciesSelectionWizardPage.this.amalgamateCheckbox.setText(showingUnlabelled ? "Amalgamate components *" : "Amalgamate components (labelled components in bold)");
                SpeciesSelectionWizardPage.this.unlabelledlabel.setVisible(SpeciesSelectionWizardPage.this.unlabelledPresent && showingUnlabelled);
                selectLabelled.setVisible(SpeciesSelectionWizardPage.this.unlabelledPresent && !showingUnlabelled);
                SpeciesSelectionWizardPage.this.updateTree();
                SpeciesSelectionWizardPage.this.composite.layout();
                SpeciesSelectionWizardPage.this.checkPage();
            }
        });
        selectLabelled.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Component[] componentArray = SpeciesSelectionWizardPage.this.components;
                int n = SpeciesSelectionWizardPage.this.components.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c.cooperation == null) {
                        SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)c, true);
                        SpeciesSelectionWizardPage.this.checkboxTreeViewer.setGrayed((Object)c, false);
                        Component[] componentArray2 = c.children;
                        int n3 = c.children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Component child = componentArray2[n4];
                            if (!child.unlabelled) {
                                SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)child, true);
                            } else {
                                SpeciesSelectionWizardPage.this.checkboxTreeViewer.setChecked((Object)child, false);
                                SpeciesSelectionWizardPage.this.checkboxTreeViewer.setGrayed((Object)c, true);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                SpeciesSelectionWizardPage.this.selectAllButton.setText("Deselect all");
                SpeciesSelectionWizardPage.this.composite.layout();
                SpeciesSelectionWizardPage.this.checkPage();
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        this.amalgamateCheckbox.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.amalgamateCheckbox);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment((Control)this.selectAllButton);
        this.checkboxTreeViewer.getTree().setLayoutData((Object)formData);
        formData = new FormData();
        formData.bottom = new FormAttachment((Control)this.unlabelledlabel);
        formData.left = new FormAttachment(0);
        this.selectAllButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.selectAllButton);
        formData.bottom = new FormAttachment((Control)this.unlabelledlabel);
        selectLabelled.setLayoutData((Object)formData);
        formData = new FormData();
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.unlabelledlabel.setLayoutData((Object)formData);
        this.setControl((Control)this.composite);
    }

    void ensureParse() {
        if (!this.listenersUpdated) {
            this.processModel();
        }
    }

    private void generateDataModel() {
        Tree tree;
        Mapping mapping = this.model.getMapping();
        if (mapping == null || mapping.length() == 0) {
            PepaLog.logError((Throwable)new NullPointerException("Error while returning components."));
            this.getWizard().dispose();
        }
        this.components = new Component[mapping.length() * 2 - 1];
        int index = 0;
        HashSet<String> componentsToRecord = new HashSet<String>();
        String[] stringArray = (String[])this.optionsMap.getValue(OptionsMap.Parameter.Components);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            componentsToRecord.add(s);
            ++n2;
        }
        ArrayList<Component> labelled = new ArrayList<Component>();
        ArrayList<Component> unlabelled = new ArrayList<Component>();
        this.unlabelledPresent = false;
        HashMap<String, String> tHashMap = new HashMap<String, String>();
        while (mapping != null) {
            this.components[index] = new Component();
            this.components[index].displayName = mapping.originalRepresentation;
            this.components[index].children = new Component[mapping.labelled.size() + mapping.unlabelled.size()];
            int index2 = 0;
            tHashMap.clear();
            String[] tsa = mapping.labelled.keySet().toArray(new String[0]);
            for (String string : mapping.unlabelled.keySet()) {
                String tString = "";
                String[] stringArray2 = tsa;
                int n3 = tsa.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s2 = stringArray2[n4];
                    if (string.startsWith(s2.charAt(0) == '\"' ? s2.substring(0, s2.length() - 1) : s2) && s2.length() > tString.length()) {
                        tString = s2;
                    }
                    ++n4;
                }
                tHashMap.put(string, tString);
            }
            for (Map.Entry entry : mapping.labelled.entrySet()) {
                String uniqueName;
                this.components[index].children[index2] = new Component();
                this.components[index].children[index2].name = uniqueName = (String)entry.getKey();
                this.components[index].children[index2].displayName = (String)entry.getValue();
                this.components[index].children[index2].parent = this.components[index];
                if (componentsToRecord.contains(uniqueName)) {
                    labelled.add(this.components[index].children[index2]);
                }
                ++index2;
                for (Map.Entry me2 : mapping.unlabelled.entrySet()) {
                    if (!((String)tHashMap.get(me2.getKey())).equals(uniqueName)) continue;
                    this.unlabelledPresent = true;
                    this.components[index].children[index2] = new Component();
                    this.components[index].children[index2].name = (String)me2.getKey();
                    this.components[index].children[index2].displayName = (String)me2.getValue();
                    this.components[index].children[index2].parent = this.components[index];
                    this.components[index].children[index2].unlabelled = true;
                    if (componentsToRecord.contains(me2.getKey())) {
                        unlabelled.add(this.components[index].children[index2]);
                    }
                    ++index2;
                }
            }
            ++index;
            if (mapping.cooperation != null) {
                this.components[index] = new Component();
                this.components[index].cooperation = mapping.cooperation;
                ++index;
            }
            mapping = mapping.next;
        }
        this.checkboxTreeViewer.setInput((Object)this.components);
        this.amalgamateCheckbox.setEnabled(this.unlabelledPresent);
        this.amalgamateCheckbox.setVisible(this.unlabelledPresent);
        this.unlabelledlabel.setVisible(this.unlabelledPresent);
        Event event = new Event();
        event.widget = this.amalgamateCheckbox;
        this.amalgamateCheckbox.notifyListeners(13, event);
        for (Component c : labelled) {
            this.checkboxTreeViewer.setChecked((Object)c, true);
        }
        if (!this.amalgamateCheckbox.getSelection()) {
            for (Component c : unlabelled) {
                this.checkboxTreeViewer.setChecked((Object)c, true);
            }
        }
        if ((tree = this.checkboxTreeViewer.getTree()).getItemCount() == 1) {
            tree.getItem(0).setExpanded(true);
        }
    }

    void processModel() {
        this.generateDataModel();
        this.updateTree();
        this.checkPage();
    }

    void saveOptions() {
        try {
            PepatoOptionForwarder.saveOptionInPersistentResource((IResource)this.model.getUnderlyingResource(), (String)(String.valueOf(this.getName()) + ".amalgamate"), (Object)Boolean.toString(this.amalgamateCheckbox.getSelection()));
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            try {
                IWizardPage previous = this.getPreviousPage();
                if (previous != null && previous instanceof StoichiometricWizardPage) {
                    ((StoichiometricWizardPage)previous).updateReactions();
                } else {
                    this.model.sbaParse();
                }
                if (this.model.generateReactions() || this.components == null) {
                    this.processModel();
                }
            }
            catch (SBAParseException e) {
                PepaLog.logError((String)"Parsing Exception", (Throwable)e);
                ((Wizard)this.getWizard()).getShell().close();
                MessageBox warning = new MessageBox(Display.getDefault().getActiveShell(), 8);
                warning.setText("Error parsing PEPA file");
                warning.setMessage(e.getMessage());
                warning.open();
                return;
            }
            catch (Exception e) {
                PepaLog.logError((Throwable)e);
                ((Wizard)this.getWizard()).getShell().close();
                MessageBox warning = new MessageBox(Display.getDefault().getActiveShell(), 8);
                warning.setText("Error parsing PEPA file");
                warning.setMessage("Sorry. There exists an error not caught by the current static analysis. Please check the cooperation sets and use of passive rates.");
                warning.open();
                return;
            }
        }
        super.setVisible(visible);
    }

    private ArrayList<String> updateAmalgamations(ArrayList<String> selectedComponents) {
        this.listenersUpdated = true;
        HashMap<String, Set<String>> amalgamations = new HashMap<String, Set<String>>();
        ArrayList<String> unlabelledStates = new ArrayList<String>();
        boolean amalgamting = this.amalgamateCheckbox.getSelection();
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component parent = componentArray[n2];
            if (parent.children != null) {
                int index = 0;
                while (index < parent.children.length) {
                    String componentName;
                    Component child = parent.children[index];
                    String string = componentName = child.name != null ? child.name : child.displayName;
                    if (selectedComponents.contains(componentName)) {
                        HashSet<String> hashSet = new HashSet<String>();
                        hashSet.add(componentName);
                        amalgamations.put(componentName, hashSet);
                        if (amalgamting) {
                            while (index + 1 < parent.children.length && parent.children[index + 1].unlabelled) {
                                child = parent.children[++index];
                                String childName = child.name != null ? child.name : child.displayName;
                                hashSet.add(childName);
                                unlabelledStates.add(childName);
                            }
                        }
                    }
                    ++index;
                }
            }
            ++n2;
        }
        SpeciesSelectionEvent speciesSelectionEvent = new SpeciesSelectionEvent(amalgamations, selectedComponents);
        for (SpeciesSelectionListener ssl : this.listeners) {
            ssl.updateSelection(speciesSelectionEvent);
        }
        return unlabelledStates;
    }

    private void updateTree() {
        boolean[] expanded = new boolean[this.components.length];
        Object[] checkedComponents = this.checkboxTreeViewer.getCheckedElements();
        int index = 0;
        while (index < expanded.length) {
            expanded[index] = this.checkboxTreeViewer.getExpandedState((Object)this.components[index]);
            ++index;
        }
        this.checkboxTreeViewer.setInput((Object)this.components);
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.cooperation != null) {
                this.checkboxTreeViewer.setChecked((Object)c, false);
            }
            ++n2;
        }
        boolean amalgamting = this.amalgamateCheckbox.getSelection();
        Object[] objectArray = checkedComponents;
        int n3 = checkedComponents.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray[n];
            if (!amalgamting || !((Component)o).unlabelled) {
                this.checkboxTreeViewer.setChecked((Object)((Component)o), true);
            }
            ++n;
        }
        int index2 = 0;
        while (index2 < expanded.length) {
            this.checkboxTreeViewer.setExpandedState((Object)this.components[index2], expanded[index2]);
            if (this.components[index2].children != null) {
                int total = 0;
                int checked = 0;
                Component[] componentArray2 = this.components[index2].children;
                int n4 = this.components[index2].children.length;
                int n5 = 0;
                while (n5 < n4) {
                    Component child = componentArray2[n5];
                    if (!amalgamting || !child.unlabelled) {
                        ++total;
                        if (this.checkboxTreeViewer.getChecked((Object)child)) {
                            ++checked;
                        }
                    }
                    ++n5;
                }
                this.checkboxTreeViewer.setChecked((Object)this.components[index2], checked > 0);
                this.checkboxTreeViewer.setGrayed((Object)this.components[index2], checked > 0 && checked != total);
            }
            ++index2;
        }
    }

    private class Component {
        Component[] children = null;
        String cooperation = null;
        String name = null;
        String displayName = null;
        Component parent = null;
        boolean unlabelled = false;

        private Component() {
        }
    }

    private class ComponentLabelProvider
    extends LabelProvider
    implements IFontProvider {
        Font bold;

        ComponentLabelProvider(Font defaultFont) {
            FontData boldFontData = defaultFont.getFontData()[0];
            boldFontData.setStyle(1);
            this.bold = new Font(defaultFont.getDevice(), new FontData[]{boldFontData});
        }

        public Font getFont(Object element) {
            Component c = (Component)element;
            if (!c.unlabelled && c.cooperation == null && c.children == null) {
                return this.bold;
            }
            return null;
        }

        public Image getImage(Object element) {
            if (((Component)element).cooperation != null) {
                return ImageManager.getInstance().getImage("sync.gif");
            }
            return null;
        }

        public String getText(Object element) {
            Component component = (Component)element;
            String s = "";
            if (component.cooperation != null) {
                s = component.cooperation;
            } else {
                if (component.unlabelled) {
                    s = String.valueOf(s) + "\t\t";
                }
                s = String.valueOf(s) + component.displayName;
                if (component.name != null && !component.displayName.equals(component.name)) {
                    s = String.valueOf(s) + " (" + component.name + ")";
                }
            }
            return s;
        }
    }

    private class ComponentTreeContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private ComponentTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (!SpeciesSelectionWizardPage.this.amalgamateCheckbox.getSelection()) {
                return ((Component)parentElement).children;
            }
            ArrayList<Component> al = new ArrayList<Component>();
            Component[] componentArray = ((Component)parentElement).children;
            int n = ((Component)parentElement).children.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                if (!child.unlabelled) {
                    al.add(child);
                }
                ++n2;
            }
            return al.toArray();
        }

        public Object getParent(Object element) {
            return ((Component)element).parent;
        }

        public boolean hasChildren(Object element) {
            return ((Component)element).children != null;
        }
    }

    public class SpeciesSelectionEvent {
        Map<String, Set<String>> amalgamations;
        ArrayList<String> ordering;

        SpeciesSelectionEvent(Map<String, Set<String>> amalgamations, ArrayList<String> ordering) {
            this.amalgamations = amalgamations;
            this.ordering = ordering;
        }
    }

    public static interface SpeciesSelectionListener {
        public void updateSelection(SpeciesSelectionEvent var1);
    }
}

