/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoOptionForwarder;
import uk.ac.ed.inf.pepa.eclipse.ui.ImageManager;
import uk.ac.ed.inf.pepa.sba.SBAComponent;
import uk.ac.ed.inf.pepa.sba.SBAParseException;
import uk.ac.ed.inf.pepa.sba.SBAReaction;

public class StoichiometricWizardPage
extends WizardPage {
    public static final String name = "Stoichiometry";
    boolean first = true;
    IPepaModel model;
    ReactionFilter reactionFilter;
    HashMap<TableItem, SBAReaction> reactionMap = new HashMap();
    TableViewer reactionTable;
    StoicDialog stoicDialog;
    Map<String, Map<String, Integer>> stoicInfo = new HashMap<String, Map<String, Integer>>();

    StoichiometricWizardPage(IPepaModel model) {
        super(name);
        this.model = model;
        this.setTitle("Stoichiometric Input for Reagent-Centric Approach");
        this.setDescription("Double click on a action/reaction to alter the stoichiometric values of each participating component/species");
        this.loadStoichiometry();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        this.stoicDialog = new StoicDialog(this.getShell());
        this.reactionTable = new TableViewer(composite, 65540);
        this.reactionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        final ReactionTableCustomProvider rtcp = new ReactionTableCustomProvider(this.reactionTable);
        this.reactionTable.setLabelProvider((IBaseLabelProvider)rtcp);
        this.reactionTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                rtcp.selected = (SBAReaction)((StructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        this.reactionTable.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                SBAReaction r1 = (SBAReaction)e1;
                SBAReaction r2 = (SBAReaction)e2;
                return r1.getName().compareTo(r2.getName());
            }
        });
        new TableColumn(this.reactionTable.getTable(), 16384);
        new TableColumn(this.reactionTable.getTable(), 16384);
        this.reactionTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SBAReaction r = (SBAReaction)((StructuredSelection)event.getSelection()).getFirstElement();
                StoichiometricWizardPage.this.stoicDialog.setReaction(r);
                if (StoichiometricWizardPage.this.stoicDialog.open() == 0) {
                    StoichiometricWizardPage.this.reactionTable.update((Object)r, null);
                }
            }
        });
        this.reactionTable.getTable().addPaintListener(new PaintListener(){
            Rectangle prior;

            public void paintControl(PaintEvent e) {
                if (this.prior == null || !this.prior.equals((Object)StoichiometricWizardPage.this.reactionTable.getTable().getBounds())) {
                    this.prior = StoichiometricWizardPage.this.reactionTable.getTable().getBounds();
                    StoichiometricWizardPage.this.pack();
                }
            }
        });
        this.reactionFilter = new ReactionFilter();
        this.reactionTable.addFilter((ViewerFilter)this.reactionFilter);
        Label label = new Label(composite, 0);
        label.setText("filter:");
        final Text filterInput = new Text(composite, 0);
        filterInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StoichiometricWizardPage.this.reactionFilter.updateFilter(filterInput.getText());
                StoichiometricWizardPage.this.reactionTable.refresh();
            }
        });
        Image image = ImageManager.getInstance().getImage("clear.gif");
        ImageData imageData = image.getImageData();
        imageData = imageData.scaledTo(10, 10);
        image = new Image(image.getDevice(), imageData);
        ControlDecoration controlDecoration = new ControlDecoration((Control)filterInput, 131200, composite);
        controlDecoration.setImage(image);
        controlDecoration.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                filterInput.setText("");
                StoichiometricWizardPage.this.reactionFilter.updateFilter("");
                StoichiometricWizardPage.this.reactionTable.refresh();
            }
        });
        controlDecoration.setDescriptionText("Clear the filter");
        Button restoreButton = new Button(composite, 0);
        restoreButton.setText("Restore");
        restoreButton.setToolTipText("Restore from previously stored stoichiometric information");
        restoreButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StoichiometricWizardPage.this.reset();
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(100, -10);
        filterInput.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment((Control)filterInput);
        label.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)filterInput, 5);
        formData.bottom = new FormAttachment((Control)restoreButton);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.reactionTable.getTable().setLayoutData((Object)formData);
        formData = new FormData();
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        restoreButton.setLayoutData((Object)formData);
        this.setPageComplete(true);
        this.setControl((Control)composite);
    }

    private void loadStoichiometry() {
        this.stoicInfo.clear();
        try {
            String value = PepatoOptionForwarder.getOptionFromPersistentResource((IResource)this.model.getUnderlyingResource(), (String)"stoichiometry");
            if (value == null) {
                return;
            }
            StringBuilder sb = new StringBuilder(value);
            ArrayList<String> al = new ArrayList<String>();
            try {
                while (sb.length() > 0) {
                    int index = sb.indexOf(":");
                    int length = Integer.parseInt(sb.substring(0, index));
                    sb.delete(0, index + 1);
                    al.add(sb.substring(0, length));
                    sb.delete(0, length);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (al.size() % 3 != 0) {
                return;
            }
            String[] sa = al.toArray(new String[0]);
            int i = 0;
            while (i < sa.length) {
                Map<String, Integer> component = this.stoicInfo.get(sa[i]);
                if (component == null) {
                    component = new HashMap<String, Integer>();
                    this.stoicInfo.put(sa[i], component);
                }
                component.put(sa[i + 1], new Integer(sa[i + 2]));
                i += 3;
            }
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
        }
    }

    private final void pack() {
        TableColumn[] tca = this.reactionTable.getTable().getColumns();
        tca[0].pack();
        tca[1].setWidth(Math.max(this.reactionTable.getTable().getClientArea().width - tca[0].getWidth(), tca[1].getWidth()));
    }

    private void reset() {
        HashMap<String, Integer> emptySet = new HashMap<String, Integer>();
        for (SBAReaction reaction : (Set)this.reactionTable.getInput()) {
            Integer value;
            Map<String, Integer> components = this.stoicInfo.get(reaction.getName());
            if (components == null) {
                components = emptySet;
            }
            for (SBAComponent component : reaction.getReactants()) {
                value = components.get(component.getName());
                if (value != null) {
                    component.setStoichiometry(value.intValue());
                    continue;
                }
                component.setStoichiometry(1);
            }
            for (SBAComponent component : reaction.getProducts()) {
                value = components.get(component.getName());
                if (value != null) {
                    component.setStoichiometry(value.intValue());
                    continue;
                }
                component.setStoichiometry(1);
            }
        }
        this.reactionTable.refresh();
    }

    void saveStoichiometry() {
        StringBuilder value = new StringBuilder();
        if (this.reactionTable == null || this.reactionTable.getInput() == null) {
            return;
        }
        for (SBAReaction reaction : (Set)this.reactionTable.getInput()) {
            String s;
            String sComponent;
            String sReaction = reaction.getName();
            int iReaction = sReaction.length();
            for (SBAComponent component : reaction.getReactants()) {
                if (component.getStoichiometry() <= 1) continue;
                value.append(iReaction).append(":").append(sReaction);
                sComponent = component.getName();
                value.append(sComponent.length()).append(":").append(sComponent);
                s = Integer.toString(component.getStoichiometry());
                value.append(s.length()).append(":").append(s);
            }
            for (SBAComponent component : reaction.getProducts()) {
                if (component.getStoichiometry() <= 1) continue;
                value.append(iReaction).append(":").append(sReaction);
                sComponent = component.getName();
                value.append(sComponent.length()).append(":").append(sComponent);
                s = Integer.toString(component.getStoichiometry());
                value.append(s.length()).append(":").append(s);
            }
        }
        try {
            PepatoOptionForwarder.saveOptionInPersistentResource((IResource)this.model.getUnderlyingResource(), (String)"stoichiometry", (Object)value.toString());
        }
        catch (CoreException e) {
            PepaLog.logError((Throwable)e);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            boolean updated = false;
            try {
                updated = this.model.sbaParse();
            }
            catch (SBAParseException e) {
                PepaLog.logError((Throwable)e);
                this.getWizard().dispose();
            }
            if (updated || this.first) {
                this.reactionTable.setInput((Object)this.model.getReactions());
                if (this.first) {
                    this.reset();
                    this.first = false;
                }
                this.pack();
            }
        }
    }

    void updateReactions() {
        this.model.updateReactions((Set)this.reactionTable.getInput());
    }

    private class ReactionFilter
    extends ViewerFilter {
        String filterString = "";

        private ReactionFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof SBAReaction)) {
                return false;
            }
            if (this.filterString == "") {
                return true;
            }
            SBAReaction r = (SBAReaction)element;
            if (r.getName().lastIndexOf(this.filterString) != -1) {
                return true;
            }
            return r.toString().lastIndexOf(this.filterString) != -1;
        }

        public void updateFilter(String filter) {
            this.filterString = filter;
        }
    }

    private class ReactionTableCustomProvider
    extends OwnerDrawLabelProvider {
        Display display;
        TextLayout layout;
        Map<SBAReaction, TextLayout> layouts;
        TextStyle plain;
        TextStyle plainSelected;
        TextStyle bold;
        TextStyle boldSelected;
        TextStyle underline;
        TextStyle underlineSelected;
        StringBuilder sb;
        SBAReaction selected = null;
        SBAReaction reaction;
        LinkedList<Style> styles;

        ReactionTableCustomProvider(TableViewer tableViewer) {
            this.display = tableViewer.getControl().getDisplay();
            this.layouts = new HashMap<SBAReaction, TextLayout>();
            this.sb = new StringBuilder();
            this.styles = new LinkedList();
            FontRegistry fontRegistry = JFaceResources.getFontRegistry();
            Font font = fontRegistry.defaultFont();
            Color t = this.display.getSystemColor(24);
            Color ts = this.display.getSystemColor(27);
            Color b = this.display.getSystemColor(25);
            Color bs = this.display.getSystemColor(26);
            this.plain = new TextStyle(font, t, b);
            this.plainSelected = new TextStyle(font, ts, bs);
            this.underline = new TextStyle(font, t, b);
            this.underline.underline = true;
            this.underlineSelected = new TextStyle(font, ts, bs);
            this.underlineSelected.underline = true;
            font = fontRegistry.getBold("org.eclipse.jface.defaultfont");
            t = this.display.getSystemColor(3);
            this.bold = new TextStyle(font, t, b);
            ts = new Color((Device)this.display, 255 - ts.getRed(), 255 - ts.getGreen(), 255 - ts.getBlue());
            this.boldSelected = new TextStyle(font, ts, bs);
        }

        public void dispose() {
            super.dispose();
            for (TextLayout textLayout : this.layouts.values()) {
                textLayout.dispose();
            }
        }

        protected void measure(Event event, Object element) {
            Point point;
            this.reaction = (SBAReaction)element;
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            if (event.index == 0) {
                point = event.gc.stringExtent(this.reaction.getName());
                point.x += 20;
            } else {
                point = event.gc.stringExtent(this.reaction.toString());
                point.x += 50;
            }
            bounds.width = point.x;
            bounds.height = point.y * 2;
            event.setBounds(bounds);
        }

        protected void paint(Event event, Object element) {
            this.reaction = (SBAReaction)element;
            this.layout = this.layouts.get(this.reaction);
            if (this.layout == null) {
                this.layout = new TextLayout((Device)this.display);
                this.layouts.put(this.reaction, this.layout);
            }
            if (event.index == 0) {
                this.layout.setText(this.reaction.getName());
                this.layout.setStyle(this.reaction == this.selected ? this.plainSelected : this.plain, 0, Integer.MAX_VALUE);
            } else {
                this.sb.setLength(0);
                this.styles.clear();
                int start = 0;
                for (SBAComponent reactant : this.reaction.getReactants()) {
                    if (reactant.getStoichiometry() > 1) {
                        this.sb.append(reactant.getStoichiometry()).append(".");
                        this.styles.add(new Style(this.reaction == this.selected ? this.boldSelected : this.bold, start, this.sb.length()));
                        start = this.sb.length();
                    }
                    this.sb.append(reactant.getName());
                    if (reactant.isCatalyst() || reactant.isInhibitor()) {
                        this.styles.add(new Style(this.reaction == this.selected ? this.underlineSelected : this.underline, start, this.sb.length()));
                    } else {
                        this.styles.add(new Style(this.reaction == this.selected ? this.plainSelected : this.plain, start, this.sb.length()));
                    }
                    start = this.sb.length();
                    this.sb.append(" + ");
                    this.styles.add(new Style(this.reaction == this.selected ? this.plainSelected : this.plain, start, this.sb.length()));
                    start = this.sb.length();
                }
                if (this.reaction.getReactants().size() > 0) {
                    this.sb.delete(this.sb.length() - 3, this.sb.length());
                    start = this.sb.length();
                    this.styles.removeLast();
                }
                this.sb.append(" -> ");
                this.styles.add(new Style(this.reaction == this.selected ? this.plainSelected : this.plain, start, this.sb.length()));
                start = this.sb.length();
                for (SBAComponent product : this.reaction.getProducts()) {
                    if (product.getStoichiometry() > 1) {
                        this.sb.append(product.getStoichiometry()).append(".");
                        this.styles.add(new Style(this.reaction == this.selected ? this.boldSelected : this.bold, start, this.sb.length()));
                        start = this.sb.length();
                    }
                    this.sb.append(product.getName());
                    if (product.isCatalyst() || product.isInhibitor()) {
                        this.styles.add(new Style(this.reaction == this.selected ? this.underlineSelected : this.underline, start, this.sb.length()));
                    } else {
                        this.styles.add(new Style(this.reaction == this.selected ? this.plainSelected : this.plain, start, this.sb.length()));
                    }
                    start = this.sb.length();
                    this.sb.append(" + ");
                    this.styles.add(new Style(this.reaction == this.selected ? this.plainSelected : this.plain, start, this.sb.length()));
                    start = this.sb.length();
                }
                if (this.reaction.getProducts().size() > 0) {
                    this.sb.delete(this.sb.length() - 3, this.sb.length());
                    start = this.sb.length();
                    this.styles.removeLast();
                }
                this.layout.setText(this.sb.toString());
                for (Style style : this.styles) {
                    style.set(this.layout);
                }
            }
            this.layout.draw(event.gc, event.x, event.y);
        }

        public void update(ViewerCell cell) {
            cell.setText("");
        }

        private class Style {
            int start;
            int end;
            TextStyle type;

            Style(TextStyle type, int start, int end) {
                this.type = type;
                this.start = start;
                this.end = end;
            }

            final void set(TextLayout layout) {
                layout.setStyle(this.type, this.start, this.end);
            }
        }
    }

    private class StoicDialog
    extends Dialog {
        SBAReaction reaction;
        Map<Spinner, SBAComponent> spinnerMap;

        StoicDialog(Shell parent) {
            super(parent);
            this.spinnerMap = new HashMap<Spinner, SBAComponent>();
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                for (Map.Entry<Spinner, SBAComponent> me : this.spinnerMap.entrySet()) {
                    me.getValue().setStoichiometry(me.getKey().getSelection());
                }
            }
            super.buttonPressed(buttonId);
        }

        protected Control createDialogArea(Composite parent) {
            Label name;
            Spinner spinner;
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite.setLayout((Layout)gridLayout);
            Composite reactants = new Composite(composite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            reactants.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            reactants.setLayoutData((Object)gridData);
            Label label = new Label(reactants, 0);
            label.setText("Reactants");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            for (SBAComponent reactant : this.reaction.getReactants()) {
                if (reactant.isCatalyst() || reactant.isInhibitor()) {
                    Label hiddenLabel = new Label(reactants, 0);
                    hiddenLabel.setVisible(false);
                } else {
                    spinner = new Spinner(reactants, 0);
                    spinner.setValues(reactant.getStoichiometry(), 1, Integer.MAX_VALUE, 0, 1, 10);
                    this.spinnerMap.put(spinner, reactant);
                }
                name = new Label(reactants, 0);
                name.setText(reactant.getName());
                if (reactant.isCatalyst()) {
                    name.setToolTipText("Catalyst");
                    continue;
                }
                if (!reactant.isInhibitor()) continue;
                name.setToolTipText("Inhibitor");
            }
            final Composite products = new Composite(composite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            products.setLayout((Layout)gridLayout);
            gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            products.setLayoutData((Object)gridData);
            label = new Label(products, 0);
            label.setText("Products");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            for (SBAComponent product : this.reaction.getProducts()) {
                spinner = new Spinner(products, 0);
                spinner.setValues(product.getStoichiometry(), 1, Integer.MAX_VALUE, 0, 1, 10);
                this.spinnerMap.put(spinner, product);
                name = new Label(products, 0);
                name.setText(product.getName());
            }
            products.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setLineWidth(2);
                    e.gc.drawLine(0, 0, 0, products.getClientArea().height);
                }
            });
            return composite;
        }

        public void setReaction(SBAReaction reaction) {
            this.reaction = reaction;
            this.spinnerMap.clear();
        }
    }
}

