/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.dialogs.SaveAsDialog;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoOptionForwarder;
import uk.ac.ed.inf.pepa.eclipse.core.ResourceUtilities;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.IResourceProvider;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.AlgorithmWizardPage;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.AnalysisJob;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.FormSelectionWizardPage;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.SpeciesSelectionWizardPage;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.StoichiometricWizardPage;

public class TimeSeriesAnalysisWizard
extends Wizard
implements IResourceProvider {
    IPepaModel model;
    OptionsMap optionsMap;
    IWizardPage pswp = null;
    StoichiometricWizardPage swp = null;

    public TimeSeriesAnalysisWizard(IPepaModel model) {
        if (model == null) {
            throw new NullPointerException("Error; model does not exist.");
        }
        if (model.isSBAParseable().length == 0) {
            throw new IllegalStateException("Error. No parseable types for this model.");
        }
        this.model = model;
        this.setHelpAvailable(false);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Time-series Analysis");
        this.optionsMap = new OptionsMap();
        IResource modelResource = model.getUnderlyingResource();
        try {
            for (OptionsMap.Parameter parameter : this.optionsMap.keySet()) {
                String value = null;
                value = PepatoOptionForwarder.getOptionFromPersistentResource((IResource)modelResource, (String)parameter.getKey());
                if (value == null || value == "") continue;
                this.optionsMap.setValue(parameter, (Object)value);
            }
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
        }
    }

    public void addPages() {
        if (this.model.isSBAParseable().length > 1) {
            this.addPage((IWizardPage)new FormSelectionWizardPage(this.model));
        } else {
            this.model.setForm(this.model.isSBAParseable()[0]);
        }
        SpeciesSelectionWizardPage sswp = new SpeciesSelectionWizardPage(this.model, this.optionsMap);
        this.addPage((IWizardPage)sswp);
        this.addPage((IWizardPage)new AlgorithmWizardPage(this.model, this.optionsMap));
    }

    public void dispose() {
        if (this.swp != null) {
            this.swp.dispose();
        }
        super.dispose();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof FormSelectionWizardPage && IPepaModel.PEPAForm.REAGENT_CENTRIC.equals((Object)((FormSelectionWizardPage)page).getForm())) {
            if (this.swp == null) {
                this.swp = new StoichiometricWizardPage(this.model);
                this.swp.setWizard((IWizard)this);
            }
            this.pswp = page;
            return this.swp;
        }
        if (page == this.swp) {
            return super.getNextPage(this.pswp);
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.swp) {
            return this.pswp;
        }
        IWizardPage previousPage = super.getPreviousPage(page);
        if (previousPage instanceof FormSelectionWizardPage && IPepaModel.PEPAForm.REAGENT_CENTRIC.equals((Object)((FormSelectionWizardPage)previousPage).getForm())) {
            return this.swp;
        }
        return previousPage;
    }

    @Override
    public IResource getResource() {
        return this.model.getUnderlyingResource();
    }

    public boolean performFinish() {
        IResource modelResource = this.model.getUnderlyingResource();
        try {
            for (OptionsMap.Parameter parameter : this.optionsMap.keySet()) {
                PepatoOptionForwarder.saveOptionInPersistentResource((IResource)modelResource, (String)parameter.getKey(), (Object)this.optionsMap.serialise(parameter));
            }
        }
        catch (CoreException e) {
            PepaLog.logError((Throwable)e);
        }
        ((SpeciesSelectionWizardPage)this.getPage("SpeciesSelection")).saveOptions();
        IWizardPage page = this.getPage(FormSelectionWizardPage.name);
        if (page != null) {
            ((FormSelectionWizardPage)page).saveOptions();
        }
        if (this.swp != null) {
            this.swp.saveStoichiometry();
        }
        try {
            ((SpeciesSelectionWizardPage)this.getPage("SpeciesSelection")).ensureParse();
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
            return false;
        }
        String title = this.model.getUnderlyingResource().getName();
        title = title.substring(0, title.length() - 5);
        OptionsMap.Solver solver = (OptionsMap.Solver)this.optionsMap.getValue(OptionsMap.Parameter.Solver);
        title = String.valueOf(title) + " - " + solver.getDescriptiveName();
        OptionsMap.Parameter[] parameterArray = solver.getRequiredParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsMap.Parameter parameter = parameterArray[n2];
            if (parameter.equals((Object)OptionsMap.Parameter.Independent_Replications)) {
                title = String.valueOf(title) + ". " + Integer.toString((Integer)this.optionsMap.getValue(OptionsMap.Parameter.Independent_Replications)) + " replications";
            }
            ++n2;
        }
        double start = (Double)this.optionsMap.getValue(OptionsMap.Parameter.Start_Time);
        double stop = (Double)this.optionsMap.getValue(OptionsMap.Parameter.Stop_Time);
        title = String.valueOf(title) + " with duration " + Double.toString(stop - start);
        AnalysisJob myJob = new AnalysisJob(title, this.model, this.optionsMap);
        myJob.schedule();
        if (((AlgorithmWizardPage)this.getPage("Algorithm")).saveCMDL()) {
            try {
                ResourceUtilities.generate((String)(String.valueOf(modelResource.getFullPath().toOSString()) + ".cmdl"), (String)this.model.getCMDL(), null);
                IPath dir = modelResource.getFullPath().removeLastSegments(1);
                String name = modelResource.getName();
                StringBuilder newName = new StringBuilder();
                char[] cArray = name.toCharArray();
                int n3 = cArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    char c = cArray[n4];
                    if (Character.isLetterOrDigit(c)) {
                        newName.append(c);
                    } else {
                        newName.append("_");
                    }
                    ++n4;
                }
                newName.append(".m");
                SaveAsDialog saveDialog = new SaveAsDialog(this.getShell());
                saveDialog.setOriginalFile(ResourceUtilities.getIFileFromText((String)dir.append(newName.toString()).toOSString()));
                saveDialog.open();
                dir = saveDialog.getResult();
                if (dir != null) {
                    dir = dir.removeFileExtension().addFileExtension("m");
                    ResourceUtilities.generate((String)dir.toOSString(), (String)this.model.getMatlab(), null);
                }
            }
            catch (Exception e) {
                PepaLog.logError((Throwable)e);
            }
        }
        return true;
    }
}

