/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.emf.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IDE;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.core.ResourceUtilities;
import uk.ac.ed.inf.pepa.eclipse.ui.actions.BasicProcessAlgebraModelActionDelegate;
import uk.ac.ed.inf.pepa.emf.Model;
import uk.ac.ed.inf.pepa.emf.util.EmfSupportException;
import uk.ac.ed.inf.pepa.emf.util.EmfTools;
import uk.ac.ed.inf.pepa.parsing.ModelNode;

public class ConvertToEMFActionDelegate
extends BasicProcessAlgebraModelActionDelegate {
    public void run(IAction action) {
        this.firstImpl();
    }

    private void firstImpl() {
        Shell shell = Display.getCurrent().getActiveShell();
        IResource resource = this.model.getUnderlyingResource();
        if (resource.getType() != 1) {
            MessageDialog.openError((Shell)shell, (String)"Resource Error", (String)"No underlying resource for this model");
            return;
        }
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IPath outputFile = ResourceUtilities.changeExtension((IResource)((IFile)resource), (String)"emfpepa");
        dialog.setOriginalFile(ResourcesPlugin.getWorkspace().getRoot().getFile(outputFile));
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        ModelNode modelNode = ((IPepaModel)this.model).getAST();
        if (modelNode == null) {
            return;
        }
        try {
            Model model = EmfTools.convertToEmfModel((ModelNode)modelNode);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            EmfTools.serialise((Model)model, (IFile)file);
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        }
        catch (EmfSupportException e) {
            PepaLog.logError((Throwable)e);
            MessageDialog.openError((Shell)shell, (String)"Error while creating resource", (String)("An exception was thrown while creating the resource:\nReason:\n" + e.getMessage()));
        }
        catch (PartInitException e) {
            PepaLog.logError((Throwable)e);
            MessageDialog.openError((Shell)shell, (String)"Error opening resource", (String)e.getMessage());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected void checkStatus() {
        this.action.setEnabled(this.model != null && this.model.isDerivable());
    }
}

