/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.emf.presentation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IDE;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.core.ResourceUtilities;
import uk.ac.ed.inf.pepa.eclipse.ui.actions.ActionCommands;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.IProcessAlgebraEditor;
import uk.ac.ed.inf.pepa.emf.presentation.PepaEditorPlugin;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ASTSupport;
import uk.ac.ed.inf.pepa.parsing.ModelNode;

public class EmfActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction convertToTextAction = new Action("Convert To PEPA..."){

        public boolean isEnabled() {
            if (EmfActionBarContributor.this.activeEditorPart instanceof IProcessAlgebraEditor) {
                IPepaModel model = (IPepaModel)((IProcessAlgebraEditor)EmfActionBarContributor.this.activeEditorPart).getProcessAlgebraModel();
                return model.isDerivable();
            }
            return false;
        }

        public void run() {
            Shell shell = EmfActionBarContributor.this.activeEditorPart.getEditorSite().getShell();
            if (!(EmfActionBarContributor.this.activeEditorPart instanceof IProcessAlgebraEditor)) {
                MessageDialog.openError((Shell)shell, (String)"Model Error", (String)"No model");
                return;
            }
            IPepaModel model = (IPepaModel)((IProcessAlgebraEditor)EmfActionBarContributor.this.activeEditorPart).getProcessAlgebraModel();
            IResource resource = model.getUnderlyingResource();
            if (resource.getType() != 1) {
                MessageDialog.openError((Shell)shell, (String)"Resource Error", (String)"No underlying resource for this model");
                return;
            }
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IPath outputFile = ResourceUtilities.changeExtension((IResource)((IFile)resource), (String)"pepa");
            dialog.setOriginalFile(ResourcesPlugin.getWorkspace().getRoot().getFile(outputFile));
            dialog.open();
            IPath path = dialog.getResult();
            if (path == null) {
                return;
            }
            ModelNode modelNode = model.getAST();
            if (modelNode == null) {
                return;
            }
            String sourceCode = ASTSupport.toString((ASTNode)modelNode);
            try {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                ResourceUtilities.generate((String)path.toPortableString(), (String)sourceCode, null);
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            }
            catch (Throwable t) {
                PepaLog.logError((Throwable)t);
                MessageDialog.openError((Shell)shell, (String)"Error while creating resource", (String)("An exception was thrown while creating the resource:\nReason:\n" + t.getMessage()));
            }
        }
    };
    protected IAction deriveAction = new Action("Derive..."){

        public boolean isEnabled() {
            if (EmfActionBarContributor.this.activeEditorPart instanceof IProcessAlgebraEditor) {
                IPepaModel model = (IPepaModel)((IProcessAlgebraEditor)EmfActionBarContributor.this.activeEditorPart).getProcessAlgebraModel();
                return model.isDerivable();
            }
            return false;
        }

        public void run() {
            if (EmfActionBarContributor.this.activeEditorPart instanceof IProcessAlgebraEditor) {
                IPepaModel model = (IPepaModel)((IProcessAlgebraEditor)EmfActionBarContributor.this.activeEditorPart).getProcessAlgebraModel();
                ActionCommands.derive((IProcessAlgebraModel)model);
            }
        }
    };
    protected IAction ctmcAction = new Action("Steady State Analysis..."){

        public boolean isEnabled() {
            if (EmfActionBarContributor.this.activeEditorPart instanceof IProcessAlgebraEditor) {
                IPepaModel model = (IPepaModel)((IProcessAlgebraEditor)EmfActionBarContributor.this.activeEditorPart).getProcessAlgebraModel();
                return model.isSolvable();
            }
            return false;
        }

        public void run() {
            if (EmfActionBarContributor.this.activeEditorPart instanceof IProcessAlgebraEditor) {
                IPepaModel model = (IPepaModel)((IProcessAlgebraEditor)EmfActionBarContributor.this.activeEditorPart).getProcessAlgebraModel();
                ActionCommands.steadyState((IProcessAlgebraModel)model);
            }
        }
    };
    protected IAction experimentationAction = new Action("Experimentation..."){

        public boolean isEnabled() {
            if (EmfActionBarContributor.this.activeEditorPart instanceof IProcessAlgebraEditor) {
                IPepaModel model = (IPepaModel)((IProcessAlgebraEditor)EmfActionBarContributor.this.activeEditorPart).getProcessAlgebraModel();
                return model.isDerivable();
            }
            return false;
        }

        public void run() {
            if (EmfActionBarContributor.this.activeEditorPart instanceof IProcessAlgebraEditor) {
                IPepaModel model = (IPepaModel)((IProcessAlgebraEditor)EmfActionBarContributor.this.activeEditorPart).getProcessAlgebraModel();
                ActionCommands.experiment((IPepaModel)model);
            }
        }
    };
    protected IAction showEditingDomainAction = new Action("Show Editing Domain (DEBUG)"){

        public void run() {
            if (EmfActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider) {
                IEditingDomainProvider provider = (IEditingDomainProvider)EmfActionBarContributor.this.activeEditorPart;
                EditingDomain domain = provider.getEditingDomain();
                int no = domain.getResourceSet().getResources().size();
                StringBuffer info = new StringBuffer();
                info.append("Number of resources: " + no + "\n");
                int i = 0;
                while (i < no) {
                    Resource res = (Resource)domain.getResourceSet().getResources().get(i);
                    URI uri = res.getURI();
                    String complete = uri.path();
                    String newString = complete.substring(10);
                    Path pluginPath = new Path(newString);
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)pluginPath);
                    if (file != null) {
                        info.append("File exists: " + file.getFullPath().toOSString() + "\n");
                    }
                    ++i;
                }
                MessageDialog.openInformation((Shell)EmfActionBarContributor.this.activeEditorPart.getSite().getShell(), (String)"Editing Domain", (String)info.toString());
            }
        }
    };
    protected IAction showPropertiesViewAction = new Action(PepaEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                EmfActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                PepaEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(PepaEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return EmfActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (EmfActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)EmfActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };

    public EmfActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("emf-settings"));
        toolBarManager.add((IContributionItem)new Separator("emf-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(PepaEditorPlugin.INSTANCE.getString("_UI_EmfEditor_menu"), "uk.ac.ed.inf.pepa.emfMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EmfActionBarContributor.this.setPepaActionStatus();
            }
        });
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("pepa-actions"));
        menuManager.insertAfter("pepa-actions", (IContributionItem)new Separator("sep-pepa"));
        this.setPepaActionStatus();
        menuManager.insertAfter("sep-pepa", this.experimentationAction);
        menuManager.insertAfter("sep-pepa", this.ctmcAction);
        menuManager.insertAfter("sep-pepa", this.deriveAction);
        menuManager.insertAfter("sep-pepa", this.convertToTextAction);
        menuManager.insertAfter("pepa-actions", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    private void setPepaActionStatus() {
        this.experimentationAction.setEnabled(this.experimentationAction.isEnabled());
        this.deriveAction.setEnabled(this.deriveAction.isEnabled());
        this.ctmcAction.setEnabled(this.ctmcAction.isEnabled());
        this.convertToTextAction.setEnabled(this.convertToTextAction.isEnabled());
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }
}

