/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.emf.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import uk.ac.ed.inf.pepa.emf.Action;
import uk.ac.ed.inf.pepa.emf.ActionIdentifier;
import uk.ac.ed.inf.pepa.emf.Activity;
import uk.ac.ed.inf.pepa.emf.Aggregation;
import uk.ac.ed.inf.pepa.emf.Choice;
import uk.ac.ed.inf.pepa.emf.Cooperation;
import uk.ac.ed.inf.pepa.emf.EmfFactory;
import uk.ac.ed.inf.pepa.emf.FiniteRate;
import uk.ac.ed.inf.pepa.emf.Hiding;
import uk.ac.ed.inf.pepa.emf.Model;
import uk.ac.ed.inf.pepa.emf.NumberLiteral;
import uk.ac.ed.inf.pepa.emf.PassiveRate;
import uk.ac.ed.inf.pepa.emf.Prefix;
import uk.ac.ed.inf.pepa.emf.Process;
import uk.ac.ed.inf.pepa.emf.ProcessAssignment;
import uk.ac.ed.inf.pepa.emf.ProcessIdentifier;
import uk.ac.ed.inf.pepa.emf.Rate;
import uk.ac.ed.inf.pepa.emf.RateAssignment;
import uk.ac.ed.inf.pepa.emf.RateExpression;
import uk.ac.ed.inf.pepa.emf.RateIdentifier;
import uk.ac.ed.inf.pepa.emf.RateOperator;
import uk.ac.ed.inf.pepa.emf.SilentAction;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.Actions;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;

public final class EmfExporter {
    private EmfFactory factory = EmfFactory.eINSTANCE;
    private ModelNode modelNode;

    EmfExporter(ModelNode astNode) {
        this.modelNode = astNode;
    }

    protected Model convert() {
        EmfVisitor visitor = new EmfVisitor();
        this.modelNode.accept((ASTVisitor)visitor);
        return (Model)visitor.converted;
    }

    class EmfVisitor
    implements ASTVisitor {
        EObject converted;

        EmfVisitor() {
        }

        public void visitActionTypeNode(ActionTypeNode actionType) {
            ActionIdentifier action = EmfExporter.this.factory.createActionIdentifier();
            action.setName(actionType.getType());
            this.converted = action;
        }

        public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
            SilentAction action = EmfExporter.this.factory.createSilentAction();
            this.converted = action;
        }

        public void visitActivityNode(ActivityNode activity) {
            Activity act = EmfExporter.this.factory.createActivity();
            EmfVisitor visitor = new EmfVisitor();
            activity.getAction().accept((ASTVisitor)visitor);
            act.setAction((Action)visitor.converted);
            visitor = new EmfVisitor();
            activity.getRate().accept((ASTVisitor)visitor);
            act.setRate((Rate)visitor.converted);
            this.converted = act;
        }

        public void visitAggregationNode(AggregationNode aggregation) {
            Aggregation agg = EmfExporter.this.factory.createAggregation();
            EmfVisitor visitor = new EmfVisitor();
            aggregation.getProcessNode().accept((ASTVisitor)visitor);
            agg.setProcess((Process)visitor.converted);
            new EmfVisitor();
            aggregation.getCopies().accept((ASTVisitor)visitor);
            agg.setCopies((FiniteRate)visitor.converted);
            this.converted = agg;
        }

        private void handleActionSet(Actions from, EList to) {
            for (ActionTypeNode actionNode : from) {
                ActionIdentifier actId = EmfExporter.this.factory.createActionIdentifier();
                actId.setName(actionNode.getType());
                to.add((Object)actId);
            }
        }

        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
            EmfVisitor rateLhs = new EmfVisitor();
            rate.getLeft().accept((ASTVisitor)rateLhs);
            EmfVisitor rateRhs = new EmfVisitor();
            rate.getRight().accept((ASTVisitor)rateRhs);
            RateExpression rateExp = EmfExporter.this.factory.createRateExpression();
            rateExp.setLeftHandSide((FiniteRate)rateLhs.converted);
            rateExp.setRightHandSide((FiniteRate)rateRhs.converted);
            if (rate.getOperator() == BinaryOperatorRateNode.Operator.DIV) {
                rateExp.setOperator(RateOperator.DIVIDE_LITERAL);
            }
            if (rate.getOperator() == BinaryOperatorRateNode.Operator.MULT) {
                rateExp.setOperator(RateOperator.TIMES_LITERAL);
            }
            if (rate.getOperator() == BinaryOperatorRateNode.Operator.PLUS) {
                rateExp.setOperator(RateOperator.PLUS_LITERAL);
            }
            if (rate.getOperator() == BinaryOperatorRateNode.Operator.MINUS) {
                rateExp.setOperator(RateOperator.MINUS_LITERAL);
            }
            this.converted = rateExp;
        }

        public void visitChoiceNode(ChoiceNode choice) {
            Choice emfChoice = EmfExporter.this.factory.createChoice();
            EmfVisitor processLhs = new EmfVisitor();
            choice.getLeft().accept((ASTVisitor)processLhs);
            emfChoice.setLeftHandSide((Process)processLhs.converted);
            EmfVisitor processRhs = new EmfVisitor();
            choice.getRight().accept((ASTVisitor)processRhs);
            emfChoice.setRightHandSide((Process)processRhs.converted);
            this.converted = emfChoice;
        }

        public void visitConstantProcessNode(ConstantProcessNode constant) {
            ProcessIdentifier procId = EmfExporter.this.factory.createProcessIdentifier();
            procId.setName(constant.getName());
            this.converted = procId;
        }

        public void visitCooperationNode(CooperationNode cooperation) {
            Cooperation emfCooperation = EmfExporter.this.factory.createCooperation();
            EmfVisitor processLhs = new EmfVisitor();
            cooperation.getLeft().accept((ASTVisitor)processLhs);
            emfCooperation.setLeftHandSide((Process)processLhs.converted);
            EmfVisitor processRhs = new EmfVisitor();
            cooperation.getRight().accept((ASTVisitor)processRhs);
            emfCooperation.setRightHandSide((Process)processRhs.converted);
            this.handleActionSet(cooperation.getActionSet(), emfCooperation.getActions());
            this.converted = emfCooperation;
        }

        public void visitHidingNode(HidingNode hiding) {
            Hiding emfHiding = EmfExporter.this.factory.createHiding();
            EmfVisitor procVisitor = new EmfVisitor();
            hiding.getProcess().accept((ASTVisitor)procVisitor);
            emfHiding.setHiddenProcess((Process)procVisitor.converted);
            this.handleActionSet(hiding.getActionSet(), emfHiding.getActions());
            this.converted = emfHiding;
        }

        public void visitModelNode(ModelNode model) {
            EmfVisitor rateVisitor;
            Model emfModel = EmfExporter.this.factory.createModel();
            for (RateDefinitionNode rateDef : model.rateDefinitions()) {
                rateVisitor = new EmfVisitor();
                rateDef.accept((ASTVisitor)rateVisitor);
                emfModel.getRateAssignments().add((Object)rateVisitor.converted);
            }
            for (ProcessDefinitionNode procDef : model.processDefinitions()) {
                rateVisitor = new EmfVisitor();
                procDef.accept((ASTVisitor)rateVisitor);
                emfModel.getProcessAssignments().add((Object)rateVisitor.converted);
            }
            EmfVisitor sysEq = new EmfVisitor();
            model.getSystemEquation().accept((ASTVisitor)sysEq);
            emfModel.setSystemEquation((Process)sysEq.converted);
            this.converted = emfModel;
        }

        public void visitPassiveRateNode(PassiveRateNode passive) {
            PassiveRate passiveRate = EmfExporter.this.factory.createPassiveRate();
            passiveRate.setWeight(passive.getMultiplicity());
            this.converted = passiveRate;
        }

        public void visitPrefixNode(PrefixNode prefix) {
            Prefix emfPrefix = EmfExporter.this.factory.createPrefix();
            EmfVisitor procVisitor = new EmfVisitor();
            prefix.getTarget().accept((ASTVisitor)procVisitor);
            emfPrefix.setTargetProcess((Process)procVisitor.converted);
            EmfVisitor actVisitor = new EmfVisitor();
            prefix.getActivity().accept((ASTVisitor)actVisitor);
            emfPrefix.setActivity((Activity)actVisitor.converted);
            this.converted = emfPrefix;
        }

        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            ProcessAssignment procAss = EmfExporter.this.factory.createProcessAssignment();
            EmfVisitor lhsVisitor = new EmfVisitor();
            processDefinition.getName().accept((ASTVisitor)lhsVisitor);
            EmfVisitor rhsVisitor = new EmfVisitor();
            processDefinition.getNode().accept((ASTVisitor)rhsVisitor);
            procAss.setProcessIdentifier((ProcessIdentifier)lhsVisitor.converted);
            procAss.setProcess((Process)rhsVisitor.converted);
            this.converted = procAss;
        }

        public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
            RateAssignment rateAss = EmfExporter.this.factory.createRateAssignment();
            EmfVisitor lhsVisitor = new EmfVisitor();
            rateDefinition.getName().accept((ASTVisitor)lhsVisitor);
            EmfVisitor rhsVisitor = new EmfVisitor();
            rateDefinition.getRate().accept((ASTVisitor)rhsVisitor);
            rateAss.setRateIdentifier((RateIdentifier)lhsVisitor.converted);
            rateAss.setRate((FiniteRate)rhsVisitor.converted);
            this.converted = rateAss;
        }

        public void visitRateDoubleNode(RateDoubleNode doubleRate) {
            NumberLiteral lit = EmfExporter.this.factory.createNumberLiteral();
            lit.setValue(doubleRate.getValue());
            this.converted = lit;
        }

        public void visitVariableRateNode(VariableRateNode variableRate) {
            RateIdentifier id = EmfExporter.this.factory.createRateIdentifier();
            id.setName(variableRate.getName());
            this.converted = id;
        }

        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            throw new UnsupportedOperationException();
        }
    }
}

