/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.emf.util;

import org.eclipse.emf.ecore.EObject;
import uk.ac.ed.inf.pepa.emf.Action;
import uk.ac.ed.inf.pepa.emf.ActionIdentifier;
import uk.ac.ed.inf.pepa.emf.Activity;
import uk.ac.ed.inf.pepa.emf.Aggregation;
import uk.ac.ed.inf.pepa.emf.Choice;
import uk.ac.ed.inf.pepa.emf.Cooperation;
import uk.ac.ed.inf.pepa.emf.Hiding;
import uk.ac.ed.inf.pepa.emf.Model;
import uk.ac.ed.inf.pepa.emf.NumberLiteral;
import uk.ac.ed.inf.pepa.emf.PassiveRate;
import uk.ac.ed.inf.pepa.emf.Prefix;
import uk.ac.ed.inf.pepa.emf.ProcessAssignment;
import uk.ac.ed.inf.pepa.emf.ProcessIdentifier;
import uk.ac.ed.inf.pepa.emf.ProcessWithSet;
import uk.ac.ed.inf.pepa.emf.RateAssignment;
import uk.ac.ed.inf.pepa.emf.RateExpression;
import uk.ac.ed.inf.pepa.emf.RateIdentifier;
import uk.ac.ed.inf.pepa.emf.RateOperator;
import uk.ac.ed.inf.pepa.emf.SilentAction;
import uk.ac.ed.inf.pepa.emf.util.EmfSwitch;
import uk.ac.ed.inf.pepa.parsing.ASTFactory;
import uk.ac.ed.inf.pepa.parsing.ActionSuperNode;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.Actions;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.FiniteRateNode;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.ProcessNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.RateNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;

final class EmfImporter {
    Model emfModel;

    public EmfImporter(Model emfModel) {
        this.emfModel = emfModel;
    }

    public ModelNode convert() {
        return (ModelNode)new Visitor().doSwitch(this.emfModel);
    }

    class Visitor
    extends EmfSwitch {
        Visitor() {
        }

        @Override
        public Object caseActionIdentifier(ActionIdentifier object) {
            ActionTypeNode actionNode = ASTFactory.createActionType();
            actionNode.setType(object.getName());
            return actionNode;
        }

        @Override
        public Object caseSilentAction(SilentAction object) {
            UnknownActionTypeNode actionNode = ASTFactory.createUnknownActionType();
            return actionNode;
        }

        @Override
        public Object caseActivity(Activity object) {
            ActivityNode astActivity = ASTFactory.createActivity();
            astActivity.setAction((ActionSuperNode)new Visitor().doSwitch(object.getAction()));
            astActivity.setRate((RateNode)new Visitor().doSwitch(object.getRate()));
            return astActivity;
        }

        @Override
        public Object caseAggregation(Aggregation object) {
            AggregationNode astAggregation = ASTFactory.createAggregation();
            astAggregation.setProcessNode((ProcessNode)new Visitor().doSwitch(object.getProcess()));
            astAggregation.setCopies((FiniteRateNode)new Visitor().doSwitch(object.getCopies()));
            return astAggregation;
        }

        @Override
        public Object caseChoice(Choice object) {
            ChoiceNode astChoice = ASTFactory.createChoice();
            astChoice.setLeft((ProcessNode)new Visitor().doSwitch(object.getLeftHandSide()));
            astChoice.setRight((ProcessNode)new Visitor().doSwitch(object.getRightHandSide()));
            return astChoice;
        }

        @Override
        public Object caseProcessIdentifier(ProcessIdentifier object) {
            ConstantProcessNode node = ASTFactory.createConstant();
            node.setName(object.getName());
            return node;
        }

        @Override
        public Object caseCooperation(Cooperation object) {
            CooperationNode astCooperation = ASTFactory.createCooperation();
            astCooperation.setActionSet((Actions)this.caseProcessWithSet(object));
            astCooperation.setLeft((ProcessNode)new Visitor().doSwitch(object.getLeftHandSide()));
            astCooperation.setRight((ProcessNode)new Visitor().doSwitch(object.getRightHandSide()));
            return astCooperation;
        }

        @Override
        public Object caseNumberLiteral(NumberLiteral object) {
            RateDoubleNode rateDoubleNode = ASTFactory.createRate();
            rateDoubleNode.setValue(object.getValue());
            return rateDoubleNode;
        }

        @Override
        public Object caseRateExpression(RateExpression object) {
            BinaryOperatorRateNode rateExp = ASTFactory.createBinaryOperationRate();
            rateExp.setLeft((RateNode)new Visitor().doSwitch(object.getLeftHandSide()));
            rateExp.setRight((RateNode)new Visitor().doSwitch(object.getRightHandSide()));
            if (object.getOperator() == RateOperator.DIVIDE_LITERAL) {
                rateExp.setOperator(BinaryOperatorRateNode.Operator.DIV);
            }
            if (object.getOperator() == RateOperator.MINUS_LITERAL) {
                rateExp.setOperator(BinaryOperatorRateNode.Operator.MINUS);
            }
            if (object.getOperator() == RateOperator.TIMES_LITERAL) {
                rateExp.setOperator(BinaryOperatorRateNode.Operator.MULT);
            }
            if (object.getOperator() == RateOperator.PLUS_LITERAL) {
                rateExp.setOperator(BinaryOperatorRateNode.Operator.PLUS);
            }
            return rateExp;
        }

        @Override
        public Object caseProcessAssignment(ProcessAssignment object) {
            ProcessDefinitionNode procDef = ASTFactory.createProcessDefinition();
            procDef.setName((ConstantProcessNode)new Visitor().doSwitch(object.getProcessIdentifier()));
            procDef.setNode((ProcessNode)new Visitor().doSwitch(object.getProcess()));
            return procDef;
        }

        @Override
        public Object caseRateAssignment(RateAssignment object) {
            RateDefinitionNode rateDef = ASTFactory.createRateDefinition();
            rateDef.setName((VariableRateNode)new Visitor().doSwitch(object.getRateIdentifier()));
            rateDef.setRate((RateNode)new Visitor().doSwitch(object.getRate()));
            return rateDef;
        }

        @Override
        public Object caseHiding(Hiding object) {
            HidingNode astHiding = ASTFactory.createHiding();
            astHiding.setActionSet((Actions)this.caseProcessWithSet(object));
            astHiding.setProcess((ProcessNode)new Visitor().doSwitch(object.getHiddenProcess()));
            return astHiding;
        }

        @Override
        public Object caseModel(Model object) {
            ModelNode model = ASTFactory.createModel();
            for (Object rateDef : object.getRateAssignments()) {
                model.rateDefinitions().add((Object)((RateDefinitionNode)new Visitor().doSwitch((RateAssignment)rateDef)));
            }
            for (Object procDef : object.getProcessAssignments()) {
                model.processDefinitions().add((Object)((ProcessDefinitionNode)new Visitor().doSwitch((ProcessAssignment)procDef)));
            }
            model.setSystemEquation((ProcessNode)new Visitor().doSwitch(object.getSystemEquation()));
            return model;
        }

        @Override
        public Object caseRateIdentifier(RateIdentifier object) {
            VariableRateNode rate = ASTFactory.createRateVariable();
            rate.setName(object.getName());
            return rate;
        }

        @Override
        public Object casePassiveRate(PassiveRate object) {
            PassiveRateNode node = ASTFactory.createPassiveRate();
            node.setMultiplicity(object.getWeight());
            return node;
        }

        @Override
        public Object casePrefix(Prefix object) {
            PrefixNode astPrefix = ASTFactory.createPrefix();
            astPrefix.setActivity((ActivityNode)new Visitor().doSwitch(object.getActivity()));
            astPrefix.setTarget((ProcessNode)new Visitor().doSwitch(object.getTargetProcess()));
            return astPrefix;
        }

        @Override
        public Object caseProcessWithSet(ProcessWithSet object) {
            Actions astSet = new Actions();
            for (Object action : object.getActions()) {
                astSet.add((Object)((ActionTypeNode)new Visitor().doSwitch((Action)action)));
            }
            return astSet;
        }

        @Override
        public Object defaultCase(EObject object) {
            throw new IllegalStateException();
        }
    }
}

