/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.emf.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import uk.ac.ed.inf.pepa.emf.Model;
import uk.ac.ed.inf.pepa.emf.util.EmfExporter;
import uk.ac.ed.inf.pepa.emf.util.EmfImporter;
import uk.ac.ed.inf.pepa.emf.util.EmfSupportException;
import uk.ac.ed.inf.pepa.emf.util.EmfSwitch;
import uk.ac.ed.inf.pepa.parsing.ModelNode;

public class EmfTools {
    public static Model convertToEmfModel(ModelNode model) throws EmfSupportException {
        if (model == null) {
            throw new EmfSupportException("Model invalid", new NullPointerException());
        }
        return new EmfExporter(model).convert();
    }

    public static ModelNode convertToAST(Model emfModel) throws EmfSupportException {
        if (emfModel == null) {
            throw new EmfSupportException("Model invalid", new NullPointerException());
        }
        return new EmfImporter(emfModel).convert();
    }

    public static void serialise(Model model, IFile outputFile) throws EmfSupportException {
        EmfTools.serialise(model, EmfTools.uriFromIFile(outputFile));
    }

    public static void serialise(Model model, File outputFile) throws EmfSupportException {
        EmfTools.serialise(model, EmfTools.uriFromFile(outputFile));
    }

    private static URI uriFromFile(File file) throws EmfSupportException {
        URI uri = null;
        try {
            uri = URI.createFileURI((String)file.getAbsolutePath());
        }
        catch (IllegalArgumentException e) {
            throw new EmfSupportException(e.getMessage(), e);
        }
        return uri;
    }

    private static URI uriFromIFile(IFile file) throws EmfSupportException {
        URI uri = null;
        try {
            uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        }
        catch (IllegalArgumentException e) {
            throw new EmfSupportException(e.getMessage(), e);
        }
        return uri;
    }

    private static void serialise(Model model, URI uri) throws EmfSupportException {
        XMIResourceImpl resource = new XMIResourceImpl(uri);
        resource.getContents().add((Object)model);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            throw new EmfSupportException(e.getMessage(), e);
        }
    }

    private static Model deserialise(URI uri) throws EmfSupportException {
        Object model;
        XMIResourceImpl resource = new XMIResourceImpl(uri);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            throw new EmfSupportException(e.getMessage(), e);
        }
        if (resource.getContents() != null && resource.getContents().size() != 0 && (model = resource.getContents().get(0)) instanceof Model) {
            return (Model)model;
        }
        throw new EmfSupportException("The root object is not a model", null);
    }

    public static Model deserialise(IFile inputFile) throws EmfSupportException {
        return EmfTools.deserialise(EmfTools.uriFromIFile(inputFile));
    }

    public static Model deserialise(File inputFile) throws EmfSupportException {
        return EmfTools.deserialise(EmfTools.uriFromFile(inputFile));
    }

    private static void printAttributeValues(EObject object) {
        EClass eClass = object.eClass();
        System.out.println("Visiting: " + eClass.getName());
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            Object value = object.eGet((EStructuralFeature)attribute);
            System.out.print("attribute " + attribute.getName() + " : ");
            if (object.eIsSet((EStructuralFeature)attribute)) {
                System.out.println(value);
                continue;
            }
            System.out.println(value + " default");
        }
    }

    private static void walkModel(Model model) {
        EmfSwitch visitor = new EmfSwitch(){

            @Override
            public Object defaultCase(EObject object) {
                EmfTools.printAttributeValues(object);
                return object;
            }
        };
        TreeIterator iter = EcoreUtil.getAllContents(Collections.singleton(model));
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            visitor.doSwitch(eObject);
        }
    }
}

