/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.analysis.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.Actions;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.DefaultVisitor;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;

public class ASTActionUsageVisitor {
    private Set<String> declared = new HashSet<String>();
    private Set<String> listed = new HashSet<String>();
    private Set<String> shared = new HashSet<String>();
    private HashMap<String, List<ActionTypeNode>> usages = new HashMap();

    public ASTActionUsageVisitor(ModelNode model) {
        model.accept(new DefaultVisitor(){

            @Override
            public void visitActionTypeNode(ActionTypeNode actionType) {
                ASTActionUsageVisitor.this.declared.add(actionType.getType());
            }

            @Override
            public void visitChoiceNode(ChoiceNode choice) {
                choice.getLeft().accept(this);
                choice.getRight().accept(this);
            }

            @Override
            public void visitCooperationNode(CooperationNode cooperation) {
                ASTActionUsageVisitor.this.handle(cooperation.getActionSet(), true);
                cooperation.getLeft().accept(this);
                cooperation.getRight().accept(this);
            }

            @Override
            public void visitHidingNode(HidingNode hiding) {
                ASTActionUsageVisitor.this.handle(hiding.getActionSet(), false);
            }

            @Override
            public void visitModelNode(ModelNode model) {
                for (ProcessDefinitionNode procDef : model.processDefinitions()) {
                    procDef.accept(this);
                }
                model.getSystemEquation().accept(this);
            }

            @Override
            public void visitPrefixNode(PrefixNode prefix) {
                prefix.getActivity().getAction().accept(this);
                prefix.getTarget().accept(this);
            }

            @Override
            public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
                processDefinition.getNode().accept(this);
            }

            @Override
            public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
                cooperation.getLeft().accept(this);
                cooperation.getRight().accept(this);
            }
        });
    }

    private void handle(Actions actionSet, boolean addToShared) {
        for (ActionTypeNode action : actionSet) {
            this.listed.add(action.getType());
            if (addToShared) {
                this.shared.add(action.getType());
            }
            this.registerUsage(action.getType(), action);
        }
    }

    private void registerUsage(String name, ActionTypeNode node) {
        List<Object> nodes = null;
        if (!this.usages.containsKey(name)) {
            nodes = new ArrayList();
            this.usages.put(name, nodes);
        } else {
            nodes = this.usages.get(name);
        }
        nodes.add(node);
    }

    public ActionTypeNode[] getListedButNeverDeclared() {
        this.listed.removeAll(this.declared);
        ArrayList all = new ArrayList();
        for (String key : this.listed) {
            all.addAll(this.usages.get(key));
        }
        return all.toArray(new ActionTypeNode[all.size()]);
    }

    public Set<String> getSharedNamed() {
        return this.shared;
    }
}

