/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.analysis.internal;

import uk.ac.ed.inf.pepa.analysis.internal.ProblemManager;
import uk.ac.ed.inf.pepa.analysis.internal.ProcessCounter;
import uk.ac.ed.inf.pepa.analysis.internal.ProcessUsageManager;
import uk.ac.ed.inf.pepa.analysis.internal.RateUsageManager;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.MoveOnVisitor;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;

public class ReferenceCounterVisitor
extends MoveOnVisitor {
    private RateUsageManager rateManager;
    private ProcessUsageManager processManager;
    private ProblemManager problemManager;
    private boolean investigatingRateDefinition = true;
    private boolean investigatingSystemEquation = false;

    public ReferenceCounterVisitor(ProblemManager problemManager) {
        this.rateManager = new RateUsageManager(problemManager);
        this.processManager = new ProcessUsageManager(problemManager);
        this.problemManager = problemManager;
    }

    public ProcessUsageManager getProcessManager() {
        return this.processManager;
    }

    public RateUsageManager getRateManager() {
        return this.rateManager;
    }

    @Override
    public void visitActivityNode(ActivityNode activity) {
        activity.getRate().accept(this);
    }

    @Override
    public void visitConstantProcessNode(ConstantProcessNode constant) {
        if (!this.investigatingSystemEquation) {
            this.processManager.rhs(constant.getName());
        } else {
            ProcessCounter c = this.processManager.getCounter(constant.getName());
            if (c.lhs == 0) {
                this.problemManager.processNotDefinedError(constant.getName());
            }
        }
    }

    @Override
    public void visitModelNode(ModelNode model) {
        this.investigatingRateDefinition = true;
        this.investigatingSystemEquation = false;
        for (RateDefinitionNode rateDef : model.rateDefinitions()) {
            rateDef.accept(this);
        }
        this.investigatingRateDefinition = false;
        for (ProcessDefinitionNode processDef : model.processDefinitions()) {
            processDef.accept(this);
        }
        this.investigatingSystemEquation = true;
        model.getSystemEquation().accept(this);
        this.rateManager.warn();
        this.processManager.warn();
    }

    @Override
    public void visitPrefixNode(PrefixNode prefix) {
        prefix.getActivity().accept(this);
        prefix.getTarget().accept(this);
    }

    @Override
    public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
        this.processManager.lhs(processDefinition.getName().getName());
        processDefinition.getNode().accept(this);
    }

    @Override
    public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
        this.rateManager.lhs(rateDefinition.getName().getName());
        rateDefinition.getRate().accept(this);
    }

    @Override
    public void visitBinaryOperatorRateNode(BinaryOperatorRateNode binRate) {
        binRate.getLeft().accept(this);
        binRate.getRight().accept(this);
    }

    @Override
    public void visitAggregationNode(AggregationNode aggregation) {
        aggregation.getProcessNode().accept(this);
        aggregation.getCopies().accept(this);
    }

    @Override
    public void visitVariableRateNode(VariableRateNode variableRate) {
        if (this.investigatingRateDefinition) {
            this.rateManager.rhs(variableRate.getName());
        } else {
            this.rateManager.process(variableRate.getName());
        }
    }
}

