/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.abstraction;

import java.util.ArrayList;
import uk.ac.ed.inf.pepa.ctmc.abstraction.AbstractState;
import uk.ac.ed.inf.pepa.ctmc.abstraction.Abstraction;
import uk.ac.ed.inf.pepa.ctmc.abstraction.AggregationException;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialStateSpace;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CompositionalProperty;

public class SequentialAbstraction
implements Abstraction {
    private int numConcreteStates;
    private int numAbstractStates;
    private int numAggregatedStates = 0;
    private SequentialStateSpace concreteStateSpace;
    private short[] abstractStateIDs;
    private AbstractState[] abstractStates;
    private AbstractState[] abstractStateSpace = null;
    private boolean normalised = false;
    private ArrayList<CompositionalProperty> registeredProperties;

    public SequentialAbstraction(SequentialStateSpace concreteStateSpace) {
        concreteStateSpace.register(this);
        this.concreteStateSpace = concreteStateSpace;
        this.numAbstractStates = this.numConcreteStates = concreteStateSpace.size();
        this.abstractStateIDs = new short[this.numConcreteStates];
        this.abstractStates = new AbstractState[this.numConcreteStates];
        int i = 0;
        while (i < this.numConcreteStates) {
            this.abstractStateIDs[i] = (short)i;
            ++i;
        }
        this.registeredProperties = new ArrayList(10);
    }

    private void normalise() {
        short abstractStateCounter = 0;
        short stateCounter = (short)this.numAggregatedStates;
        this.resetAbstractStates();
        int i = 0;
        while (i < this.numConcreteStates) {
            if (this.abstractStates[i] == null) {
                stateCounter = (short)(stateCounter + 1);
            } else if (this.abstractStates[i].getID() >= 0) {
                this.abstractStateIDs[i] = this.abstractStates[i].getID();
            } else {
                this.abstractStateIDs[i] = abstractStateCounter;
                short s = abstractStateCounter;
                abstractStateCounter = (short)(s + 1);
                this.abstractStates[i].setID(s);
            }
            ++i;
        }
        this.normalised = true;
    }

    private void resetAbstractStates() {
        int i = 0;
        while (i < this.numConcreteStates) {
            if (this.abstractStates[i] != null) {
                this.abstractStates[i].setID((short)-1);
            }
            ++i;
        }
    }

    private void changed() {
        this.abstractStateSpace = null;
    }

    private int[] getConcreteIndices(short[] states) {
        int[] concreteIndices = new int[states.length];
        int i = 0;
        while (i < states.length) {
            concreteIndices[i] = this.concreteStateSpace.getIndex(states[i]);
            ++i;
        }
        return concreteIndices;
    }

    private void addAbstractState(short[] states) throws AggregationException {
        if (states.length <= 1) {
            return;
        }
        int[] indices = this.getConcreteIndices(states);
        if (!this.canAggregate(indices)) {
            throw new AggregationException();
        }
        AbstractState s = new AbstractState(states);
        int i = 0;
        while (i < indices.length) {
            this.abstractStates[indices[i]] = s;
            ++i;
        }
        this.numAbstractStates -= indices.length - 1;
        ++this.numAggregatedStates;
        this.normalise();
        this.changed();
    }

    private void removeAbstractState(AbstractState state) {
        int[] indices = this.getConcreteIndices(state.getConcrete());
        if (indices.length > 1) {
            int i = 0;
            while (i < indices.length) {
                this.abstractStates[indices[i]] = null;
                ++i;
            }
            this.numAbstractStates += indices.length - 1;
            --this.numAggregatedStates;
            this.normalise();
            this.changed();
        }
    }

    private void generateAbstractStateSpace() {
        this.abstractStateSpace = new AbstractState[this.numAbstractStates];
        int i = 0;
        while (i < this.numConcreteStates) {
            AbstractState currentState = this.abstractStates[i];
            if (currentState == null) {
                currentState = new AbstractState(this.concreteStateSpace.getState(i));
                currentState.setID(this.abstractStateIDs[i]);
            }
            this.abstractStateSpace[this.abstractStateIDs[i]] = currentState;
            ++i;
        }
    }

    public AbstractState[] getAbstractStateSpace() {
        if (!this.normalised) {
            this.normalise();
        }
        if (this.abstractStateSpace == null) {
            this.generateAbstractStateSpace();
        }
        return this.abstractStateSpace;
    }

    @Override
    public short getAbstractState(short state) {
        return this.abstractStateIDs[this.concreteStateSpace.getIndex(state)];
    }

    private AbstractState findAbstract(short state) {
        if (!this.normalised) {
            this.normalise();
        }
        if (this.abstractStateSpace == null) {
            int i = 0;
            while (i < this.abstractStateIDs.length) {
                if (this.abstractStateIDs[i] == state) {
                    AbstractState s = this.abstractStates[i];
                    if (s == null) {
                        s = new AbstractState(this.concreteStateSpace.getState(i));
                        s.setID(state);
                    }
                    return s;
                }
                ++i;
            }
            return null;
        }
        return this.abstractStateSpace[state];
    }

    @Override
    public short[] getConcreteStates(short state) {
        if (state < 0 || state >= this.numAbstractStates) assert (false);
        return this.findAbstract(state).getConcrete();
    }

    private boolean canAggregate(int[] indices) {
        if (indices.length == 0) {
            return false;
        }
        int i = 1;
        while (i < indices.length) {
            if (this.abstractStates[indices[i]] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void disaggregate(short state) {
        AbstractState s = this.findAbstract(state);
        this.removeAbstractState(s);
    }

    public void aggregate(short[] states) throws AggregationException {
        this.addAbstractState(states);
    }

    private boolean propertyContains(short[] property, AbstractState state) {
        int i = 0;
        while (i < property.length) {
            if (property[i] == state.getID()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void reorderStateSpace(short[] property) {
        AbstractState[] stateSpace = this.getAbstractStateSpace();
        AbstractState[] newStateSpace = new AbstractState[stateSpace.length];
        short[] IDMap = new short[stateSpace.length];
        short startIndex = 0;
        short endIndex = (short)(stateSpace.length - 1);
        int i = 0;
        while (i < stateSpace.length) {
            short newID;
            assert (startIndex <= endIndex);
            AbstractState state = stateSpace[i];
            if (this.propertyContains(property, state)) {
                newID = endIndex;
                endIndex = (short)(endIndex - 1);
            } else {
                newID = startIndex;
                startIndex = (short)(startIndex + 1);
            }
            newStateSpace[newID] = state;
            state.setID(newID);
            IDMap[i] = newID;
            int[] indices = this.getConcreteIndices(state.getConcrete());
            boolean isSingleState = indices.length == 1;
            int j = 0;
            while (j < indices.length) {
                int index = indices[j];
                this.abstractStateIDs[index] = newID;
                this.abstractStates[index] = isSingleState ? null : state;
                ++j;
            }
            ++i;
        }
        for (CompositionalProperty registeredProperty : this.registeredProperties) {
            registeredProperty.notifyAbstractChange(this, IDMap);
        }
        this.abstractStateSpace = newStateSpace;
        this.concreteStateSpace.reorderStates(newStateSpace);
    }

    public void registerProperty(CompositionalProperty property) {
        this.registeredProperties.add(property);
    }

    public void unregisterProperty(CompositionalProperty property) {
        this.registeredProperties.remove(property);
    }

    public void unregisterAllProperties() {
        this.registeredProperties.clear();
    }

    @Override
    public void notifySwap(int index1, int index2) {
        AbstractState abstractState2;
        short stateID2;
        short stateID1 = this.abstractStateIDs[index1];
        this.abstractStateIDs[index1] = stateID2 = this.abstractStateIDs[index2];
        this.abstractStateIDs[index2] = stateID1;
        AbstractState abstractState1 = this.abstractStates[index1];
        this.abstractStates[index1] = abstractState2 = this.abstractStates[index2];
        this.abstractStates[index2] = abstractState1;
    }

    public int size() {
        return this.numAbstractStates;
    }

    public SequentialStateSpace getConcreteStateSpace() {
        return this.concreteStateSpace;
    }

    public boolean isAbstracted() {
        return this.size() != this.concreteStateSpace.size();
    }

    public String toString() {
        String s = "";
        AbstractState[] stateSpace = this.getAbstractStateSpace();
        int i = 0;
        while (i < stateSpace.length) {
            s = String.valueOf(s) + stateSpace[i] + "\n";
            ++i;
        }
        return s;
    }
}

