/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.abstraction;

import java.awt.Point;
import uk.ac.ed.inf.pepa.ctmc.abstraction.AbstractState;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialOrder;

public class SimplePartialSequentialOrder
extends SequentialOrder {
    private Point upper;
    private Point lower;
    private boolean isAnythingComparable;

    public SimplePartialSequentialOrder(SequentialAbstraction abstraction, int propertySize) {
        super(abstraction.getConcreteStateSpace());
        int upperIndex = this.stateSpace.size();
        AbstractState[] abstractStates = abstraction.getAbstractStateSpace();
        int i = abstractStates.length - 1;
        while (i > abstractStates.length - 1 - propertySize) {
            upperIndex -= abstractStates[i].size();
            --i;
        }
        this.upper = new Point(upperIndex, this.stateSpace.size() - 1);
        this.lower = new Point(0, Math.max(0, upperIndex - 1));
        this.isAnythingComparable = upperIndex > 0;
    }

    public SimplePartialSequentialOrder(SequentialAbstraction abstraction) {
        super(abstraction.getConcreteStateSpace());
        this.upper = new Point(0, this.stateSpace.size() - 1);
        this.lower = new Point(-1, -1);
        this.isAnythingComparable = false;
    }

    @Override
    public boolean isComparableIndex(int index) {
        return index == this.upper.x || index == 0;
    }

    @Override
    public Point getNext(int index) {
        if (index >= this.lower.x && index <= this.lower.y) {
            return this.upper;
        }
        return null;
    }

    @Override
    public Point getPrevious(int index) {
        if (index >= this.lower.x && index <= this.lower.y) {
            return null;
        }
        return this.lower;
    }

    @Override
    public Point getCurrent(int index) {
        if (index >= this.lower.x && index <= this.lower.y) {
            return this.lower;
        }
        if (index >= this.upper.x && index <= this.upper.y) {
            return this.upper;
        }
        return null;
    }

    @Override
    public boolean isAnythingComparable() {
        return this.isAnythingComparable;
    }
}

