/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.common;

import java.util.ArrayList;
import java.util.BitSet;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Buffer;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IStateExplorer;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.SequentialComponentData;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;

public class Component {
    public int fOffset;
    public int fLength;
    protected ArrayList<Transition> fFirstStepDerivatives = new ArrayList();
    public double[] fApparentRates;
    public IStateExplorer fExplorer;
    private String fName = null;
    public BitSet fHidingSet = new BitSet();
    protected Buffer buf;

    public Component() {
    }

    public Component(String name) {
        this();
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void dumpMeasurement() {
    }

    public void init(IStateExplorer stateExplorer) {
        this.fExplorer = stateExplorer;
        this.buf = this.fExplorer.getBuffer();
    }

    public Transition[] getDerivatives() {
        Transition[] transition = new Transition[this.fFirstStepDerivatives.size()];
        int i = 0;
        for (Transition result : this.fFirstStepDerivatives) {
            Transition t = new Transition();
            t.fTargetProcess = new short[result.fTargetProcess.length];
            System.arraycopy(result.fTargetProcess, 0, t.fTargetProcess, 0, result.fTargetProcess.length);
            t.fActionId = result.fActionId;
            t.fRate = result.fRate;
            transition[i++] = t;
        }
        return transition;
    }

    public void update(short[] currentState) {
        short processId = currentState[this.fOffset];
        SequentialComponentData data = this.fExplorer.getData(processId);
        if (this.fHidingSet.isEmpty()) {
            this.fApparentRates = data.fArrayApparentRates;
            this.fFirstStepDerivatives = data.fFirstStepDerivative;
        } else {
            this.fApparentRates = Component.applyHidingRule(data.fArrayApparentRates, this.fHidingSet);
            this.applyHidingRule(data.fFirstStepDerivative);
        }
    }

    private final void applyHidingRule(ArrayList<Transition> firstStepDerivative) {
        this.fFirstStepDerivatives.clear();
        for (Transition t : firstStepDerivative) {
            Transition newT = this.buf.getTransition(t.fTargetProcess, this.fOffset, this.fLength, this.fHidingSet.get(t.fActionId) ? (short)-1 : (short)t.fActionId, t.fRate);
            this.fFirstStepDerivatives.add(newT);
        }
    }

    private static final double[] applyHidingRule(double[] original, BitSet hidingSet) {
        double[] copy = new double[original.length];
        int i = 0;
        while (i < copy.length) {
            copy[i] = !hidingSet.get(i) ? original[i] : 0.0;
            ++i;
        }
        return copy;
    }

    public void setHidingSet(BitSet hidingSet) {
        if (hidingSet == null) {
            throw new NullPointerException();
        }
        this.fHidingSet = hidingSet;
    }

    public String toString() {
        return String.valueOf(this.fName != null ? this.fName : "") + " Component at position: " + this.fOffset + ", length: " + this.fLength;
    }
}

