/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.common;

public class IntegerArray {
    private int[] elementData;
    private int size;

    public IntegerArray(int initialSize) {
        this.elementData = new int[initialSize];
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = this.copyOf(this.elementData, newCapacity);
        }
    }

    private int[] copyOf(int[] original, int newCapacity) {
        int[] newArray = new int[newCapacity];
        System.arraycopy(original, 0, newArray, 0, this.size);
        return newArray;
    }

    public void add(int element) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = element;
    }

    public void addNew(int element) {
        if (!this.contains(element)) {
            this.add(element);
        }
    }

    public boolean contains(int element) {
        int i = 0;
        while (i < this.size) {
            if (this.elementData[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int get(int index) {
        if (index >= 0 && index < this.size) {
            return this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", size: " + this.size);
    }

    public void trimToSize() {
        if (this.size < this.elementData.length) {
            this.elementData = this.copyOf(this.elementData, this.size);
        }
    }

    public int[] toArray() {
        int[] newArray = new int[this.size];
        System.arraycopy(this.elementData, 0, newArray, 0, this.size);
        return newArray;
    }

    public int size() {
        return this.size;
    }
}

