/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.common;

import uk.ac.ed.inf.pepa.IResourceManager;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Compiler;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IStateExplorer;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.StateExplorerBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.NewParallelBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.SequentialBuilder;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerBuilder;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.parsing.ModelNode;

public class StateSpaceBuilderFactory {
    public static IStateSpaceBuilder createStateSpaceBuilder(ModelNode model, OptionMap map, IResourceManager manager) {
        boolean aggregate = (Boolean)map.get("ctmc.derivation.aggregate_arrays");
        Model cModel = new Compiler(aggregate, model).getModel();
        int kind = (Integer)map.get("cmtc.derivation.kind");
        int storage = (Integer)map.get("ctmc.derivation.storage");
        System.out.println("Storage requested: " + storage);
        int numWorkers = 1;
        if (kind == 1 && (numWorkers = ((Integer)map.get("ctmc.derivation.parallel.num_workers")).intValue()) < 1) {
            throw new IllegalArgumentException();
        }
        IStateExplorer[] explorers = new IStateExplorer[numWorkers];
        ISymbolGenerator sg = null;
        int i = 0;
        while (i < numWorkers) {
            StateExplorerBuilder seb = new StateExplorerBuilder(cModel);
            if (i == 0) {
                sg = seb.getSymbolGenerator();
            }
            explorers[i] = seb.getExplorer();
            ++i;
        }
        if (kind == 0) {
            System.out.println("Creating sequential tool");
            return new SequentialBuilder(explorers[0], sg, storage, manager);
        }
        if (kind == 1) {
            System.out.println("Creating parallel (" + numWorkers + ")");
            return new NewParallelBuilder(explorers, sg, storage, manager);
        }
        if (kind == 2) {
            System.out.println("Creating Kronecker tool");
            return new KroneckerBuilder(explorers[0], sg, model.getSystemEquation(), storage, manager);
        }
        throw new IllegalArgumentException();
    }
}

