/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.filters;

import uk.ac.ed.inf.pepa.ctmc.derivation.FilterFactory;
import uk.ac.ed.inf.pepa.ctmc.derivation.IFilterRunner;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;

public class SequentialComponentFilter
implements IStateSpaceFilter {
    private FilterFactory.Operator fOperator;
    private int fNumCopies;
    private String componentName;

    public SequentialComponentFilter(String componentName, FilterFactory.Operator operator, int numCopies) {
        if (operator == null) {
            throw new NullPointerException();
        }
        this.componentName = componentName;
        this.fOperator = operator;
        this.fNumCopies = numCopies;
    }

    @Override
    public IFilterRunner getRunner(IStateSpace stateSpace) {
        return new SequentialFilterRunner(stateSpace);
    }

    private class SequentialFilterRunner
    implements IFilterRunner {
        private short fProcessId;
        private IStateSpace stateSpace;

        public SequentialFilterRunner(IStateSpace ss) {
            this.fProcessId = ss.getProcessId(SequentialComponentFilter.this.componentName);
            this.stateSpace = ss;
        }

        @Override
        public boolean select(int state) {
            int copies = this.stateSpace.getNumberOfCopies(state, this.fProcessId);
            if (SequentialComponentFilter.this.fOperator == FilterFactory.Operator.EQ) {
                return copies == SequentialComponentFilter.this.fNumCopies;
            }
            if (SequentialComponentFilter.this.fOperator == FilterFactory.Operator.GET) {
                return copies >= SequentialComponentFilter.this.fNumCopies;
            }
            if (SequentialComponentFilter.this.fOperator == FilterFactory.Operator.GT) {
                return copies > SequentialComponentFilter.this.fNumCopies;
            }
            if (SequentialComponentFilter.this.fOperator == FilterFactory.Operator.LET) {
                return copies <= SequentialComponentFilter.this.fNumCopies;
            }
            if (SequentialComponentFilter.this.fOperator == FilterFactory.Operator.LT) {
                return copies < SequentialComponentFilter.this.fNumCopies;
            }
            if (SequentialComponentFilter.this.fOperator == FilterFactory.Operator.NEQ) {
                return copies != SequentialComponentFilter.this.fNumCopies;
            }
            throw new IllegalStateException();
        }
    }
}

