/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.filters;

import uk.ac.ed.inf.pepa.ctmc.derivation.FilterFactory;
import uk.ac.ed.inf.pepa.ctmc.derivation.IFilterRunner;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;

public class SteadyStateThresholdFilter
implements IStateSpaceFilter {
    private FilterFactory.Operator fOperator;
    private double fThreshold;

    public SteadyStateThresholdFilter(FilterFactory.Operator operator, double threshold) {
        if (operator == null) {
            throw new NullPointerException();
        }
        this.fOperator = operator;
        this.fThreshold = threshold;
    }

    @Override
    public IFilterRunner getRunner(final IStateSpace ss) {
        return new IFilterRunner(){

            @Override
            public boolean select(int state) {
                double value = ss.getSolution(state);
                if (Double.isNaN(value)) {
                    return true;
                }
                if (SteadyStateThresholdFilter.this.fOperator == FilterFactory.Operator.EQ) {
                    return value == SteadyStateThresholdFilter.this.fThreshold;
                }
                if (SteadyStateThresholdFilter.this.fOperator == FilterFactory.Operator.GET) {
                    return value >= SteadyStateThresholdFilter.this.fThreshold;
                }
                if (SteadyStateThresholdFilter.this.fOperator == FilterFactory.Operator.GT) {
                    return value > SteadyStateThresholdFilter.this.fThreshold;
                }
                if (SteadyStateThresholdFilter.this.fOperator == FilterFactory.Operator.LET) {
                    return value <= SteadyStateThresholdFilter.this.fThreshold;
                }
                if (SteadyStateThresholdFilter.this.fOperator == FilterFactory.Operator.LT) {
                    return value < SteadyStateThresholdFilter.this.fThreshold;
                }
                if (SteadyStateThresholdFilter.this.fOperator == FilterFactory.Operator.NEQ) {
                    return value != SteadyStateThresholdFilter.this.fThreshold;
                }
                throw new IllegalStateException();
            }
        };
    }
}

