/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Component;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IStateExplorer;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Operator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.SequentialComponentData;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.HashMapSequentialComponentData;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.ProcessArray;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.StateExplorer;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.SymbolGenerator;
import uk.ac.ed.inf.pepa.model.Action;
import uk.ac.ed.inf.pepa.model.ActionSet;
import uk.ac.ed.inf.pepa.model.Aggregation;
import uk.ac.ed.inf.pepa.model.Choice;
import uk.ac.ed.inf.pepa.model.Constant;
import uk.ac.ed.inf.pepa.model.Cooperation;
import uk.ac.ed.inf.pepa.model.FiniteRate;
import uk.ac.ed.inf.pepa.model.Hiding;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.model.NamedAction;
import uk.ac.ed.inf.pepa.model.PassiveRate;
import uk.ac.ed.inf.pepa.model.Prefix;
import uk.ac.ed.inf.pepa.model.Process;
import uk.ac.ed.inf.pepa.model.Rate;
import uk.ac.ed.inf.pepa.model.Visitor;

public class MultipleStateExplorerBuilder {
    private Model model;
    private int offset = 0;
    private final HashMap<Short, Process> sequentialComponentsMap = new HashMap();
    private final HashMap<Short, NamedAction> actionMap = new HashMap();
    public final HashMap<Short, HashMapSequentialComponentData> sequentialComponentsData = new HashMap();
    private final ArrayList<Operator>[] operators;
    private final ArrayList<List<Short>> cooperationSets = new ArrayList();
    private final HashMap<Component, List<Short>> hidingSets = new HashMap();
    private final LinkedList<Component>[] sequentialComponents;
    private final StateExplorer[] explorer;
    private short seqProcess = 0;
    private short seqAction = 0;
    private LinkedList<Short> initialState = new LinkedList();
    private short[] initialStateVector;
    private int copies;

    /*
     * WARNING - void declaration
     */
    public MultipleStateExplorerBuilder(Model model, int copies) {
        this.model = model;
        this.copies = copies;
        this.sequentialComponents = new LinkedList[copies];
        int i = 0;
        while (i < copies) {
            this.sequentialComponents[i] = new LinkedList();
            ++i;
        }
        this.operators = new ArrayList[copies];
        i = 0;
        while (i < copies) {
            this.operators[i] = new ArrayList();
            ++i;
        }
        ComposerVisitor v = new ComposerVisitor();
        this.model.getSystemEquation().accept(v);
        this.initialStateVector = new short[this.initialState.size()];
        int is = 0;
        Iterator iterator = this.initialState.iterator();
        while (iterator.hasNext()) {
            short stateId = (Short)iterator.next();
            this.initialStateVector[is++] = stateId;
        }
        this.scan_two();
        short n = this.seqAction;
        for (Map.Entry<Component, List<Short>> entry : this.hidingSets.entrySet()) {
            entry.getKey().setHidingSet(this.createBitSet(entry.getValue(), n));
        }
        this.explorer = new StateExplorer[copies];
        int i2 = 0;
        while (i2 < copies) {
            void var7_11;
            this.explorer[i2] = new StateExplorer();
            boolean bl = false;
            while (var7_11 < this.operators[i2].size()) {
                List<Short> cooperationSet = this.cooperationSets.get((int)var7_11);
                Operator operator = this.operators[i2].get((int)var7_11);
                operator.setCooperationSet(this.createBitSet(cooperationSet, n));
                operator.fApparentRates = new double[n];
                ++var7_11;
            }
            for (Component component : this.sequentialComponents[i2]) {
                component.fApparentRates = new double[n];
            }
            this.explorer[i2].operators = this.operators[i2].toArray(new Operator[this.operators[i2].size()]);
            this.explorer[i2].sequentialComponents = this.sequentialComponents[i2].toArray(new Component[this.sequentialComponents[i2].size()]);
            this.explorer[i2].sequentialComponentInfo = new SequentialComponentData[this.seqProcess];
            for (Map.Entry entry : this.sequentialComponentsData.entrySet()) {
                double[] apparentRates = new double[n];
                Arrays.fill(apparentRates, 0.0);
                HashMapSequentialComponentData value = (HashMapSequentialComponentData)entry.getValue();
                for (Map.Entry<Short, Double> apparentRateEntry : value.fApparentRates.entrySet()) {
                    apparentRates[apparentRateEntry.getKey().shortValue()] = apparentRateEntry.getValue();
                }
                SequentialComponentData data = new SequentialComponentData();
                data.fFirstStepDerivative = ((HashMapSequentialComponentData)entry.getValue()).fFirstStepDerivative;
                data.fArrayApparentRates = apparentRates;
                this.explorer[i2].sequentialComponentInfo[((Short)entry.getKey()).shortValue()] = data;
            }
            this.explorer[i2].initialVector = this.initialStateVector;
            this.explorer[i2].init();
            ++i2;
        }
    }

    private BitSet createBitSet(List<Short> set, int n) {
        BitSet bitSet = new BitSet(n);
        for (short s : set) {
            bitSet.set(s);
        }
        return bitSet;
    }

    public IStateExplorer[] getExplorer() {
        return this.explorer;
    }

    public ISymbolGenerator getSymbolGenerator() {
        return new SymbolGenerator(this.initialStateVector, this.sequentialComponentsMap, this.actionMap);
    }

    private short getIndex(NamedAction action) {
        for (Map.Entry<Short, NamedAction> entry : this.actionMap.entrySet()) {
            if (!action.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        this.actionMap.put(this.seqAction, action);
        short s = this.seqAction;
        this.seqAction = (short)(s + 1);
        return s;
    }

    public short getIndex(Process process) {
        Short id = this.basicGetIndex(process);
        if (id != null) {
            return id;
        }
        this.sequentialComponentsMap.put(this.seqProcess, process);
        short s = this.seqProcess;
        this.seqProcess = (short)(s + 1);
        return s;
    }

    private Short basicGetIndex(Process process) {
        for (Map.Entry<Short, Process> entry : this.sequentialComponentsMap.entrySet()) {
            if (!process.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void scan_two() {
        boolean addedOnce;
        HashMap<Short, ArrayList<Short>> unguardedDefinitionMap = new HashMap<Short, ArrayList<Short>>();
        for (Constant constant : this.model.getProcessDefinitions()) {
            short index = this.getIndex(constant);
            unguardedDefinitionMap.put(index, new ArrayList());
            constant.getBinding().accept(new SequentialComponentVisitor(index, false, unguardedDefinitionMap));
        }
        do {
            addedOnce = false;
            for (Map.Entry entry : unguardedDefinitionMap.entrySet()) {
                HashMapSequentialComponentData sourceData = this.sequentialComponentsData.get(entry.getKey());
                if (sourceData == null) {
                    sourceData = new HashMapSequentialComponentData();
                    this.sequentialComponentsData.put((Short)entry.getKey(), sourceData);
                }
                for (Short target : (ArrayList)entry.getValue()) {
                    HashMapSequentialComponentData targetData = this.sequentialComponentsData.get(target);
                    if (targetData == null) {
                        targetData = new HashMapSequentialComponentData();
                        this.sequentialComponentsData.put(target, targetData);
                    }
                    for (Transition transition : targetData.fFirstStepDerivative) {
                        if (sourceData.fFirstStepDerivative.contains(transition)) continue;
                        sourceData.fFirstStepDerivative.add(transition);
                        Double old = sourceData.fApparentRates.get(transition.fActionId);
                        if (old == null) {
                            old = 0.0;
                        }
                        this.checkRates(old, transition.fRate, transition.fActionId);
                        double newRate = old + transition.fRate;
                        sourceData.fApparentRates.put(transition.fActionId, newRate);
                        addedOnce = true;
                    }
                }
            }
        } while (addedOnce);
    }

    private double convertRate(Rate r) {
        if (r instanceof FiniteRate) {
            return ((FiniteRate)r).getValue();
        }
        return -((PassiveRate)r).getWeight();
    }

    private void checkRates(double r1, double r2, short actionId) {
        if (r1 * r2 < 0.0) {
            throw new IllegalStateException("Action " + actionId + " with both passive and active rates");
        }
    }

    class ComposerVisitor
    implements Visitor {
        public Component[] lastVisited;

        public ComposerVisitor() {
            this.lastVisited = new Component[MultipleStateExplorerBuilder.this.copies];
        }

        private final List<Short> createActionSetIdentifiers(ActionSet set) {
            LinkedList<Short> actionSet = new LinkedList<Short>();
            Iterator<Action> iter = set.iterator();
            while (iter.hasNext()) {
                actionSet.add(MultipleStateExplorerBuilder.this.getIndex((NamedAction)iter.next()));
            }
            return actionSet;
        }

        @Override
        public void visitAggregation(Aggregation aggregation) {
            int i = 0;
            while (i < MultipleStateExplorerBuilder.this.copies) {
                ProcessArray array = new ProcessArray();
                MultipleStateExplorerBuilder.this.sequentialComponents[i].add(array);
                assert (aggregation.getSubProcesses().entrySet().size() == 1);
                Process initialProcess = aggregation.getSubProcesses().keySet().iterator().next();
                if (i == 0) {
                    short initialId = MultipleStateExplorerBuilder.this.getIndex(initialProcess);
                    int j = 0;
                    while (j < aggregation.getCopies()) {
                        MultipleStateExplorerBuilder.this.initialState.add(initialId);
                        ++j;
                    }
                }
                array.fLength = aggregation.getCopies();
                array.fOffset = MultipleStateExplorerBuilder.this.offset;
                this.lastVisited[i] = array;
                ++i;
            }
            MultipleStateExplorerBuilder multipleStateExplorerBuilder = MultipleStateExplorerBuilder.this;
            multipleStateExplorerBuilder.offset = multipleStateExplorerBuilder.offset + aggregation.getCopies();
        }

        @Override
        public void visitChoice(Choice choice) {
            throw new IllegalStateException("Choice shouldn't be seen in the system equation");
        }

        @Override
        public void visitConstant(Constant constant) {
            int i = 0;
            while (i < MultipleStateExplorerBuilder.this.copies) {
                Component component = new Component(constant.getName());
                MultipleStateExplorerBuilder.this.sequentialComponents[i].add(component);
                if (i == 0) {
                    MultipleStateExplorerBuilder.this.initialState.add(MultipleStateExplorerBuilder.this.getIndex(constant));
                }
                component.fLength = 1;
                component.fOffset = MultipleStateExplorerBuilder.this.offset;
                this.lastVisited[i] = component;
                ++i;
            }
            MultipleStateExplorerBuilder multipleStateExplorerBuilder = MultipleStateExplorerBuilder.this;
            multipleStateExplorerBuilder.offset = multipleStateExplorerBuilder.offset + 1;
        }

        @Override
        public void visitCooperation(Cooperation cooperation) {
            int i = 0;
            while (i < MultipleStateExplorerBuilder.this.copies) {
                Operator operator = new Operator();
                MultipleStateExplorerBuilder.this.operators[i].add(operator);
                List<Short> list = this.createActionSetIdentifiers(cooperation.getActionSet());
                MultipleStateExplorerBuilder.this.cooperationSets.add(list);
                ComposerVisitor leftVisitor = new ComposerVisitor();
                cooperation.getLeftHandSide().accept(leftVisitor);
                ComposerVisitor rightVisitor = new ComposerVisitor();
                cooperation.getRightHandSide().accept(rightVisitor);
                operator.setLeftChild(leftVisitor.lastVisited[i]);
                operator.setRightChild(rightVisitor.lastVisited[i]);
                this.lastVisited[i] = operator;
                ++i;
            }
        }

        @Override
        public void visitHiding(Hiding hiding) {
            hiding.getHiddenProcess().accept(this);
            int i = 0;
            while (i < MultipleStateExplorerBuilder.this.copies) {
                MultipleStateExplorerBuilder.this.hidingSets.put(this.lastVisited[i], this.createActionSetIdentifiers(hiding.getActionSet()));
                ++i;
            }
        }

        @Override
        public void visitPrefix(Prefix prefix) {
            throw new IllegalStateException("Prefix shouldn't be seen in the system equation");
        }
    }

    class SequentialComponentVisitor
    implements Visitor {
        short fSourceId;
        boolean fGuardedDefinition;
        HashMap<Short, ArrayList<Short>> fUnguardedDefinitionMap;

        public SequentialComponentVisitor(short sourceId, boolean guardedDefinition, HashMap<Short, ArrayList<Short>> unguardedDefinitionMap) {
            this.fSourceId = sourceId;
            this.fGuardedDefinition = guardedDefinition;
            this.fUnguardedDefinitionMap = unguardedDefinitionMap;
        }

        @Override
        public void visitAggregation(Aggregation aggregation) {
            throw new IllegalStateException("Aggregation " + aggregation.prettyPrint() + " should" + "not be found in sequential component definition");
        }

        @Override
        public void visitChoice(Choice choice) {
            choice.getLeftHandSide().accept(this);
            choice.getRightHandSide().accept(this);
        }

        @Override
        public void visitConstant(Constant constant) {
            if (!this.fGuardedDefinition) {
                short targetId = MultipleStateExplorerBuilder.this.getIndex(constant);
                this.fUnguardedDefinitionMap.get(this.fSourceId).add(targetId);
            }
        }

        @Override
        public void visitCooperation(Cooperation cooperation) {
            throw new IllegalStateException("Cooperation " + cooperation.prettyPrint() + " should" + "not be found in sequential component definition");
        }

        @Override
        public void visitHiding(Hiding hiding) {
            throw new IllegalStateException("Hiding " + hiding.prettyPrint() + " should" + "not be found in sequential component definition");
        }

        @Override
        public void visitPrefix(Prefix prefix) {
            short actionId;
            HashMapSequentialComponentData data = MultipleStateExplorerBuilder.this.sequentialComponentsData.get(this.fSourceId);
            if (data == null) {
                data = new HashMapSequentialComponentData();
                MultipleStateExplorerBuilder.this.sequentialComponentsData.put(this.fSourceId, data);
            }
            Action action = prefix.getActivity().getAction();
            double rate = MultipleStateExplorerBuilder.this.convertRate(prefix.getActivity().getRate());
            if (action instanceof NamedAction) {
                actionId = MultipleStateExplorerBuilder.this.getIndex((NamedAction)action);
                double oldValue = data.fApparentRates.containsKey(actionId) ? data.fApparentRates.get(actionId) : 0.0;
                MultipleStateExplorerBuilder.this.checkRates(oldValue, rate, actionId);
                double newValue = oldValue + rate;
                data.fApparentRates.put(actionId, newValue);
            } else {
                actionId = -1;
            }
            Process target = prefix.getTargetProcess();
            Transition transition = new Transition();
            short targetProcessId = MultipleStateExplorerBuilder.this.getIndex(target);
            transition.fTargetProcess = new short[MultipleStateExplorerBuilder.this.initialStateVector.length];
            Arrays.fill(transition.fTargetProcess, targetProcessId);
            transition.fActionId = actionId;
            transition.fRate = rate;
            data.fFirstStepDerivative.add(transition);
            HashMapSequentialComponentData targetData = MultipleStateExplorerBuilder.this.sequentialComponentsData.get(targetProcessId);
            if (targetData == null) {
                target.accept(new SequentialComponentVisitor(targetProcessId, true, this.fUnguardedDefinitionMap));
            }
        }
    }
}

