/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal;

import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Buffer;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Component;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IStateExplorer;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Operator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.SequentialComponentData;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;

public class StateExplorer
implements IStateExplorer {
    Component[] sequentialComponents;
    Operator[] operators;
    SequentialComponentData[] sequentialComponentInfo;
    short[] initialVector;
    private Buffer buf;

    StateExplorer() {
    }

    @Override
    public void init() {
        this.buf = new Buffer(this.initialVector.length);
        Component[] componentArray = this.sequentialComponents;
        int n = this.sequentialComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.init(this);
            ++n2;
        }
        componentArray = this.operators;
        n = this.operators.length;
        n2 = 0;
        while (n2 < n) {
            Component o = componentArray[n2];
            o.init(this);
            ++n2;
        }
    }

    @Override
    public void dispose() {
        int i = this.operators.length - 1;
        while (i >= 0) {
            this.operators[i].dumpMeasurement();
            --i;
        }
        this.buf = null;
    }

    public void debug() {
        System.out.println("List of components:");
        Component[] componentArray = this.sequentialComponents;
        int n = this.sequentialComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            System.out.println(c.toString());
            ++n2;
        }
        System.out.println("List of operators:");
        componentArray = this.operators;
        n = this.operators.length;
        n2 = 0;
        while (n2 < n) {
            Component o = componentArray[n2];
            System.out.println(((Operator)o).toString());
            ++n2;
        }
    }

    @Override
    public Transition[] exploreState(short[] state) throws DerivationException {
        this.buf.clear();
        Component[] componentArray = this.sequentialComponents;
        int n = this.sequentialComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.update(state);
            ++n2;
        }
        int i = this.operators.length - 1;
        while (i >= 0) {
            this.operators[i].compose(state);
            --i;
        }
        if (this.operators.length == 0) {
            return this.sequentialComponents[0].getDerivatives();
        }
        return this.operators[0].getDerivatives();
    }

    @Override
    public SequentialComponentData getData(short processId) {
        return this.sequentialComponentInfo[processId];
    }

    @Override
    public final Buffer getBuffer() {
        return this.buf;
    }
}

