/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.LocalState;
import uk.ac.ed.inf.pepa.ctmc.PopulationLevelResult;
import uk.ac.ed.inf.pepa.ctmc.SequentialComponent;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.Generator;
import uk.ac.ed.inf.pepa.model.Constant;
import uk.ac.ed.inf.pepa.model.Process;

public abstract class AbstractStateSpace
implements IStateSpace {
    protected static final ThroughputResult[] EMPTY_THROUGHPUT = new ThroughputResult[0];
    protected static final SequentialComponent[] EMPTY_UTILISATION = new SequentialComponent[0];
    protected static final PopulationLevelResult[] EMPTY_POPULATION = new PopulationLevelResult[0];
    protected double[] solution = null;
    protected ThroughputResult[] throughput = EMPTY_THROUGHPUT;
    protected SequentialComponent[] utilisation = EMPTY_UTILISATION;
    protected PopulationLevelResult[] populations = EMPTY_POPULATION;
    protected ISymbolGenerator symbolGenerator;
    private String[] orderedComponentNames;
    protected ArrayList<State> states;
    private boolean hasVariableLengthStates;
    private int maximumLength;

    protected AbstractStateSpace(ISymbolGenerator symbolGenerator, ArrayList<State> states, boolean hasVariableLengthStates, int maximumLength) {
        this.symbolGenerator = symbolGenerator;
        this.states = states;
        Collection<String> names = symbolGenerator.getSequentialComponentNames();
        this.orderedComponentNames = names.toArray(new String[names.size()]);
        this.hasVariableLengthStates = hasVariableLengthStates;
        this.maximumLength = maximumLength;
    }

    @Override
    public int getNumberOfSequentialComponents(int stateIndex) {
        if (!this.hasVariableLengthStates) {
            return this.maximumLength;
        }
        return this.states.get((int)stateIndex).fState.length;
    }

    @Override
    public int getMaximumNumberOfSequentialComponents() {
        return this.maximumLength;
    }

    protected abstract FlexCompRowMatrix createGeneratorMatrix();

    protected abstract Generator createSimpleGenerator();

    private void internalSetSolution(double[] pdf) {
        this.solution = pdf;
        this.doUtilisationAndPopulationLevels(null);
        this.doThroughput(null);
    }

    protected abstract void doThroughput(IProgressMonitor var1);

    private final void doUtilisationAndPopulationLevels(IProgressMonitor monitor) {
        boolean doUtilisation;
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        monitor.beginTask(2 * this.size());
        this.populations = EMPTY_POPULATION;
        this.utilisation = EMPTY_UTILISATION;
        if (this.solution == null) {
            monitor.done();
            return;
        }
        boolean doPopulation = true;
        boolean bl = doUtilisation = !this.hasVariableLengthStates;
        if (doPopulation) {
            this.doPopulation(monitor);
        }
        if (doUtilisation) {
            this.doUtilisation(monitor);
        }
        monitor.done();
    }

    private void doUtilisation(IProgressMonitor monitor) {
        HashMap[] utilisationMaps = new HashMap[this.getMaximumNumberOfSequentialComponents()];
        int i = 0;
        while (i < utilisationMaps.length) {
            utilisationMaps[i] = new HashMap();
            ++i;
        }
        int stateNumber = 0;
        for (State state : this.states) {
            if (monitor.isCanceled()) {
                monitor.done();
                return;
            }
            if ((stateNumber + 1) % 10000 == 0) {
                System.out.println("States: " + stateNumber);
                monitor.worked(10000);
            }
            int seqComp = 0;
            while (seqComp < utilisationMaps.length) {
                double steadyStateSolution = this.solution[state.stateNumber];
                short processId = state.fState[seqComp];
                Double current = (Double)utilisationMaps[seqComp].get(processId);
                if (current == null) {
                    current = 0.0;
                }
                current = current + steadyStateSolution;
                utilisationMaps[seqComp].put(processId, current);
                ++seqComp;
            }
        }
        this.utilisation = new SequentialComponent[utilisationMaps.length];
        int i2 = 0;
        while (i2 < utilisationMaps.length) {
            LocalState[] states = new LocalState[utilisationMaps[i2].size()];
            int j = 0;
            HashMap currentMap = utilisationMaps[i2];
            for (Map.Entry entry : currentMap.entrySet()) {
                states[j++] = new LocalState(this.symbolGenerator.getProcessLabel((Short)entry.getKey()), (Double)entry.getValue());
            }
            this.utilisation[i2] = new SequentialComponent(this.getLabel(0, i2), states);
            ++i2;
        }
    }

    private void doPopulation(IProgressMonitor monitor) {
        HashMap<Short, Double> populationLevels = new HashMap<Short, Double>(this.getComponentNames().length);
        int stateNumber = 0;
        for (State state : this.states) {
            if (monitor.isCanceled()) {
                monitor.done();
                return;
            }
            if ((stateNumber + 1) % 10000 == 0) {
                System.out.println("States: " + stateNumber);
                monitor.worked(10000);
            }
            double steadyStateSolution = this.solution[state.stateNumber];
            short[] sArray = state.fState;
            int n = state.fState.length;
            int n2 = 0;
            while (n2 < n) {
                short processId = sArray[n2];
                this.add(processId, steadyStateSolution, populationLevels);
                ++n2;
            }
        }
        this.populations = new PopulationLevelResult[populationLevels.size()];
        int i = 0;
        for (Map.Entry entry : populationLevels.entrySet()) {
            this.populations[i++] = new PopulationLevelResult(this.symbolGenerator.getProcessLabel((Short)entry.getKey()), (Double)entry.getValue());
        }
    }

    private void add(short seqComponentId, double value, HashMap<Short, Double> map) {
        Double c = map.get(seqComponentId);
        if (c == null) {
            c = 0.0;
        }
        c = c + value;
        map.put(seqComponentId, c);
    }

    @Override
    public abstract String[] getAction(int var1, int var2);

    @Override
    public String[] getComponentNames() {
        return this.orderedComponentNames;
    }

    @Override
    public abstract int[] getIncomingStateIndices(int var1);

    @Override
    public final String getLabel(int stateIndex, int position) {
        return this.symbolGenerator.getProcessLabel(this.states.get((int)stateIndex).fState[position]);
    }

    @Override
    public final int getNumberOfCopies(int stateIndex, short processId) {
        return this.symbolGenerator.getNumOfCopies(processId, this.states.get((int)stateIndex).fState);
    }

    @Override
    public abstract int[] getOutgoingStateIndices(int var1);

    @Override
    public PopulationLevelResult[] getPopulationLevels() {
        return this.populations;
    }

    @Override
    public final short getProcessId(int stateIndex, int position) {
        return this.states.get((int)stateIndex).fState[position];
    }

    @Override
    public final short getProcessId(String process) {
        return this.symbolGenerator.getProcessId(process);
    }

    @Override
    public abstract double getRate(int var1, int var2);

    @Override
    public double getSolution(int index) {
        if (this.solution == null) {
            return Double.NaN;
        }
        return this.solution[index];
    }

    @Override
    public ThroughputResult[] getThroughput() {
        return this.throughput;
    }

    @Override
    public SequentialComponent[] getUtilisation() {
        return this.utilisation;
    }

    @Override
    public final boolean isSolutionAvailable() {
        return this.solution != null;
    }

    @Override
    public final boolean isUnnamed(int stateIndex, int position) {
        Process process = this.symbolGenerator.getSequentialComponentMap().get(this.states.get((int)stateIndex).fState[position]);
        if (process == null) {
            return false;
        }
        return !(process instanceof Constant);
    }

    @Override
    public void setSolution(double[] solution) {
        if (solution != null && this.size() != solution.length) {
            throw new IllegalArgumentException();
        }
        this.internalSetSolution(solution);
    }

    @Override
    public int size() {
        return this.states.size();
    }

    public Object getGeneratorMatrix(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz == FlexCompRowMatrix.class) {
            return this.createGeneratorMatrix();
        }
        if (clazz == Generator.class) {
            return this.createSimpleGenerator();
        }
        return null;
    }
}

