/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.IResourceManager;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IntegerArray;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.AbstractStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.DiskDoubleArray;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.DiskIntegerArray;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.DiskShortArray;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.Generator;

public class DiskBasedStateSpace
extends AbstractStateSpace {
    private static final int BYTES_TO_SKIP = 4;
    private static final int BUFFER_SIZE = 16384;
    private DiskIntegerArray row;
    private DiskIntegerArray column;
    private DiskDoubleArray value;
    private DiskShortArray action;
    private String actionPath;
    private String valuePath;
    private String columnPath;
    private String rowPath;
    private int t_count;
    private IResourceManager manager;

    protected DiskBasedStateSpace(ISymbolGenerator symbolGenerator, ArrayList<State> states, IResourceManager manager, String rowPath, String columnPath, String actionPath, String valuePath, int t_count, boolean hasVariableLengthStates, int maximumLength) throws IOException {
        super(symbolGenerator, states, hasVariableLengthStates, maximumLength);
        this.rowPath = rowPath;
        this.columnPath = columnPath;
        this.actionPath = actionPath;
        this.valuePath = valuePath;
        this.manager = manager;
        this.t_count = t_count;
        this.row = new DiskIntegerArray(rowPath);
        this.column = new DiskIntegerArray(columnPath);
        this.action = new DiskShortArray(actionPath);
        this.value = new DiskDoubleArray(valuePath);
    }

    private Range getColumnRange(int row) throws IOException {
        Range range = new Range();
        RandomAccessFile f = this.row.getFile();
        f.seek(row << 2);
        range.start = f.readInt();
        range.end = row < this.row.size() - 1 ? f.readInt() : this.column.size();
        return range;
    }

    private int getValueRangeEnd(int j) throws IOException {
        return j < this.column.size() - 3 ? this.column.get(j + 3) : this.value.size();
    }

    @Override
    protected void doThroughput(IProgressMonitor monitor) {
        this.throughput = EMPTY_THROUGHPUT;
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        if (this.solution == null) {
            monitor.done();
            return;
        }
        int valueSize = this.value.size();
        HashMap<Short, Double> thMap = new HashMap<Short, Double>();
        FilterInputStream rowFile = null;
        FilterInputStream actionFile = null;
        FilterInputStream valueFile = null;
        FilterInputStream columnFile = null;
        try {
            try {
                rowFile = new DataInputStream(new BufferedInputStream(new FileInputStream(this.rowPath), 16384));
                actionFile = new DataInputStream(new BufferedInputStream(new FileInputStream(this.actionPath), 16384));
                valueFile = new DataInputStream(new BufferedInputStream(new FileInputStream(this.valuePath), 16384));
                columnFile = new DataInputStream(new BufferedInputStream(new FileInputStream(this.columnPath), 16384));
                int size = this.size();
                int valueStart = 0;
                int valueEnd = 0;
                int start = 0;
                int nextStart = 0;
                int i = 0;
                while (i < size) {
                    double prob = this.solution[i];
                    if (i == 0) {
                        start = ((DataInputStream)rowFile).readInt();
                        ((DataInputStream)columnFile).skipBytes(4);
                        valueStart = ((DataInputStream)columnFile).readInt();
                    } else {
                        start = nextStart;
                        valueStart = valueEnd;
                    }
                    if (i == size - 1) {
                        valueEnd = valueSize;
                    } else {
                        nextStart = ((DataInputStream)rowFile).readInt();
                        ((DataInputStream)columnFile).skipBytes(4 * (nextStart - start - 1));
                        valueEnd = ((DataInputStream)columnFile).readInt();
                    }
                    int length = valueEnd - valueStart;
                    int k = 0;
                    while (k < length) {
                        short actionId = ((DataInputStream)actionFile).readShort();
                        Double d = (Double)thMap.get(actionId);
                        if (d == null) {
                            d = 0.0;
                        }
                        d = d + prob * ((DataInputStream)valueFile).readDouble();
                        thMap.put(actionId, d);
                        ++k;
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (rowFile != null) {
                    rowFile.close();
                }
                if (actionFile != null) {
                    actionFile.close();
                }
                if (valueFile != null) {
                    valueFile.close();
                }
                if (columnFile != null) {
                    columnFile.close();
                }
            }
            catch (IOException iOException) {
                rowFile = null;
                actionFile = null;
                valueFile = null;
                columnFile = null;
            }
            throw throwable;
        }
        try {
            if (rowFile != null) {
                rowFile.close();
            }
            if (actionFile != null) {
                actionFile.close();
            }
            if (valueFile != null) {
                valueFile.close();
            }
            if (columnFile != null) {
                columnFile.close();
            }
        }
        catch (IOException iOException) {
            rowFile = null;
            actionFile = null;
            valueFile = null;
            columnFile = null;
        }
        ThroughputResult[] result = new ThroughputResult[thMap.size()];
        int i = 0;
        for (Map.Entry entry : thMap.entrySet()) {
            ThroughputResult r = new ThroughputResult(this.symbolGenerator.getActionLabel((Short)entry.getKey()), (Double)entry.getValue());
            result[i++] = r;
        }
        this.throughput = result;
        monitor.done();
    }

    @Override
    public String[] getAction(int source, int target) {
        LinkedList<String> labels = new LinkedList<String>();
        try {
            int c1 = this.row.get(source);
            int c2 = source == this.row.size() - 1 ? this.column.size() : this.row.get(source + 1);
            boolean found = false;
            int i = c1;
            while (!found && i < c2) {
                if (this.column.get(i) == target) {
                    found = true;
                    int start = this.column.get(i + 1);
                    int stop = i + 3 <= this.column.size() - 1 ? this.column.get(i + 3) : this.action.size();
                    int diff = stop - start;
                    short[] values = new short[diff];
                    this.action.getBulk(start, stop, values);
                    int j = 0;
                    while (j < diff) {
                        labels.add(this.symbolGenerator.getActionLabel(values[j]));
                        ++j;
                    }
                }
                i += 2;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return labels.toArray(new String[labels.size()]);
    }

    @Override
    public int[] getIncomingStateIndices(int stateIndex) {
        IntegerArray result = new IntegerArray(this.t_count / this.size());
        RandomAccessFile columnFile = this.column.getFile();
        try {
            columnFile.seek(0L);
            int j = 0;
            int size = this.column.size();
            while (j < size) {
                int columnNumber = columnFile.readInt();
                if (j != size - 2) {
                    columnFile.skipBytes(4);
                }
                if (columnNumber == stateIndex) {
                    result.add(this.find(0, this.row.size() - 1, j));
                }
                j += 2;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return result.toArray();
    }

    private int find(int rangeStart, int rangeEnd, int index) throws IOException {
        if (rangeEnd - rangeStart < 32) {
            return this.performLinear(rangeStart, rangeEnd, index);
        }
        int i = rangeStart + (rangeEnd - rangeStart >> 1);
        Range range = this.getColumnRange(i);
        if (index < range.end && index >= range.start) {
            return i;
        }
        if (index >= range.end) {
            return this.find(i + 1, rangeEnd, index);
        }
        return this.find(rangeStart, i - 1, index);
    }

    private int performLinear(int rangeStart, int rangeEnd, int index) throws IOException {
        RandomAccessFile is = this.row.getFile();
        is.seek(rangeStart << 2);
        int rowValue = 0;
        int nextRow = 0;
        int i = rangeStart;
        while (i < rangeEnd) {
            rowValue = i == 0 ? is.readInt() : nextRow;
            int n = nextRow = i != rangeEnd - 1 ? is.readInt() : this.column.size();
            if (index < nextRow && index >= rowValue) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    @Override
    public int[] getOutgoingStateIndices(int stateIndex) {
        int[] result;
        RandomAccessFile columnFile = this.column.getFile();
        try {
            Range r = this.getColumnRange(stateIndex);
            result = new int[r.end - r.start >> 1];
            columnFile.seek(r.start << 2);
            int j = 0;
            while (j < result.length) {
                result[j] = columnFile.readInt();
                if (j != result.length - 1) {
                    columnFile.skipBytes(4);
                }
                ++j;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    @Override
    public double getRate(int source, int target) {
        double sum = 0.0;
        try {
            Range range = this.getColumnRange(source);
            int j = range.start;
            while (j < range.end) {
                if (this.column.get(j) == target) {
                    int valueStart = this.column.get(j + 1);
                    int valueEnd = this.getValueRangeEnd(j);
                    int valueDiff = valueEnd - valueStart;
                    double[] values = new double[valueDiff];
                    this.value.getBulk(valueStart, valueEnd, values);
                    int k = 0;
                    while (k < valueDiff) {
                        sum += values[k];
                        ++k;
                    }
                }
                j += 2;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sum;
    }

    @Override
    protected FlexCompRowMatrix createGeneratorMatrix() {
        FlexCompRowMatrix genMatrix;
        FilterInputStream rowFile = null;
        FilterInputStream valueFile = null;
        FilterInputStream columnFile = null;
        try {
            try {
                rowFile = new DataInputStream(new BufferedInputStream(new FileInputStream(this.rowPath), 16384));
                columnFile = new DataInputStream(new BufferedInputStream(new FileInputStream(this.columnPath), 16384));
                valueFile = new DataInputStream(new BufferedInputStream(new FileInputStream(this.valuePath), 16384));
                int size = this.size();
                genMatrix = new FlexCompRowMatrix(size, size);
                int valueSize = this.value.size();
                int valueStart = 0;
                int valueEnd = 0;
                int column = 0;
                int nextColumn = 0;
                double sum = 0.0;
                int columnRangeStart = 0;
                int columnRangeEnd = ((DataInputStream)rowFile).readInt();
                nextColumn = ((DataInputStream)columnFile).readInt();
                valueEnd = ((DataInputStream)columnFile).readInt();
                int i = 0;
                while (i < size) {
                    columnRangeStart = columnRangeEnd;
                    columnRangeEnd = i == size - 1 ? this.column.size() : ((DataInputStream)rowFile).readInt();
                    int j = 0;
                    int diff = columnRangeEnd - columnRangeStart;
                    while (j < diff) {
                        column = nextColumn;
                        valueStart = valueEnd;
                        if (i == size - 1 && j == diff - 2) {
                            valueEnd = valueSize;
                        } else {
                            nextColumn = ((DataInputStream)columnFile).readInt();
                            valueEnd = ((DataInputStream)columnFile).readInt();
                        }
                        int length = valueEnd - valueStart;
                        sum = 0.0;
                        int k = 0;
                        while (k < length) {
                            sum += ((DataInputStream)valueFile).readDouble();
                            ++k;
                        }
                        genMatrix.set(i, column, sum);
                        j += 2;
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (rowFile != null) {
                    rowFile.close();
                }
                if (valueFile != null) {
                    valueFile.close();
                }
                if (columnFile != null) {
                    columnFile.close();
                }
            }
            catch (Exception exception) {
                rowFile = null;
                valueFile = null;
                columnFile = null;
            }
            throw throwable;
        }
        try {
            if (rowFile != null) {
                rowFile.close();
            }
            if (valueFile != null) {
                valueFile.close();
            }
            if (columnFile != null) {
                columnFile.close();
            }
        }
        catch (Exception exception) {
            rowFile = null;
            valueFile = null;
            columnFile = null;
        }
        return genMatrix;
    }

    @Override
    protected Generator createSimpleGenerator() {
        return null;
    }

    @Override
    public void dispose() {
        this.manager.releasePath(this);
    }

    private static class Range {
        int start;
        int end;

        private Range() {
        }
    }
}

