/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.ed.inf.pepa.IResourceManager;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.DiskBasedStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.ICallbackListener;

public class DiskCallback
implements ICallbackListener {
    private static final String ROW_FILE = "row.dat";
    private static final String COLUMN_FILE = "column.dat";
    private static final String VALUE_FILE = "value.dat";
    private static final String ACTION_FILE = "action.dat";
    private static final int BUFFER_SIZE = 16384;
    private DataOutputStream outputRow;
    private DataOutputStream outputColumn;
    private DataOutputStream outputValue;
    private DataOutputStream outputAction;
    private String path;
    private int t;
    private int currentColumn;
    private double sum;
    private short currentAction;
    private int t_count = 0;
    private int non_zero_count = 0;
    private IResourceManager manager;
    private int maximumLength = 0;
    private boolean hasVariableLength = false;

    public DiskCallback(IResourceManager manager) throws DerivationException {
        if (manager == null) {
            throw new NullPointerException();
        }
        this.path = manager.acquirePath(this);
        this.manager = manager;
        try {
            this.outputRow = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getPath(ROW_FILE)), 16384));
            this.outputColumn = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getPath(COLUMN_FILE)), 16384));
            this.outputValue = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getPath(VALUE_FILE)), 16384));
            this.outputAction = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getPath(ACTION_FILE)), 16384));
        }
        catch (FileNotFoundException e) {
            throw new DerivationException(e);
        }
    }

    private String getPath(String prefix) {
        return String.valueOf(this.path) + prefix;
    }

    @Override
    public IStateSpace done(ISymbolGenerator generator, ArrayList<State> states) throws DerivationException {
        try {
            this.outputRow.close();
            this.outputColumn.close();
            this.outputAction.close();
            this.outputValue.close();
            return new DiskBasedStateSpace(generator, states, this.manager, this.getPath(ROW_FILE), this.getPath(COLUMN_FILE), this.getPath(ACTION_FILE), this.getPath(VALUE_FILE), this.t_count, this.hasVariableLength, this.maximumLength);
        }
        catch (IOException e) {
            throw new DerivationException(e);
        }
    }

    @Override
    public void foundDerivatives(State state, Transition[] transitions) throws DerivationException {
        if (state.stateNumber == 0) {
            this.maximumLength = state.fState.length;
        }
        int oldLength = this.maximumLength;
        this.maximumLength = Math.max(state.fState.length, this.maximumLength);
        if (oldLength != this.maximumLength) {
            this.hasVariableLength = true;
        }
        try {
            this.exploringState(state.stateNumber, transitions.length);
        }
        catch (IOException e) {
            throw new DerivationException(e);
        }
        this.t_count += transitions.length;
        Arrays.sort(transitions);
        int i = 0;
        while (i < transitions.length) {
            Transition t = transitions[i];
            this.foundTransition(state.stateNumber, t.fState.stateNumber, t.fRate, t.fActionId);
            ++i;
        }
    }

    private void exploringState(int state, int numTransitions) throws IOException {
        this.t = numTransitions;
        this.currentColumn = -1;
        this.outputRow.writeInt(this.outputColumn.size() >> 2);
    }

    private void foundTransition(int i, int j, double rate, short action) throws DerivationException {
        if (this.currentColumn != j) {
            if (this.currentColumn != -1) {
                this.writeAction();
            }
            try {
                this.outputColumn.writeInt(j);
                this.outputColumn.writeInt(this.outputValue.size() >> 3);
                this.non_zero_count += 2;
            }
            catch (IOException e) {
                throw new DerivationException(e);
            }
            this.currentColumn = j;
            this.currentAction = action;
            this.sum = 0.0;
        }
        if (this.currentAction != action) {
            this.writeAction();
            this.currentAction = action;
            this.sum = rate;
        } else {
            this.sum += rate;
        }
        --this.t;
        if (this.t == 0) {
            this.writeAction();
        }
    }

    private void writeAction() throws DerivationException {
        try {
            this.outputAction.writeShort(this.currentAction);
            this.outputValue.writeDouble(this.sum);
        }
        catch (IOException e) {
            throw new DerivationException(e);
        }
    }
}

