/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf;

import java.io.IOException;
import java.io.RandomAccessFile;

public class DiskDoubleArray {
    private RandomAccessFile file;
    private int size;
    private static final int BYTE_SIZE = 3;

    public DiskDoubleArray(String file) throws IOException {
        this.file = new RandomAccessFile(file, "r");
        long longSize = this.file.length() >> 3;
        if (longSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("File too long");
        }
        this.size = (int)longSize;
    }

    public double get(int index) throws IOException {
        this.file.seek(index << 3);
        return this.file.readDouble();
    }

    public void getBulk(int from, int to, double[] dest) throws IOException {
        this.file.seek(from << 3);
        int range = to - from;
        int i = 0;
        while (i < range) {
            dest[i] = this.file.readDouble();
            ++i;
        }
    }

    public int size() {
        return this.size;
    }
}

