/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf;

import java.io.IOException;
import java.io.RandomAccessFile;

public class DiskShortArray {
    private static final int BYTE_SIZE = 1;
    private RandomAccessFile file;
    private int size;

    public DiskShortArray(String file) throws IOException {
        this.file = new RandomAccessFile(file, "r");
        long longSize = this.file.length() >> 1;
        if (longSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("File too long");
        }
        this.size = (int)longSize;
    }

    public short get(int index) throws IOException {
        this.file.seek(index << 1);
        short s = this.file.readShort();
        return s;
    }

    public void getBulk(int from, int to, short[] dest) throws IOException {
        this.file.seek(from << 1);
        int range = to - from;
        int i = 0;
        while (i < range) {
            dest[i] = this.file.readShort();
            ++i;
        }
    }

    public int size() {
        return this.size;
    }
}

