/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.IResourceManager;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.MeasurementData;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IStateExplorer;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.MemoryCallback;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.DiskCallback;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.ICallbackListener;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.StateConcurrentHashMap;

public class FrameworkBasedParallelBuilder
implements IStateSpaceBuilder {
    private static final boolean TIME = false;
    private static final String ERROR_MESSAGE = "Thread terminated unexpectedly";
    private static final State EOF_STATE = new State(new short[0], 0);
    private final BlockingQueue<State> unexploredQueue;
    private final BlockingQueue<Result> writesQueue;
    private final StateConcurrentHashMap map;
    private final AtomicInteger waitingStates = new AtomicInteger(1);
    private final ISymbolGenerator generator;
    private IStateExplorer[] explorers;
    private IResourceManager manager;
    private static final int REFRESH_MONITOR = 20000;
    private int id;

    public FrameworkBasedParallelBuilder(IStateExplorer[] explorers, ISymbolGenerator generator, int productId, IResourceManager manager) {
        this.unexploredQueue = new LinkedBlockingQueue<State>();
        this.writesQueue = new LinkedBlockingQueue<Result>();
        this.map = new StateConcurrentHashMap(200, 0.75f, explorers.length);
        this.explorers = explorers;
        this.generator = generator;
        this.id = productId;
        this.manager = manager;
    }

    @Override
    public IStateSpace derive(boolean allowPassiveRates, IProgressMonitor monitor) throws DerivationException {
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        monitor.beginTask(-1);
        short[] initialState = this.generator.getInitialState();
        int hashCode = Arrays.hashCode(initialState);
        State state = new State(initialState, hashCode);
        this.map.putIfAbsent(state, state);
        this.unexploredQueue.add(state);
        ICallbackListener callBack = null;
        if (this.id == 1) {
            callBack = new MemoryCallback();
        } else if (this.id == 0) {
            callBack = new DiskCallback(this.manager);
        }
        WrapperWriterThread writerThread = new WrapperWriterThread(callBack);
        writerThread.start();
        ExplorerThread[] explorerThreads = new ExplorerThread[this.explorers.length];
        int i = 0;
        while (i < this.explorers.length) {
            explorerThreads[i] = new ExplorerThread(initialState.length, this.explorers[i]);
            explorerThreads[i].start();
            ++i;
        }
        try {
            writerThread.join();
            ExplorerThread[] explorerThreadArray = explorerThreads;
            int n = explorerThreads.length;
            int n2 = 0;
            while (n2 < n) {
                ExplorerThread explorer = explorerThreadArray[n2];
                explorer.join();
                ++n2;
            }
        }
        catch (InterruptedException e) {
            throw new DerivationException(ERROR_MESSAGE, e);
        }
        monitor.done();
        return writerThread.done(this.generator);
    }

    private DerivationException createException(State state, String message) {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(message) + " State number: ");
        buf.append(String.valueOf(state.stateNumber) + ". ");
        buf.append("State: ");
        int i = 0;
        while (i < state.fState.length) {
            buf.append(this.generator.getProcessLabel(state.fState[i]));
            if (i != state.fState.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        return new DerivationException(buf.toString());
    }

    @Override
    public MeasurementData getMeasurementData() {
        return null;
    }

    private class ExplorerThread
    extends Thread {
        private IStateExplorer explorer;

        public ExplorerThread(int vectorSize, IStateExplorer explorer) {
            super("Explorer");
            this.explorer = explorer;
        }

        @Override
        public void run() {
            State successor = null;
            Result result = null;
            while (true) {
                try {
                    successor = (State)FrameworkBasedParallelBuilder.this.unexploredQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (successor == EOF_STATE) break;
                try {
                    result = new Result(successor, this.explorer.exploreState(successor.fState));
                }
                catch (DerivationException e1) {
                    e1.printStackTrace();
                }
                Transition[] transitions = result.derivatives;
                int i = 0;
                while (i < transitions.length) {
                    Transition aT = transitions[i];
                    double cfr_ignored_0 = aT.fRate;
                    int hashCode = Arrays.hashCode(aT.fTargetProcess);
                    State state = new State(aT.fTargetProcess, hashCode);
                    State old = FrameworkBasedParallelBuilder.this.map.putIfAbsent(state, state);
                    if (old == null) {
                        aT.fState = state;
                        try {
                            FrameworkBasedParallelBuilder.this.waitingStates.incrementAndGet();
                            FrameworkBasedParallelBuilder.this.unexploredQueue.put(state);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else {
                        aT.fState = old;
                    }
                    ++i;
                }
                try {
                    FrameworkBasedParallelBuilder.this.writesQueue.put(result);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class Result
    implements Comparable<Result> {
        public State state;
        public Transition[] derivatives;

        public Result(State state, Transition[] derivatives) {
            this.state = state;
            this.derivatives = derivatives;
        }

        @Override
        public int compareTo(Result o) {
            return this.state.stateNumber - o.state.stateNumber;
        }
    }

    private class WrapperWriterThread
    extends Thread {
        private final ICallbackListener listener;
        private final ArrayList<State> states;
        private final TreeSet<Result> buffer;

        public WrapperWriterThread(ICallbackListener listener) {
            super("Writer");
            this.buffer = new TreeSet();
            this.listener = listener;
            this.states = new ArrayList(1000);
        }

        public IStateSpace done(ISymbolGenerator generator) throws DerivationException {
            return this.listener.done(generator, this.states);
        }

        @Override
        public void run() {
            int currentState = 0;
            block6: do {
                Result nextResult = null;
                try {
                    nextResult = (Result)FrameworkBasedParallelBuilder.this.writesQueue.take();
                }
                catch (InterruptedException interruptedException) {}
                try {
                    if (nextResult.state.stateNumber == currentState) {
                        this.addState(nextResult);
                        ++currentState;
                        Iterator<Result> i = this.buffer.iterator();
                        while (i.hasNext()) {
                            Result result = i.next();
                            if (result.state.stateNumber != currentState) continue block6;
                            this.addState(result);
                            ++currentState;
                            i.remove();
                        }
                        continue;
                    }
                    this.buffer.add(nextResult);
                }
                catch (DerivationException e) {
                    e.printStackTrace();
                }
            } while (FrameworkBasedParallelBuilder.this.waitingStates.decrementAndGet() > 0);
            int i = 0;
            while (i < FrameworkBasedParallelBuilder.this.explorers.length) {
                try {
                    FrameworkBasedParallelBuilder.this.unexploredQueue.put(EOF_STATE);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }

        private final void addState(Result nextResult) throws DerivationException {
            this.states.add(nextResult.state);
            this.listener.foundDerivatives(nextResult.state, nextResult.derivatives);
        }
    }
}

