/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.DoubleArray;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IntegerArray;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.AbstractStateSpace;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.Generator;

public class MemoryStateSpace
extends AbstractStateSpace {
    private IntegerArray row;
    private IntegerArray column;
    private DoubleArray value;
    private IntegerArray action;

    public MemoryStateSpace(ISymbolGenerator symbolGenerator, ArrayList<State> states, IntegerArray row, IntegerArray column, IntegerArray action, DoubleArray value, boolean hasVariableLengthStates, int maximumLength) {
        super(symbolGenerator, states, hasVariableLengthStates, maximumLength);
        assert (row != null);
        assert (column != null);
        assert (value != null);
        assert (action != null);
        assert (value.size() == action.size());
        this.row = row;
        this.column = column;
        this.value = value;
        this.action = action;
    }

    @Override
    protected FlexCompRowMatrix createGeneratorMatrix() {
        FlexCompRowMatrix genMatrix = null;
        try {
            genMatrix = new FlexCompRowMatrix(this.row.size(), this.row.size());
            int rowSize = this.row.size();
            int i = 0;
            while (i < rowSize) {
                int rangeStart = this.getColumnRangeStart(i);
                int rangeEnd = this.getColumnRangeEnd(i);
                int j = rangeStart;
                while (j < rangeEnd) {
                    int colVal = this.column.get(j);
                    int colRangeStart = this.column.get(j + 1);
                    int colRangeEnd = j < this.column.size() - 3 ? this.column.get(j + 3) : this.value.size();
                    double sum = 0.0;
                    int k = colRangeStart;
                    while (k < colRangeEnd) {
                        sum += this.value.get(k);
                        ++k;
                    }
                    if (sum != 0.0) {
                        genMatrix.set(i, colVal, sum);
                    }
                    j += 2;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return genMatrix;
    }

    @Override
    protected Generator createSimpleGenerator() {
        int[] mrow = new int[this.row.size()];
        double[] diag = new double[this.row.size()];
        int[] matrixCols = new int[this.column.size() / 2];
        double[] values = new double[matrixCols.length];
        int rowSize = this.row.size();
        int colCounter = 0;
        mrow[0] = 0;
        double sum = 0.0;
        double diagsum = 0.0;
        int i = 0;
        while (i < rowSize) {
            mrow[i] = colCounter;
            diagsum = 0.0;
            int rangeStart = this.getColumnRangeStart(i);
            int rangeEnd = this.getColumnRangeEnd(i);
            int j = rangeStart;
            while (j < rangeEnd) {
                int colVal = this.column.get(j);
                int colRangeStart = this.column.get(j + 1);
                int colRangeEnd = j < this.column.size() - 3 ? this.column.get(j + 3) : this.value.size();
                sum = 0.0;
                int k = colRangeStart;
                while (k < colRangeEnd) {
                    sum += this.value.get(k);
                    ++k;
                }
                if (sum != 0.0) {
                    matrixCols[colCounter] = colVal;
                    values[colCounter++] = sum;
                    diagsum += sum;
                }
                j += 2;
            }
            diag[i] = -diagsum;
            ++i;
        }
        Generator generator = new Generator(mrow, matrixCols, values, diag);
        return generator;
    }

    private int getColumnRangeStart(int row) {
        return this.row.get(row);
    }

    private int getColumnRangeEnd(int row) {
        return row < this.row.size() - 1 ? this.row.get(row + 1) : this.column.size();
    }

    private int getValueRangeEnd(int j) {
        return j < this.column.size() - 3 ? this.column.get(j + 3) : this.value.size();
    }

    @Override
    protected void doThroughput(IProgressMonitor monitor) {
        this.throughput = EMPTY_THROUGHPUT;
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        if (this.solution == null) {
            monitor.done();
            return;
        }
        int valueSize = this.value.size();
        HashMap<Short, Double> thMap = new HashMap<Short, Double>();
        int i = 0;
        int size = this.size();
        while (i < size) {
            double prob = this.solution[i];
            int start = this.row.get(i);
            int valueStart = this.column.get(++start);
            int valueEnd = i == size - 1 ? valueSize : this.column.get(this.row.get(i + 1) + 1);
            int k = valueStart;
            while (k < valueEnd) {
                short actionId = (short)this.action.get(k);
                Double d = (Double)thMap.get(actionId);
                if (d == null) {
                    d = 0.0;
                }
                d = d + prob * this.value.get(k);
                thMap.put(actionId, d);
                ++k;
            }
            ++i;
        }
        ThroughputResult[] result = new ThroughputResult[thMap.size()];
        int i2 = 0;
        for (Map.Entry entry : thMap.entrySet()) {
            ThroughputResult r = new ThroughputResult(this.symbolGenerator.getActionLabel((Short)entry.getKey()), (Double)entry.getValue());
            result[i2++] = r;
        }
        this.throughput = result;
        monitor.done();
    }

    @Override
    public String[] getAction(int source, int target) {
        LinkedList<String> labels = new LinkedList<String>();
        int c1 = this.row.get(source);
        int c2 = source == this.row.size() - 1 ? this.column.size() : this.row.get(source + 1);
        boolean found = false;
        int i = c1;
        while (i < c2) {
            if (this.column.get(i) == target) {
                found = true;
                int start = this.column.get(i + 1);
                int stop = i + 3 <= this.column.size() - 1 ? this.column.get(i + 3) : this.action.size();
                int j = start;
                while (j < stop) {
                    labels.add(this.symbolGenerator.getActionLabel((short)this.action.get(j)));
                    ++j;
                }
            }
            if (found) break;
            i += 2;
        }
        return labels.toArray(new String[labels.size()]);
    }

    @Override
    public int[] getIncomingStateIndices(int stateIndex) {
        IntegerArray result = new IntegerArray(20);
        int j = 0;
        while (j < this.column.size()) {
            int columnNumber = this.column.get(j);
            if (columnNumber == stateIndex) {
                result.add(this.find(0, this.row.size() - 1, j));
            }
            j += 2;
        }
        return result.toArray();
    }

    private int find(int rangeStart, int rangeEnd, int index) {
        int i = rangeStart + (rangeEnd - rangeStart >> 1);
        int cstart = this.getColumnRangeStart(i);
        int cend = this.getColumnRangeEnd(i);
        if (index < cend && index >= cstart) {
            return i;
        }
        if (index >= cend) {
            return this.find(i + 1, rangeEnd, index);
        }
        return this.find(rangeStart, i - 1, index);
    }

    @Override
    public int[] getOutgoingStateIndices(int stateIndex) {
        int columnStart = this.getColumnRangeStart(stateIndex);
        int columnEnd = this.getColumnRangeEnd(stateIndex);
        int[] result = new int[columnEnd - columnStart >> 1];
        int j = 0;
        int c = 0;
        j = columnStart;
        while (j < columnEnd) {
            result[c++] = this.column.get(j);
            j += 2;
        }
        return result;
    }

    @Override
    public double getRate(int source, int target) {
        int columnStart = this.getColumnRangeStart(source);
        int columnEnd = this.getColumnRangeEnd(source);
        double sum = 0.0;
        int j = columnStart;
        while (j < columnEnd) {
            if (this.column.get(j) == target) {
                int valueStart = this.column.get(j + 1);
                int valueEnd = this.getValueRangeEnd(j);
                int k = valueStart;
                while (k < valueEnd) {
                    sum += this.value.get(k);
                    ++k;
                }
            }
            j += 2;
        }
        return sum;
    }

    @Override
    public void dispose() {
    }
}

