/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.IResourceManager;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.MeasurementData;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IStateExplorer;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.MemoryCallback;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.OptimisedHashMap;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.DiskCallback;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.ICallbackListener;

public class ParallelBuilder
implements IStateSpaceBuilder {
    private static final String ERROR_MESSAGE = "Thread terminated unexpectedly";
    private static final State EOF_STATE = new State(new short[0], 0);
    private static final Result EOF_RESULT = new Result(EOF_STATE, null);
    private final ISymbolGenerator generator;
    private IStateExplorer[] explorers;
    private IResourceManager manager;
    private static final int REFRESH_MONITOR = 50000;
    private int id;

    public ParallelBuilder(IStateExplorer[] explorers, ISymbolGenerator generator, int productId, IResourceManager manager) {
        this.explorers = explorers;
        this.generator = generator;
        this.id = productId;
        this.manager = manager;
    }

    @Override
    public IStateSpace derive(boolean allowPassiveRates, IProgressMonitor monitor) throws DerivationException {
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        monitor.beginTask(-1);
        final OptimisedHashMap map = new OptimisedHashMap();
        final LinkedBlockingQueue<State> unexploredQueue = new LinkedBlockingQueue<State>();
        final LinkedBlockingQueue<Result> derivativesQueue = new LinkedBlockingQueue<Result>();
        final LinkedBlockingQueue<Result> writesQueue = new LinkedBlockingQueue<Result>();
        ICallbackListener callBack = null;
        if (this.id == 1) {
            callBack = new MemoryCallback();
        } else if (this.id == 0) {
            callBack = new DiskCallback(this.manager);
        }
        final WrapperWriterThread writerThread = new WrapperWriterThread(callBack, writesQueue);
        Thread timer = new Thread(){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                block14: {
                    PrintWriter os = null;
                    try {
                        try {
                            os = new PrintWriter(new BufferedWriter(new FileWriter("c:/tmp/hbf/measure.csv")));
                            os.println("#Obs, Unexplored, Derivatives, State Space, Writes, Buf Size");
                            long start = System.nanoTime();
                            do {
                                Thread.sleep(25L);
                                os.println(String.valueOf((double)(System.nanoTime() - start) / 1000000.0) + ", " + unexploredQueue.size() + ", " + derivativesQueue.size() + ", " + map.size() + ", " + writesQueue.size() + ", " + writerThread.buffer.size());
                            } while (!1.interrupted());
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (os != null) {
                                os.close();
                            }
                            break block14;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
            }
        };
        timer.start();
        short[] initialState = this.generator.getInitialState();
        int hashCode = Arrays.hashCode(initialState);
        State initState = map.putIfNotPresentSync((short[])initialState, (int)hashCode).state;
        unexploredQueue.add(initState);
        int waitingStates = 1;
        writerThread.start();
        ExplorerThread[] explorerThreads = new ExplorerThread[this.explorers.length];
        int i = 0;
        while (i < this.explorers.length) {
            explorerThreads[i] = new ExplorerThread(initialState.length, this.explorers[i], unexploredQueue, derivativesQueue);
            explorerThreads[i].start();
            ++i;
        }
        while (waitingStates != 0) {
            Result result;
            try {
                result = (Result)derivativesQueue.take();
            }
            catch (InterruptedException e) {
                throw new DerivationException(ERROR_MESSAGE, e);
            }
            --waitingStates;
            Transition[] transitions = result.derivatives;
            int i2 = 0;
            while (i2 < transitions.length) {
                Transition aT = transitions[i2];
                if (aT.fRate <= 0.0) {
                    throw this.createException(result.state, "Incomplete model with respect to action: " + this.generator.getActionLabel(aT.fActionId) + ". ");
                }
                hashCode = Arrays.hashCode(aT.fTargetProcess);
                OptimisedHashMap.InsertionResult insertion = map.putIfNotPresentSync(aT.fTargetProcess, hashCode);
                if (!insertion.wasPresent) {
                    try {
                        unexploredQueue.put(insertion.state);
                    }
                    catch (InterruptedException e) {
                        throw new DerivationException(ERROR_MESSAGE, e);
                    }
                    ++waitingStates;
                }
                aT.fState = insertion.state;
                ++i2;
            }
            try {
                writesQueue.put(result);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            writesQueue.put(EOF_RESULT);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            i = 0;
            while (i < explorerThreads.length) {
                unexploredQueue.put(EOF_STATE);
                ++i;
            }
            writerThread.join();
            ExplorerThread[] explorerThreadArray = explorerThreads;
            int n = explorerThreads.length;
            int n2 = 0;
            while (n2 < n) {
                ExplorerThread explorer = explorerThreadArray[n2];
                explorer.join();
                ++n2;
            }
        }
        catch (InterruptedException e) {
            throw new DerivationException(ERROR_MESSAGE, e);
        }
        timer.interrupt();
        try {
            timer.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        monitor.done();
        return writerThread.done(this.generator);
    }

    private DerivationException createException(State state, String message) {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(message) + " State number: ");
        buf.append(String.valueOf(state.stateNumber) + ". ");
        buf.append("State: ");
        int i = 0;
        while (i < state.fState.length) {
            buf.append(this.generator.getProcessLabel(state.fState[i]));
            if (i != state.fState.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        return new DerivationException(buf.toString());
    }

    @Override
    public MeasurementData getMeasurementData() {
        return null;
    }

    private static class ExplorerThread
    extends Thread {
        private BlockingQueue<State> unexploredQueue;
        private BlockingQueue<Result> derivativesQueue;
        private IStateExplorer explorer;

        public ExplorerThread(int vectorSize, IStateExplorer explorer, BlockingQueue<State> unexploredQueue, BlockingQueue<Result> derivativesQueue) {
            super("Explorer");
            this.unexploredQueue = unexploredQueue;
            this.derivativesQueue = derivativesQueue;
            this.explorer = explorer;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        State next;
                        if ((next = this.unexploredQueue.take()) == EOF_STATE) {
                            return;
                        }
                        Result result = new Result(next, this.explorer.exploreState(next.fState));
                        this.derivativesQueue.add(result);
                    }
                }
                catch (DerivationException derivationException) {
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static class Result
    implements Comparable<Result> {
        public State state;
        public Transition[] derivatives;

        public Result(State state, Transition[] derivatives) {
            this.state = state;
            this.derivatives = derivatives;
        }

        @Override
        public int compareTo(Result o) {
            return this.state.stateNumber - o.state.stateNumber;
        }
    }

    private static class WrapperWriterThread
    extends Thread {
        private final ICallbackListener listener;
        private final BlockingQueue<Result> writesQueue;
        final ArrayList<Result> buffer = new ArrayList();
        private final ArrayList<State> states;

        public WrapperWriterThread(ICallbackListener listener, BlockingQueue<Result> writesQueue) {
            super("Writer");
            this.listener = listener;
            this.writesQueue = writesQueue;
            this.states = new ArrayList(1000);
        }

        public IStateSpace done(ISymbolGenerator generator) throws DerivationException {
            return this.listener.done(generator, this.states);
        }

        @Override
        public void run() {
            int currentState = 0;
            block4: while (true) {
                Result nextResult = null;
                try {
                    nextResult = this.writesQueue.take();
                }
                catch (InterruptedException interruptedException) {}
                if (nextResult == EOF_RESULT) {
                    return;
                }
                try {
                    if (nextResult.state.stateNumber == currentState) {
                        this.addState(nextResult);
                        ++currentState;
                        Iterator<Result> i = this.buffer.iterator();
                        while (true) {
                            if (!i.hasNext()) continue block4;
                            Result result = i.next();
                            if (result.state.stateNumber != currentState) continue block4;
                            this.addState(result);
                            ++currentState;
                            i.remove();
                        }
                    }
                    this.buffer.add(nextResult);
                    continue;
                }
                catch (DerivationException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private final void addState(Result nextResult) throws DerivationException {
            this.states.add(nextResult.state);
            this.listener.foundDerivatives(nextResult.state, nextResult.derivatives);
        }
    }
}

