/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive.TransitionEntry;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive.TransitionList;
import uk.ac.ed.inf.pepa.model.Action;
import uk.ac.ed.inf.pepa.model.ActionSet;
import uk.ac.ed.inf.pepa.model.Activity;
import uk.ac.ed.inf.pepa.model.Aggregation;
import uk.ac.ed.inf.pepa.model.Choice;
import uk.ac.ed.inf.pepa.model.Constant;
import uk.ac.ed.inf.pepa.model.Cooperation;
import uk.ac.ed.inf.pepa.model.Hiding;
import uk.ac.ed.inf.pepa.model.NamedAction;
import uk.ac.ed.inf.pepa.model.Prefix;
import uk.ac.ed.inf.pepa.model.Process;
import uk.ac.ed.inf.pepa.model.Rate;
import uk.ac.ed.inf.pepa.model.RateMath;
import uk.ac.ed.inf.pepa.model.SilentAction;
import uk.ac.ed.inf.pepa.model.Visitor;
import uk.ac.ed.inf.pepa.model.internal.AggregationImpl;
import uk.ac.ed.inf.pepa.model.internal.Cloner;
import uk.ac.ed.inf.pepa.model.internal.DoMakePepaProcess;

public class ActivityMultisetVisitor
implements Visitor {
    private TransitionList transitions = new TransitionList();
    private DerivationException exception = null;
    private boolean success = true;
    private static Logger logger = Logger.getLogger(ActivityMultisetVisitor.class);
    private static HashMap<Constant, TransitionList> CONSTANT_CACHE = new HashMap();
    private static final DoMakePepaProcess factory = DoMakePepaProcess.getInstance();

    public static void init() {
        CONSTANT_CACHE.clear();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public DerivationException getCause() {
        return this.exception;
    }

    @Override
    public void visitPrefix(Prefix prefix) {
        this.transitions.addTransition(prefix.getActivity().getAction(), prefix.getActivity().getRate(), prefix.getTargetProcess());
    }

    @Override
    public void visitChoice(Choice choice) {
        choice.getLeftHandSide().accept(this);
        choice.getRightHandSide().accept(this);
    }

    @Override
    public void visitHiding(Hiding hiding) {
        ActivityMultisetVisitor hiddenProcessVisitor = new ActivityMultisetVisitor();
        hiding.getHiddenProcess().accept(hiddenProcessVisitor);
        if (!hiddenProcessVisitor.isSuccess()) {
            this.success = false;
            this.exception = hiddenProcessVisitor.getCause();
            return;
        }
        TransitionList hiddenProcessTransitions = hiddenProcessVisitor.getTransitions();
        Iterator<TransitionEntry> iterator = hiddenProcessTransitions.iterator();
        while (iterator.hasNext()) {
            TransitionEntry transition = iterator.next();
            Hiding hidingTarget = factory.createHiding(transition.target, hiding.getActionSet());
            if (hiding.getActionSet().contains(transition.activity.getAction())) {
                SilentAction silentAction = factory.createSilentAction((NamedAction)transition.activity.getAction());
                this.transitions.addTransition(silentAction, transition.activity.getRate(), hidingTarget);
                continue;
            }
            this.transitions.addTransition(transition.activity.getAction(), transition.activity.getRate(), hidingTarget);
        }
    }

    @Override
    public void visitCooperation(Cooperation cooperation) {
        ActivityMultisetVisitor lhsVisitor = new ActivityMultisetVisitor();
        ActivityMultisetVisitor rhsVisitor = new ActivityMultisetVisitor();
        cooperation.getLeftHandSide().accept(lhsVisitor);
        if (!lhsVisitor.isSuccess()) {
            this.success = false;
            this.exception = lhsVisitor.getCause();
            return;
        }
        cooperation.getRightHandSide().accept(rhsVisitor);
        if (!rhsVisitor.isSuccess()) {
            this.success = false;
            this.exception = rhsVisitor.getCause();
            return;
        }
        ActionSet actions2 = cooperation.getActionSet();
        try {
            this.addNotSynchronisedActivities(lhsVisitor.getTransitions(), cooperation, true);
            this.addNotSynchronisedActivities(rhsVisitor.getTransitions(), cooperation, false);
            this.addSynchronisedActivities(lhsVisitor.getTransitions(), rhsVisitor.getTransitions(), cooperation, actions2);
        }
        catch (DerivationException e) {
            this.success = false;
            this.exception = e;
        }
    }

    @Override
    public void visitConstant(Constant constant) {
        if (CONSTANT_CACHE.containsKey(constant)) {
            this.transitions = CONSTANT_CACHE.get(constant);
            return;
        }
        constant.getBinding().accept(this);
        Iterator<TransitionEntry> iter = this.transitions.iterator();
        while (iter.hasNext()) {
            Process target = iter.next().target;
            if (!constant.getBinding().equals(target)) continue;
            this.transitions.changeTarget(target, constant);
        }
        CONSTANT_CACHE.put(constant, this.transitions);
    }

    @Override
    public void visitAggregation(Aggregation aggregation) {
        for (Map.Entry<Process, Integer> entry : aggregation.getSubProcesses().entrySet()) {
            Process subProcess = entry.getKey();
            Integer numberOfCopies = entry.getValue();
            ActivityMultisetVisitor v = new ActivityMultisetVisitor();
            subProcess.accept(v);
            if (!v.isSuccess()) {
                this.success = false;
                this.exception = v.getCause();
                return;
            }
            Iterator<TransitionEntry> iterator = v.getTransitions().iterator();
            while (iterator.hasNext()) {
                TransitionEntry transition = iterator.next();
                Process target = transition.target;
                AggregationImpl targetAggregation = (AggregationImpl)Cloner.clone(aggregation);
                targetAggregation.increaseCopies(target, 1);
                targetAggregation.decreaseCopies(subProcess, 1);
                this.transitions.addTransition(transition.activity.getAction(), RateMath.mult(transition.activity.getRate(), numberOfCopies), targetAggregation);
            }
        }
    }

    public TransitionList getTransitions() {
        return this.transitions;
    }

    private void addNotSynchronisedActivities(TransitionList transitionsP, Cooperation cooperation, boolean lhs) throws DerivationException {
        ActionSet set = cooperation.getActionSet();
        Iterator<TransitionEntry> iter = transitionsP.iterator();
        Action action = null;
        while (iter.hasNext()) {
            TransitionEntry transition = iter.next();
            action = transition.activity.getAction();
            if (set.contains(action)) continue;
            Cooperation target = null;
            target = lhs ? factory.createCooperation(transition.target, cooperation.getRightHandSide(), set) : factory.createCooperation(cooperation.getLeftHandSide(), transition.target, set);
            this.transitions.addTransition(transition.activity.getAction(), transition.activity.getRate(), target);
        }
    }

    private void addSynchronisedActivities(TransitionList transitionsP, TransitionList transitionsQ, Cooperation process, ActionSet set) throws DerivationException {
        Iterator<Action> syncActionIter = set.iterator();
        Action currentAction = null;
        while (syncActionIter.hasNext()) {
            currentAction = syncActionIter.next();
            if (!transitionsP.containsAction(currentAction) || !transitionsQ.containsAction(currentAction)) continue;
            Rate appP = RateMath.getApparentRate(process.getLeftHandSide(), currentAction);
            Rate appQ = RateMath.getApparentRate(process.getRightHandSide(), currentAction);
            Rate minRate = RateMath.min(appP, appQ);
            List<Activity> activitiesP = transitionsP.getActivity(currentAction);
            List<Activity> activitiesQ = transitionsQ.getActivity(currentAction);
            for (Activity activityP : activitiesP) {
                Rate r1 = RateMath.div(activityP.getRate(), appP);
                for (Activity activityQ : activitiesQ) {
                    Rate r2 = RateMath.div(activityQ.getRate(), appQ);
                    Cooperation target = factory.createCooperation(transitionsP.getTarget(activityP), transitionsQ.getTarget(activityQ), set);
                    Rate finalRate = RateMath.mult(RateMath.mult(r1, r2), minRate);
                    this.transitions.addTransition(currentAction, finalRate, target);
                }
            }
        }
    }
}

